/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.module.push;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import com.bytedance.news.common.settings.api.SettingsData;
import com.bytedance.ttgame.core.SdkConfig;
import com.bytedance.ttgame.module.push.AlarmReceiver;
import com.bytedance.ttgame.module.push.R;
import com.bytedance.ttgame.module.push.TTPushConfig;
import com.bytedance.ttgame.module.push.api.ILocalPushCallback;
import com.bytedance.ttgame.module.push.api.IPushCallback;
import com.bytedance.ttgame.module.push.api.IPushService;
import com.bytedance.ttgame.module.push.api.PushConfig;
import com.bytedance.ttgame.module.push.api.PushInfo;
import com.bytedance.ttgame.sdk.module.core.internal.SdkCoreData;
import com.bytedance.ttgame.sdk.module.utils.NumberUtils;
import com.google.gson.Gson;
import g.main.aut;
import g.optional.push.eb;
import g.optional.push.ec;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0016H\u0016J<\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J<\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016JD\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J<\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\bH\u0016J\u0010\u0010'\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010(\u001a\u00020\bH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/bytedance/ttgame/module/push/PushService;", "Lcom/bytedance/ttgame/module/push/api/IPushService;", "()V", "mAlarmMgr", "Landroid/app/AlarmManager;", "mLocalPushLimit", "", "addLocalNotification", "", "title", "", "body", "calendar", "Ljava/util/Calendar;", "identifier", "pushInfo", "Lcom/bytedance/ttgame/module/push/api/PushInfo;", "callback", "Lcom/bytedance/ttgame/module/push/api/ILocalPushCallback;", "timeInterval", "", "addPushCallback", "Lcom/bytedance/ttgame/module/push/api/IPushCallback;", "addRepeatDayLocalNotification", "addRepeatLocalNotification", "addRepeatMonthLocalNotification", "type", "addRepeatWeekLocalNotification", "fetchSettings", "context", "Landroid/content/Context;", "init", "pushConfig", "Lcom/bytedance/ttgame/module/push/api/PushConfig;", "onInit", "app", "sdkConfig", "Lcom/bytedance/ttgame/core/SdkConfig;", "removeAllLocalNotification", "removeLocalNotification", "restartLocalPush", "Companion", "optional_push_impl_i18nRelease"})
public final class PushService
implements IPushService {
    private AlarmManager mAlarmMgr;
    private int mLocalPushLimit = 6;
    @NotNull
    public static final String TAG = "push_service";
    @NotNull
    public static final String PUSH_SP_NAME = "tt_game_push";
    @NotNull
    public static final String SETTINGS_ID = "GSDKPushSDK";
    @NotNull
    public static final String KEY_TYPE = "type";
    @NotNull
    public static final String KEY_ID = "id";
    @NotNull
    public static final String KEY_REQUEST_CODE = "request_code";
    @NotNull
    public static final String KEY_TITLE = "title";
    @NotNull
    public static final String KEY_BODY = "text";
    @NotNull
    public static final String KEY_TIME_INTERVAL = "time_interval";
    @NotNull
    public static final String KEY_CALENDAR = "calendar";
    @NotNull
    public static final String KEY_OPEN_URL = "open_url";
    @NotNull
    public static final String KEY_EXTRA_STR = "extra_str";
    @NotNull
    public static final String KEY_TRIGGER_AT_MILLIS = "trigger_at_millis";
    public static final int REPEAT_MONTH_BY_DAY_PUSH = 1;
    public static final int REPEAT_MONTH_BY_WEEK_PUSH = 2;
    public static final int REPEAT_WEEK_PUSH = 3;
    public static final int REPEAT_DAY_PUSH = 4;
    public static final int REPEAT_COUNT_DOWN_PUSH = 5;
    public static final int TIMED_PUSH = 6;
    public static final int COUNT_DOWN_PUSH = 7;
    public static final a Companion = new a(null);

    public void addPushCallback(@NotNull IPushCallback iPushCallback) {
        Intrinsics.checkParameterIsNotNull((Object)iPushCallback, (String)"callback");
        ec.a.a().b().add(iPushCallback);
    }

    private final void init(Context context, PushConfig pushConfig) {
        ec.a.a().a(context, pushConfig);
    }

    public final void onInit(@Nullable Context context, @NotNull SdkConfig sdkConfig) {
        Intrinsics.checkParameterIsNotNull((Object)sdkConfig, (String)"sdkConfig");
        TTPushConfig tTPushConfig = (TTPushConfig)new Gson().fromJson(sdkConfig.rawConfig.optString("push", "{}"), TTPushConfig.class);
        if (tTPushConfig != null && tTPushConfig.enable) {
            String string2 = tTPushConfig.pushAppName;
            String string3 = tTPushConfig.pushChannelId;
            String string4 = tTPushConfig.pushChannelName;
            String string5 = tTPushConfig.pushBlackList;
            String string6 = tTPushConfig.appOverseaHost;
            boolean bl2 = tTPushConfig.redBadgeShow;
            int n2 = tTPushConfig.redMaxShowTimes;
            String string7 = tTPushConfig.redShowStrategy;
            String string8 = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"pushAppName");
            PushConfig.Builder builder = new PushConfig.Builder(string8).pushAid(NumberUtils.getInteger((String)sdkConfig.appId, (int)0));
            String string9 = sdkConfig.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"sdkConfig.channel");
            PushConfig pushConfig = builder.applogChannel(string9).pushChannelId(string3).pushChannelName(string4).awakenBlackList(string5).setAppOverseaHost(string6).showRedBadge(bl2).showRedTime(n2).setRedBadgeStrategy(string7).build();
            Context context2 = context;
            if (context2 == null) {
                Intrinsics.throwNpe();
            }
            this.init(context2, pushConfig);
        }
        this.fetchSettings(context);
        this.restartLocalPush();
    }

    public void addLocalNotification(@NotNull String string2, @NotNull String string3, long l2, @Nullable String string4, @Nullable PushInfo pushInfo, @NotNull ILocalPushCallback iLocalPushCallback) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)KEY_TITLE);
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)iLocalPushCallback, (String)"callback");
        if (eb.b() >= this.mLocalPushLimit) {
            Timber.Tree tree = Timber.tag((String)TAG);
            Context context = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"SdkCoreData.appContext");
            tree.w(context.getResources().getString(R.string.gsdk_local_push_limit_error), new Object[0]);
            Context context2 = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"SdkCoreData.appContext");
            String string5 = context2.getResources().getString(R.string.gsdk_local_push_limit_error);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"SdkCoreData.appContext.r\u2026k_local_push_limit_error)");
            iLocalPushCallback.onFail(-1004, string5);
            return;
        }
        Timber.tag((String)TAG).w("Local push (" + string2 + ") will be start after " + l2 + " s", new Object[0]);
        if (this.mAlarmMgr == null) {
            Object object = SdkCoreData.appContext.getSystemService("alarm");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.AlarmManager");
            }
            this.mAlarmMgr = (AlarmManager)object;
        }
        CharSequence charSequence = string4;
        boolean bl2 = false;
        boolean bl3 = false;
        String string6 = charSequence == null || charSequence.length() == 0 ? UUID.randomUUID().toString() : string4;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"if (identifier.isNullOrE\u2026oString() else identifier");
        String string7 = string6;
        eb.a(this.mAlarmMgr, SystemClock.elapsedRealtime() + l2 * (long)1000, 7, string7, string2, string3, 0L, pushInfo, 0);
        iLocalPushCallback.onSuccess(string7);
    }

    public void addLocalNotification(@NotNull String string2, @NotNull String string3, @NotNull Calendar calendar, @Nullable String string4, @Nullable PushInfo pushInfo, @NotNull ILocalPushCallback iLocalPushCallback) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)KEY_TITLE);
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)KEY_CALENDAR);
        Intrinsics.checkParameterIsNotNull((Object)iLocalPushCallback, (String)"callback");
        if (eb.b() >= this.mLocalPushLimit) {
            Timber.Tree tree = Timber.tag((String)TAG);
            Context context = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"SdkCoreData.appContext");
            tree.w(context.getResources().getString(R.string.gsdk_local_push_limit_error), new Object[0]);
            Context context2 = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"SdkCoreData.appContext");
            String string5 = context2.getResources().getString(R.string.gsdk_local_push_limit_error);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"SdkCoreData.appContext.r\u2026k_local_push_limit_error)");
            iLocalPushCallback.onFail(-1004, string5);
            return;
        }
        Timber.tag((String)TAG).w("Local push (" + string2 + ") will be start at " + calendar.getTime().toString(), new Object[0]);
        if (this.mAlarmMgr == null) {
            Object object = SdkCoreData.appContext.getSystemService("alarm");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.AlarmManager");
            }
            this.mAlarmMgr = (AlarmManager)object;
        }
        Object object = string4;
        boolean bl2 = false;
        boolean bl3 = false;
        String string6 = object == null || object.length() == 0 ? UUID.randomUUID().toString() : string4;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"if (identifier.isNullOrE\u2026oString() else identifier");
        String string7 = string6;
        object = eb.b(calendar);
        eb.a(this.mAlarmMgr, ((Calendar)object).getTimeInMillis(), 6, string7, string2, string3, 0L, (Calendar)object, pushInfo, 0);
        iLocalPushCallback.onSuccess(string7);
    }

    public void addRepeatLocalNotification(@NotNull String string2, @NotNull String string3, long l2, @Nullable String string4, @Nullable PushInfo pushInfo, @NotNull ILocalPushCallback iLocalPushCallback) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)KEY_TITLE);
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)iLocalPushCallback, (String)"callback");
        if (eb.b() >= this.mLocalPushLimit) {
            Timber.Tree tree = Timber.tag((String)TAG);
            Context context = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"SdkCoreData.appContext");
            tree.w(context.getResources().getString(R.string.gsdk_local_push_limit_error), new Object[0]);
            Context context2 = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"SdkCoreData.appContext");
            String string5 = context2.getResources().getString(R.string.gsdk_local_push_limit_error);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"SdkCoreData.appContext.r\u2026k_local_push_limit_error)");
            iLocalPushCallback.onFail(-1004, string5);
            return;
        }
        Timber.tag((String)TAG).w("Repeat local push (" + string2 + ") will be start every " + l2 + " s", new Object[0]);
        if (this.mAlarmMgr == null) {
            Object object = SdkCoreData.appContext.getSystemService("alarm");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.AlarmManager");
            }
            this.mAlarmMgr = (AlarmManager)object;
        }
        CharSequence charSequence = string4;
        boolean bl2 = false;
        boolean bl3 = false;
        String string6 = charSequence == null || charSequence.length() == 0 ? UUID.randomUUID().toString() : string4;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"if (identifier.isNullOrE\u2026oString() else identifier");
        String string7 = string6;
        eb.a(this.mAlarmMgr, SystemClock.elapsedRealtime() + l2 * (long)1000, 5, string7, string2, string3, l2 * (long)1000, pushInfo, 0);
        iLocalPushCallback.onSuccess(string7);
    }

    public void addRepeatDayLocalNotification(@NotNull String string2, @NotNull String string3, @NotNull Calendar calendar, @Nullable String string4, @Nullable PushInfo pushInfo, @NotNull ILocalPushCallback iLocalPushCallback) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)KEY_TITLE);
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)KEY_CALENDAR);
        Intrinsics.checkParameterIsNotNull((Object)iLocalPushCallback, (String)"callback");
        if (eb.b() >= this.mLocalPushLimit) {
            Timber.Tree tree = Timber.tag((String)TAG);
            Context context = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"SdkCoreData.appContext");
            tree.w(context.getResources().getString(R.string.gsdk_local_push_limit_error), new Object[0]);
            Context context2 = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"SdkCoreData.appContext");
            String string5 = context2.getResources().getString(R.string.gsdk_local_push_limit_error);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"SdkCoreData.appContext.r\u2026k_local_push_limit_error)");
            iLocalPushCallback.onFail(-1004, string5);
            return;
        }
        Timber.tag((String)TAG).w("RepeatDayLocalNotification calendar " + calendar.getTime().toString(), new Object[0]);
        if (this.mAlarmMgr == null) {
            Object object = SdkCoreData.appContext.getSystemService("alarm");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.AlarmManager");
            }
            this.mAlarmMgr = (AlarmManager)object;
        }
        Object object = string4;
        boolean bl2 = false;
        boolean bl3 = false;
        String string6 = object == null || object.length() == 0 ? UUID.randomUUID().toString() : string4;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"if (identifier.isNullOrE\u2026oString() else identifier");
        String string7 = string6;
        object = eb.a(calendar);
        long l2 = ((Calendar)object).after(Calendar.getInstance()) ? ((Calendar)object).getTimeInMillis() : ((Calendar)object).getTimeInMillis() + 86400000L;
        eb.a(this.mAlarmMgr, l2, 4, string7, string2, string3, 86400000L, (Calendar)object, pushInfo, 0);
        iLocalPushCallback.onSuccess(string7);
    }

    public void addRepeatWeekLocalNotification(@NotNull String string2, @NotNull String string3, @NotNull Calendar calendar, @Nullable String string4, @Nullable PushInfo pushInfo, @NotNull ILocalPushCallback iLocalPushCallback) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)KEY_TITLE);
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)KEY_CALENDAR);
        Intrinsics.checkParameterIsNotNull((Object)iLocalPushCallback, (String)"callback");
        if (eb.b() >= this.mLocalPushLimit) {
            Timber.Tree tree = Timber.tag((String)TAG);
            Context context = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"SdkCoreData.appContext");
            tree.w(context.getResources().getString(R.string.gsdk_local_push_limit_error), new Object[0]);
            Context context2 = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"SdkCoreData.appContext");
            String string5 = context2.getResources().getString(R.string.gsdk_local_push_limit_error);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"SdkCoreData.appContext.r\u2026k_local_push_limit_error)");
            iLocalPushCallback.onFail(-1004, string5);
            return;
        }
        Timber.tag((String)TAG).w("RepeatWeekLocalNotification calendar " + calendar.getTime().toString(), new Object[0]);
        if (this.mAlarmMgr == null) {
            Object object = SdkCoreData.appContext.getSystemService("alarm");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.AlarmManager");
            }
            this.mAlarmMgr = (AlarmManager)object;
        }
        CharSequence charSequence = string4;
        boolean bl2 = false;
        boolean bl3 = false;
        String string6 = charSequence == null || charSequence.length() == 0 ? UUID.randomUUID().toString() : string4;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"if (identifier.isNullOrE\u2026oString() else identifier");
        String string7 = string6;
        long l2 = calendar.after(Calendar.getInstance()) ? calendar.getTimeInMillis() : calendar.getTimeInMillis() + 604800000L;
        eb.a(this.mAlarmMgr, l2, 3, string7, string2, string3, 604800000L, calendar, pushInfo, 0);
        iLocalPushCallback.onSuccess(string7);
    }

    public void addRepeatMonthLocalNotification(int n2, @NotNull String string2, @NotNull String string3, @NotNull Calendar calendar, @Nullable String string4, @Nullable PushInfo pushInfo, @NotNull ILocalPushCallback iLocalPushCallback) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)KEY_TITLE);
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)KEY_CALENDAR);
        Intrinsics.checkParameterIsNotNull((Object)iLocalPushCallback, (String)"callback");
        if (eb.b() >= this.mLocalPushLimit) {
            Timber.Tree tree = Timber.tag((String)TAG);
            Context context = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"SdkCoreData.appContext");
            tree.w(context.getResources().getString(R.string.gsdk_local_push_limit_error), new Object[0]);
            Context context2 = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"SdkCoreData.appContext");
            String string5 = context2.getResources().getString(R.string.gsdk_local_push_limit_error);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"SdkCoreData.appContext.r\u2026k_local_push_limit_error)");
            iLocalPushCallback.onFail(-1004, string5);
            return;
        }
        if (this.mAlarmMgr == null) {
            Object object = SdkCoreData.appContext.getSystemService("alarm");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.AlarmManager");
            }
            this.mAlarmMgr = (AlarmManager)object;
        }
        Object object = string4;
        boolean bl2 = false;
        boolean bl3 = false;
        String string6 = object == null || object.length() == 0 ? UUID.randomUUID().toString() : string4;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"if (identifier.isNullOrE\u2026oString() else identifier");
        String string7 = string6;
        try {
            Timber.tag((String)TAG).w("RepeatMonthLocalNotification calendar " + calendar.getTime().toString(), new Object[0]);
            if (n2 == 1) {
                object = eb.d(calendar);
                eb.a(this.mAlarmMgr, ((Calendar)object).getTimeInMillis(), 1, string7, string2, string3, 2592000000L, (Calendar)object, pushInfo, 0);
            } else {
                object = eb.e(calendar);
                eb.a(this.mAlarmMgr, ((Calendar)object).getTimeInMillis(), 2, string7, string2, string3, 2678400000L, (Calendar)object, pushInfo, 0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Context context = SdkCoreData.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"SdkCoreData.appContext");
            String string8 = context.getResources().getString(R.string.gsdk_local_push_param_error);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"SdkCoreData.appContext.r\u2026k_local_push_param_error)");
            iLocalPushCallback.onFail(-1002, string8);
            return;
        }
        iLocalPushCallback.onSuccess(string7);
    }

    public void removeLocalNotification(@NotNull String string2) {
        PendingIntent pendingIntent;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"identifier");
        if (this.mAlarmMgr == null) {
            Object object = SdkCoreData.appContext.getSystemService("alarm");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.AlarmManager");
            }
            this.mAlarmMgr = (AlarmManager)object;
        }
        if ((pendingIntent = PendingIntent.getBroadcast((Context)SdkCoreData.appContext, (int)eb.c(string2), (Intent)new Intent(SdkCoreData.appContext, AlarmReceiver.class), (int)0x20000000)) != null) {
            AlarmManager alarmManager = this.mAlarmMgr;
            if (alarmManager != null) {
                alarmManager.cancel(pendingIntent);
            }
        }
        eb.b(string2);
    }

    public void removeAllLocalNotification() {
        Map<String, ?> map = eb.a();
        if (map != null) {
            Map<String, ?> map2 = map;
            boolean bl2 = false;
            Map<String, ?> map3 = map2;
            boolean bl3 = false;
            Iterator<Map.Entry<String, ?>> iterator = map3.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ?> entry;
                Map.Entry<String, ?> entry2 = entry = iterator.next();
                boolean bl4 = false;
                this.removeLocalNotification(entry2.getKey());
            }
        }
    }

    private final void fetchSettings(Context context) {
        if (context == null) {
            return;
        }
        aut.b((aut)aut.aZN.cx(context), null, (int)1, null).b((Function1)new Function1<SettingsData, Unit>(){

            public /* synthetic */ Object invoke(Object object) {
                this.a((SettingsData)object);
                return Unit.INSTANCE;
            }

            public final void a(@Nullable SettingsData settingsData) {
                if (settingsData == null) {
                    return;
                }
                try {
                    JSONObject jSONObject = settingsData.getAppSettings().getJSONObject(PushService.SETTINGS_ID);
                    mLocalPushLimit = jSONObject.getInt("localPushMaxCount");
                }
                catch (Exception exception) {
                    Timber.tag((String)PushService.TAG).w(exception.getLocalizedMessage(), new Object[0]);
                }
            }
        });
    }

    private final void restartLocalPush() {
        if (this.mAlarmMgr == null) {
            Object object = SdkCoreData.appContext.getSystemService("alarm");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.AlarmManager");
            }
            this.mAlarmMgr = (AlarmManager)object;
        }
        Map<String, ?> map = eb.a();
        if (map != null) {
            Map<String, ?> map2 = map;
            boolean bl2 = false;
            Map<String, ?> map3 = map2;
            boolean bl3 = false;
            Iterator<Map.Entry<String, ?>> iterator = map3.entrySet().iterator();
            while (iterator.hasNext()) {
                Map<String, Serializable> map4;
                Map.Entry<String, ?> entry;
                Map.Entry<String, ?> entry2 = entry = iterator.next();
                boolean bl4 = false;
                if (eb.a(entry2.getKey()) == null) {
                    continue;
                }
                Intent intent = new Intent(SdkCoreData.appContext, AlarmReceiver.class);
                boolean bl5 = false;
                boolean bl6 = false;
                Intent intent2 = intent;
                boolean bl7 = false;
                intent2.putExtra(KEY_ID, entry2.getKey());
                Serializable serializable = map4.get(KEY_TRIGGER_AT_MILLIS);
                if (!(serializable instanceof Long)) {
                    serializable = null;
                }
                Long l2 = (Long)serializable;
                intent2.putExtra(KEY_TRIGGER_AT_MILLIS, l2 != null ? l2 : 0L);
                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)SdkCoreData.appContext, (int)Random.Default.nextInt(Integer.MAX_VALUE), (Intent)intent2, (int)0);
                AlarmManager alarmManager = this.mAlarmMgr;
                if (alarmManager != null) {
                    alarmManager.set(2, SystemClock.elapsedRealtime(), pendingIntent);
                }
            }
        }
    }

    public static final /* synthetic */ int access$getMLocalPushLimit$p(PushService pushService) {
        return pushService.mLocalPushLimit;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/bytedance/ttgame/module/push/PushService$Companion;", "", "()V", "COUNT_DOWN_PUSH", "", "KEY_BODY", "", "KEY_CALENDAR", "KEY_EXTRA_STR", "KEY_ID", "KEY_OPEN_URL", "KEY_REQUEST_CODE", "KEY_TIME_INTERVAL", "KEY_TITLE", "KEY_TRIGGER_AT_MILLIS", "KEY_TYPE", "PUSH_SP_NAME", "REPEAT_COUNT_DOWN_PUSH", "REPEAT_DAY_PUSH", "REPEAT_MONTH_BY_DAY_PUSH", "REPEAT_MONTH_BY_WEEK_PUSH", "REPEAT_WEEK_PUSH", "SETTINGS_ID", "TAG", "TIMED_PUSH", "optional_push_impl_i18nRelease"})
    public static final class a {
        private a() {
        }

        public /* synthetic */ a(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

