/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.push;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class PushBody
implements Parcelable {
    public static final int TYPE_IMAGE_NONE = 0;
    public static final int TYPE_IMAGE_BIG = 1;
    public static final int TYPE_IMAGE_SMALL = 2;
    public static final String KEY_PASS_THROUGH = "pass_through";
    public long id;
    public long rid64;
    public final String groupId;
    public final boolean showWhen;
    public final String targetSecUid;
    public final boolean needFilterMsgByUid;
    public String extra;
    public String mNotificationChannelId;
    public boolean mIsPassThough;
    public JSONObject msgData;
    public String text;
    public String title;
    public String imageUrl;
    @a
    public int imageType;
    public String open_url;
    public boolean useLED;
    public boolean useSound;
    public boolean useVibrator;
    public int messageType;
    public static final Parcelable.Creator<PushBody> CREATOR = new Parcelable.Creator<PushBody>(){

        public PushBody a(Parcel parcel) {
            return new PushBody(parcel);
        }

        public PushBody[] a(int n2) {
            return new PushBody[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public PushBody(JSONObject jSONObject) {
        this.msgData = jSONObject;
        this.open_url = jSONObject.optString("open_url");
        this.text = jSONObject.optString("text");
        this.title = jSONObject.optString("title");
        this.imageUrl = jSONObject.optString("image_url");
        this.id = jSONObject.optLong("id", 0L);
        this.rid64 = jSONObject.optLong("rid64", 0L);
        this.useLED = PushBody.optBoolean(jSONObject, "use_led", false);
        this.useSound = PushBody.optBoolean(jSONObject, "sound", false);
        this.useVibrator = PushBody.optBoolean(jSONObject, "use_vibrator", false);
        this.imageType = jSONObject.optInt("image_type", 0);
        this.mIsPassThough = jSONObject.optInt(KEY_PASS_THROUGH, 1) > 0;
        this.mNotificationChannelId = jSONObject.optString("notify_channel");
        this.messageType = jSONObject.optInt("msg_from");
        this.groupId = jSONObject.optString("group_id_str");
        this.showWhen = jSONObject.optInt("st", 1) > 0;
        this.targetSecUid = jSONObject.optString("ttpush_sec_target_uid");
        this.needFilterMsgByUid = jSONObject.optInt("ttpush_need_filter_uid", 0) > 0;
        this.extra = jSONObject.optString("extra_str");
    }

    private static boolean optBoolean(JSONObject jSONObject, String string2, boolean bl2) {
        if (jSONObject == null || jSONObject.isNull(string2)) {
            return bl2;
        }
        int n2 = jSONObject.optInt(string2, -1);
        if (n2 >= 1) {
            return true;
        }
        if (n2 == 0) {
            return false;
        }
        return jSONObject.optBoolean(string2, bl2);
    }

    public String getNotificationChannel() {
        return this.mNotificationChannelId;
    }

    public String getOriginData() {
        return this.msgData != null ? this.msgData.toString() : null;
    }

    public String getExtra() {
        return this.extra;
    }

    public boolean checkValid() {
        if (this.id <= 0L) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.open_url)) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)this.groupId);
    }

    public String toString() {
        return "PushBody{groupId='" + this.groupId + '\'' + ", extra='" + this.extra + '\'' + ", mNotificationChannelId='" + this.mNotificationChannelId + '\'' + ", mIsPassThough=" + this.mIsPassThough + ", msgData=" + this.msgData + ", text='" + this.text + '\'' + ", title='" + this.title + '\'' + ", imageUrl='" + this.imageUrl + '\'' + ", imageType=" + this.imageType + ", id=" + this.id + ", open_url='" + this.open_url + '\'' + ", useLED=" + this.useLED + ", useSound=" + this.useSound + ", useVibrator=" + this.useVibrator + ", messageType=" + this.messageType + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeLong(this.id);
        parcel.writeLong(this.rid64);
        parcel.writeString(this.groupId);
        parcel.writeByte(this.showWhen ? (byte)1 : 0);
        parcel.writeString(this.targetSecUid);
        parcel.writeByte(this.needFilterMsgByUid ? (byte)1 : 0);
        parcel.writeString(this.extra);
        parcel.writeString(this.mNotificationChannelId);
        parcel.writeByte(this.mIsPassThough ? (byte)1 : 0);
        parcel.writeString(this.msgData.toString());
        parcel.writeString(this.text);
        parcel.writeString(this.title);
        parcel.writeString(this.imageUrl);
        parcel.writeInt(this.imageType);
        parcel.writeString(this.open_url);
        parcel.writeByte(this.useLED ? (byte)1 : 0);
        parcel.writeByte(this.useSound ? (byte)1 : 0);
        parcel.writeByte(this.useVibrator ? (byte)1 : 0);
        parcel.writeInt(this.messageType);
    }

    protected PushBody(Parcel parcel) {
        this.id = parcel.readLong();
        this.rid64 = parcel.readLong();
        this.groupId = parcel.readString();
        this.showWhen = parcel.readByte() != 0;
        this.targetSecUid = parcel.readString();
        this.needFilterMsgByUid = parcel.readByte() != 0;
        this.extra = parcel.readString();
        this.mNotificationChannelId = parcel.readString();
        this.mIsPassThough = parcel.readByte() != 0;
        try {
            this.msgData = new JSONObject(parcel.readString());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.text = parcel.readString();
        this.title = parcel.readString();
        this.imageUrl = parcel.readString();
        this.imageType = parcel.readInt();
        this.open_url = parcel.readString();
        this.useLED = parcel.readByte() != 0;
        this.useSound = parcel.readByte() != 0;
        this.useVibrator = parcel.readByte() != 0;
        this.messageType = parcel.readInt();
    }

    public static @interface a {
    }
}

