/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message.util;

import com.umeng.message.util.HttpRequest$1;
import com.umeng.message.util.HttpRequest$10;
import com.umeng.message.util.HttpRequest$2;
import com.umeng.message.util.HttpRequest$3;
import com.umeng.message.util.HttpRequest$4;
import com.umeng.message.util.HttpRequest$5;
import com.umeng.message.util.HttpRequest$6;
import com.umeng.message.util.HttpRequest$7;
import com.umeng.message.util.HttpRequest$8;
import com.umeng.message.util.HttpRequest$9;
import com.umeng.message.util.HttpRequest$ConnectionFactory;
import com.umeng.message.util.HttpRequest$HttpRequestException;
import com.umeng.message.util.HttpRequest$a;
import com.umeng.message.util.HttpRequest$e;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpRequest {
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_THRIFT = "application/thrift";
    public static final String ENCODING_GZIP = "gzip";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_DATE = "Date";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String HEADER_REFERER = "Referer";
    public static final String HEADER_SERVER = "Server";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";
    public static final String PARAM_CHARSET = "charset";
    private static final String BOUNDARY = "00content0boundary00";
    private static final String CONTENT_TYPE_MULTIPART = "multipart/form-data; boundary=00content0boundary00";
    private static final String CRLF = "\r\n";
    private static final String[] EMPTY_STRINGS = new String[0];
    private static SSLSocketFactory TRUSTED_FACTORY;
    private static HostnameVerifier TRUSTED_VERIFIER;
    private static int readTimeOut;
    private static int connectTimeout;
    private static HttpRequest$ConnectionFactory CONNECTION_FACTORY;
    private HttpURLConnection connection = null;
    private final URL url;
    private final String requestMethod;
    private HttpRequest$e output;
    private boolean multipart;
    private boolean form;
    private boolean ignoreCloseExceptions = true;
    private boolean uncompress = false;
    private int bufferSize = 8192;
    private String httpProxyHost;
    private int httpProxyPort;

    private static String getValidCharset(String string2) {
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return CHARSET_UTF8;
    }

    private static HostnameVerifier getTrustedVerifier() {
        if (TRUSTED_VERIFIER == null) {
            TRUSTED_VERIFIER = new HttpRequest$1();
        }
        return TRUSTED_VERIFIER;
    }

    private static HostnameVerifier getTrustedVerifier(HttpsURLConnection httpsURLConnection) {
        if (TRUSTED_VERIFIER == null) {
            TRUSTED_VERIFIER = new HttpRequest$3(httpsURLConnection);
        }
        return TRUSTED_VERIFIER;
    }

    private static StringBuilder addPathSeparator(String string2, StringBuilder stringBuilder) {
        if (string2.indexOf(58) + 2 == string2.lastIndexOf(47)) {
            stringBuilder.append('/');
        }
        return stringBuilder;
    }

    private static StringBuilder addParamPrefix(String string2, StringBuilder stringBuilder) {
        int n2 = string2.indexOf(63);
        int n3 = stringBuilder.length() - 1;
        if (n2 == -1) {
            stringBuilder.append('?');
        } else if (n2 < n3 && string2.charAt(n3) != '&') {
            stringBuilder.append('&');
        }
        return stringBuilder;
    }

    public static void setConnectionFactory(HttpRequest$ConnectionFactory httpRequest$ConnectionFactory) {
        CONNECTION_FACTORY = httpRequest$ConnectionFactory == null ? HttpRequest$ConnectionFactory.DEFAULT : httpRequest$ConnectionFactory;
    }

    public static String encode(CharSequence charSequence) {
        URL uRL;
        try {
            uRL = new URL(charSequence.toString());
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
        String string2 = uRL.getHost();
        int n2 = uRL.getPort();
        if (n2 != -1) {
            string2 = string2 + ':' + Integer.toString(n2);
        }
        try {
            String string3 = new URI(uRL.getProtocol(), string2, uRL.getPath(), uRL.getQuery(), null).toASCIIString();
            int n3 = string3.indexOf(63);
            if (n3 > 0 && n3 + 1 < string3.length()) {
                string3 = string3.substring(0, n3 + 1) + string3.substring(n3 + 1).replace("+", "%2B");
            }
            return string3;
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("Parsing URI failed");
            iOException.initCause(uRISyntaxException);
            throw new HttpRequest$HttpRequestException(iOException);
        }
    }

    public static String append(CharSequence charSequence, Map map) {
        String string2 = charSequence.toString();
        if (map == null || map.isEmpty()) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        HttpRequest.addPathSeparator(string2, stringBuilder);
        HttpRequest.addParamPrefix(string2, stringBuilder);
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = iterator.next();
        stringBuilder.append(entry.getKey().toString());
        stringBuilder.append('=');
        Object v2 = entry.getValue();
        if (v2 != null) {
            stringBuilder.append(v2);
        }
        while (iterator.hasNext()) {
            stringBuilder.append('&');
            entry = iterator.next();
            stringBuilder.append(entry.getKey().toString());
            stringBuilder.append('=');
            v2 = entry.getValue();
            if (v2 == null) continue;
            stringBuilder.append(v2);
        }
        return stringBuilder.toString();
    }

    public static String append(CharSequence charSequence, Object ... objectArray) {
        String string2 = charSequence.toString();
        if (objectArray == null || objectArray.length == 0) {
            return string2;
        }
        if (objectArray.length % 2 != 0) {
            throw new IllegalArgumentException("Must specify an even number of parameter names/values");
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        HttpRequest.addPathSeparator(string2, stringBuilder);
        HttpRequest.addParamPrefix(string2, stringBuilder);
        stringBuilder.append(objectArray[0]);
        stringBuilder.append('=');
        Object object = objectArray[1];
        if (object != null) {
            stringBuilder.append(object);
        }
        for (int i2 = 2; i2 < objectArray.length; i2 += 2) {
            stringBuilder.append('&');
            stringBuilder.append(objectArray[i2]);
            stringBuilder.append('=');
            object = objectArray[i2 + 1];
            if (object == null) continue;
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    public static HttpRequest get(CharSequence charSequence) {
        return new HttpRequest(charSequence, METHOD_GET);
    }

    public static HttpRequest get(URL uRL) {
        return new HttpRequest(uRL, METHOD_GET);
    }

    public static HttpRequest get(CharSequence charSequence, Map map, boolean bl2) {
        String string2 = HttpRequest.append(charSequence, map);
        return HttpRequest.get(bl2 ? HttpRequest.encode(string2) : string2);
    }

    public static HttpRequest get(CharSequence charSequence, boolean bl2, Object ... objectArray) {
        String string2 = HttpRequest.append(charSequence, objectArray);
        return HttpRequest.get(bl2 ? HttpRequest.encode(string2) : string2);
    }

    public static HttpRequest post(CharSequence charSequence) {
        HttpRequest httpRequest = new HttpRequest(charSequence, METHOD_POST);
        httpRequest.getConnection().setConnectTimeout(connectTimeout);
        httpRequest.getConnection().setReadTimeout(readTimeOut);
        return httpRequest;
    }

    public static HttpRequest post(URL uRL) {
        HttpRequest httpRequest = new HttpRequest(uRL, METHOD_POST);
        httpRequest.getConnection().setConnectTimeout(connectTimeout);
        httpRequest.getConnection().setReadTimeout(readTimeOut);
        return httpRequest;
    }

    public static HttpRequest post(CharSequence charSequence, Map map, boolean bl2) {
        String string2 = HttpRequest.append(charSequence, map);
        return HttpRequest.post(bl2 ? HttpRequest.encode(string2) : string2);
    }

    public static HttpRequest post(CharSequence charSequence, boolean bl2, Object ... objectArray) {
        String string2 = HttpRequest.append(charSequence, objectArray);
        return HttpRequest.post(bl2 ? HttpRequest.encode(string2) : string2);
    }

    public static HttpRequest put(CharSequence charSequence) {
        return new HttpRequest(charSequence, METHOD_PUT);
    }

    public static HttpRequest put(URL uRL) {
        return new HttpRequest(uRL, METHOD_PUT);
    }

    public static HttpRequest put(CharSequence charSequence, Map map, boolean bl2) {
        String string2 = HttpRequest.append(charSequence, map);
        return HttpRequest.put(bl2 ? HttpRequest.encode(string2) : string2);
    }

    public static HttpRequest put(CharSequence charSequence, boolean bl2, Object ... objectArray) {
        String string2 = HttpRequest.append(charSequence, objectArray);
        return HttpRequest.put(bl2 ? HttpRequest.encode(string2) : string2);
    }

    public static HttpRequest delete(CharSequence charSequence) {
        return new HttpRequest(charSequence, METHOD_DELETE);
    }

    public static HttpRequest delete(URL uRL) {
        return new HttpRequest(uRL, METHOD_DELETE);
    }

    public static HttpRequest delete(CharSequence charSequence, Map map, boolean bl2) {
        String string2 = HttpRequest.append(charSequence, map);
        return HttpRequest.delete(bl2 ? HttpRequest.encode(string2) : string2);
    }

    public static HttpRequest delete(CharSequence charSequence, boolean bl2, Object ... objectArray) {
        String string2 = HttpRequest.append(charSequence, objectArray);
        return HttpRequest.delete(bl2 ? HttpRequest.encode(string2) : string2);
    }

    public static HttpRequest head(CharSequence charSequence) {
        return new HttpRequest(charSequence, METHOD_HEAD);
    }

    public static HttpRequest head(URL uRL) {
        return new HttpRequest(uRL, METHOD_HEAD);
    }

    public static HttpRequest head(CharSequence charSequence, Map map, boolean bl2) {
        String string2 = HttpRequest.append(charSequence, map);
        return HttpRequest.head(bl2 ? HttpRequest.encode(string2) : string2);
    }

    public static HttpRequest head(CharSequence charSequence, boolean bl2, Object ... objectArray) {
        String string2 = HttpRequest.append(charSequence, objectArray);
        return HttpRequest.head(bl2 ? HttpRequest.encode(string2) : string2);
    }

    public static HttpRequest options(CharSequence charSequence) {
        return new HttpRequest(charSequence, METHOD_OPTIONS);
    }

    public static HttpRequest options(URL uRL) {
        return new HttpRequest(uRL, METHOD_OPTIONS);
    }

    public static HttpRequest trace(CharSequence charSequence) {
        return new HttpRequest(charSequence, METHOD_TRACE);
    }

    public static HttpRequest trace(URL uRL) {
        return new HttpRequest(uRL, METHOD_TRACE);
    }

    public static void keepAlive(boolean bl2) {
        HttpRequest.setProperty("http.keepAlive", Boolean.toString(bl2));
    }

    public static void proxyHost(String string2) {
        HttpRequest.setProperty("http.proxyHost", string2);
        HttpRequest.setProperty("https.proxyHost", string2);
    }

    public static void proxyPort(int n2) {
        String string2 = Integer.toString(n2);
        HttpRequest.setProperty("http.proxyPort", string2);
        HttpRequest.setProperty("https.proxyPort", string2);
    }

    public static void nonProxyHosts(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = stringArray.length - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(stringArray[i2]).append('|');
            }
            stringBuilder.append(stringArray[n2]);
            HttpRequest.setProperty("http.nonProxyHosts", stringBuilder.toString());
        } else {
            HttpRequest.setProperty("http.nonProxyHosts", null);
        }
    }

    private static String setProperty(String string2, String string3) {
        PrivilegedAction privilegedAction = string3 != null ? new HttpRequest$4(string2, string3) : new HttpRequest$5(string2);
        return (String)AccessController.doPrivileged(privilegedAction);
    }

    public HttpRequest(CharSequence charSequence, String string2) {
        try {
            this.url = new URL(charSequence.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new HttpRequest$HttpRequestException(malformedURLException);
        }
        this.requestMethod = string2;
    }

    public HttpRequest(URL uRL, String string2) {
        this.url = uRL;
        this.requestMethod = string2;
    }

    private Proxy createProxy() {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.httpProxyHost, this.httpProxyPort));
    }

    private HttpURLConnection createConnection() {
        try {
            HttpURLConnection httpURLConnection = this.httpProxyHost != null ? CONNECTION_FACTORY.create(this.url, this.createProxy()) : CONNECTION_FACTORY.create(this.url);
            httpURLConnection.setRequestMethod(this.requestMethod);
            return httpURLConnection;
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
    }

    public String toString() {
        return this.method() + ' ' + this.url();
    }

    public HttpURLConnection getConnection() {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        return this.connection;
    }

    public HttpRequest ignoreCloseExceptions(boolean bl2) {
        this.ignoreCloseExceptions = bl2;
        return this;
    }

    public boolean ignoreCloseExceptions() {
        return this.ignoreCloseExceptions;
    }

    public int code() {
        try {
            this.closeOutput();
            return this.getConnection().getResponseCode();
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
    }

    public HttpRequest code(AtomicInteger atomicInteger) {
        atomicInteger.set(this.code());
        return this;
    }

    public boolean ok() {
        return 200 == this.code();
    }

    public boolean created() {
        return 201 == this.code();
    }

    public boolean serverError() {
        return 500 == this.code();
    }

    public boolean badRequest() {
        return 400 == this.code();
    }

    public boolean notFound() {
        return 404 == this.code();
    }

    public boolean notModified() {
        return 304 == this.code();
    }

    public String message() {
        try {
            this.closeOutput();
            return this.getConnection().getResponseMessage();
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
    }

    public HttpRequest disconnect() {
        this.getConnection().disconnect();
        return this;
    }

    public HttpRequest chunk(int n2) {
        this.getConnection().setChunkedStreamingMode(n2);
        return this;
    }

    public HttpRequest bufferSize(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Size must be greater than zero");
        }
        this.bufferSize = n2;
        return this;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public HttpRequest uncompress(boolean bl2) {
        this.uncompress = bl2;
        return this;
    }

    protected ByteArrayOutputStream byteStream() {
        int n2 = this.contentLength();
        if (n2 > 0) {
            return new ByteArrayOutputStream(n2);
        }
        return new ByteArrayOutputStream();
    }

    public String body(String string2) {
        ByteArrayOutputStream byteArrayOutputStream = this.byteStream();
        try {
            this.copy(this.buffer(), byteArrayOutputStream);
            return byteArrayOutputStream.toString(HttpRequest.getValidCharset(string2));
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
    }

    public String body() {
        return this.body(this.charset());
    }

    public HttpRequest body(AtomicReference atomicReference) {
        atomicReference.set(this.body());
        return this;
    }

    public HttpRequest body(AtomicReference atomicReference, String string2) {
        atomicReference.set(this.body(string2));
        return this;
    }

    public boolean isBodyEmpty() {
        return this.contentLength() == 0;
    }

    public byte[] bytes() {
        ByteArrayOutputStream byteArrayOutputStream = this.byteStream();
        try {
            this.copy(this.buffer(), byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BufferedInputStream buffer() {
        return new BufferedInputStream(this.stream(), this.bufferSize);
    }

    public InputStream stream() {
        InputStream inputStream;
        if (this.code() < 400) {
            try {
                inputStream = this.getConnection().getInputStream();
            }
            catch (IOException iOException) {
                throw new HttpRequest$HttpRequestException(iOException);
            }
        }
        inputStream = this.getConnection().getErrorStream();
        if (inputStream == null) {
            try {
                inputStream = this.getConnection().getInputStream();
            }
            catch (IOException iOException) {
                throw new HttpRequest$HttpRequestException(iOException);
            }
        }
        if (!this.uncompress || !ENCODING_GZIP.equals(this.contentEncoding())) {
            return inputStream;
        }
        try {
            return new GZIPInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
    }

    public InputStreamReader reader(String string2) {
        try {
            return new InputStreamReader(this.stream(), HttpRequest.getValidCharset(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new HttpRequest$HttpRequestException(unsupportedEncodingException);
        }
    }

    public InputStreamReader reader() {
        return this.reader(this.charset());
    }

    public BufferedReader bufferedReader(String string2) {
        return new BufferedReader(this.reader(string2), this.bufferSize);
    }

    public BufferedReader bufferedReader() {
        return this.bufferedReader(this.charset());
    }

    public HttpRequest receive(File file) {
        BufferedOutputStream bufferedOutputStream;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), this.bufferSize);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HttpRequest$HttpRequestException(fileNotFoundException);
        }
        return (HttpRequest)new HttpRequest$6(this, bufferedOutputStream, this.ignoreCloseExceptions, bufferedOutputStream).call();
    }

    public HttpRequest receive(OutputStream outputStream) {
        try {
            return this.copy(this.buffer(), outputStream);
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
    }

    public HttpRequest receive(PrintStream printStream) {
        return this.receive((OutputStream)printStream);
    }

    public HttpRequest receive(Appendable appendable) {
        BufferedReader bufferedReader = this.bufferedReader();
        return (HttpRequest)new HttpRequest$7(this, bufferedReader, this.ignoreCloseExceptions, bufferedReader, appendable).call();
    }

    public HttpRequest receive(Writer writer) {
        BufferedReader bufferedReader = this.bufferedReader();
        return (HttpRequest)new HttpRequest$8(this, bufferedReader, this.ignoreCloseExceptions, bufferedReader, writer).call();
    }

    public HttpRequest readTimeout(int n2) {
        this.getConnection().setReadTimeout(n2);
        return this;
    }

    public HttpRequest connectTimeout(int n2) {
        this.getConnection().setConnectTimeout(n2);
        return this;
    }

    public HttpRequest header(String string2, String string3) {
        this.getConnection().setRequestProperty(string2, string3);
        return this;
    }

    public HttpRequest header(String string2, Number number) {
        return this.header(string2, number != null ? number.toString() : null);
    }

    public HttpRequest headers(Map map) {
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                this.header(entry);
            }
        }
        return this;
    }

    public HttpRequest header(Map.Entry entry) {
        return this.header((String)entry.getKey(), (String)entry.getValue());
    }

    public String header(String string2) {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderField(string2);
    }

    public Map headers() {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFields();
    }

    public long dateHeader(String string2) {
        return this.dateHeader(string2, -1L);
    }

    public long dateHeader(String string2, long l2) {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFieldDate(string2, l2);
    }

    public int intHeader(String string2) {
        return this.intHeader(string2, -1);
    }

    public int intHeader(String string2, int n2) {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFieldInt(string2, n2);
    }

    public String[] headers(String string2) {
        Map map = this.headers();
        if (map == null || map.isEmpty()) {
            return EMPTY_STRINGS;
        }
        List list = (List)map.get(string2);
        if (list != null && !list.isEmpty()) {
            return list.toArray(new String[list.size()]);
        }
        return EMPTY_STRINGS;
    }

    public String parameter(String string2, String string3) {
        return this.getParam(this.header(string2), string3);
    }

    public Map parameters(String string2) {
        return this.getParams(this.header(string2));
    }

    protected Map getParams(String string2) {
        if (string2 == null || string2.length() == 0) {
            return Collections.emptyMap();
        }
        int n2 = string2.length();
        int n3 = string2.indexOf(59) + 1;
        if (n3 == 0 || n3 == n2) {
            return Collections.emptyMap();
        }
        int n4 = string2.indexOf(59, n3);
        if (n4 == -1) {
            n4 = n2;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (n3 < n4) {
            String string3;
            int n5;
            String string4;
            int n6 = string2.indexOf(61, n3);
            if (n6 != -1 && n6 < n4 && (string4 = string2.substring(n3, n6).trim()).length() > 0 && (n5 = (string3 = string2.substring(n6 + 1, n4).trim()).length()) != 0) {
                if (n5 > 2 && '\"' == string3.charAt(0) && '\"' == string3.charAt(n5 - 1)) {
                    linkedHashMap.put(string4, string3.substring(1, n5 - 1));
                } else {
                    linkedHashMap.put(string4, string3);
                }
            }
            if ((n4 = string2.indexOf(59, n3 = n4 + 1)) != -1) continue;
            n4 = n2;
        }
        return linkedHashMap;
    }

    protected String getParam(String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        int n2 = string2.length();
        int n3 = string2.indexOf(59) + 1;
        if (n3 == 0 || n3 == n2) {
            return null;
        }
        int n4 = string2.indexOf(59, n3);
        if (n4 == -1) {
            n4 = n2;
        }
        while (n3 < n4) {
            String string4;
            int n5;
            int n6 = string2.indexOf(61, n3);
            if (n6 != -1 && n6 < n4 && string3.equals(string2.substring(n3, n6).trim()) && (n5 = (string4 = string2.substring(n6 + 1, n4).trim()).length()) != 0) {
                if (n5 > 2 && '\"' == string4.charAt(0) && '\"' == string4.charAt(n5 - 1)) {
                    return string4.substring(1, n5 - 1);
                }
                return string4;
            }
            n3 = n4 + 1;
            if ((n4 = string2.indexOf(59, n3)) != -1) continue;
            n4 = n2;
        }
        return null;
    }

    public String charset() {
        return this.parameter(HEADER_CONTENT_TYPE, PARAM_CHARSET);
    }

    public HttpRequest userAgent(String string2) {
        return this.header(HEADER_USER_AGENT, string2);
    }

    public HttpRequest referer(String string2) {
        return this.header(HEADER_REFERER, string2);
    }

    public HttpRequest useCaches(boolean bl2) {
        this.getConnection().setUseCaches(bl2);
        return this;
    }

    public HttpRequest acceptEncoding(String string2) {
        return this.header(HEADER_ACCEPT_ENCODING, string2);
    }

    public HttpRequest acceptGzipEncoding() {
        return this.acceptEncoding(ENCODING_GZIP);
    }

    public HttpRequest acceptCharset(String string2) {
        return this.header(HEADER_ACCEPT_CHARSET, string2);
    }

    public String contentEncoding() {
        return this.header(HEADER_CONTENT_ENCODING);
    }

    public String server() {
        return this.header(HEADER_SERVER);
    }

    public long date() {
        return this.dateHeader(HEADER_DATE);
    }

    public String cacheControl() {
        return this.header(HEADER_CACHE_CONTROL);
    }

    public String eTag() {
        return this.header(HEADER_ETAG);
    }

    public long expires() {
        return this.dateHeader(HEADER_EXPIRES);
    }

    public long lastModified() {
        return this.dateHeader(HEADER_LAST_MODIFIED);
    }

    public String location() {
        return this.header(HEADER_LOCATION);
    }

    public HttpRequest authorization(String string2) {
        return this.header(HEADER_AUTHORIZATION, string2);
    }

    public HttpRequest proxyAuthorization(String string2) {
        return this.header(HEADER_PROXY_AUTHORIZATION, string2);
    }

    public HttpRequest basic(String string2, String string3) {
        return this.authorization("Basic " + HttpRequest$a.a(string2 + ':' + string3));
    }

    public HttpRequest proxyBasic(String string2, String string3) {
        return this.proxyAuthorization("Basic " + HttpRequest$a.a(string2 + ':' + string3));
    }

    public HttpRequest ifModifiedSince(long l2) {
        this.getConnection().setIfModifiedSince(l2);
        return this;
    }

    public HttpRequest ifNoneMatch(String string2) {
        return this.header(HEADER_IF_NONE_MATCH, string2);
    }

    public HttpRequest contentType(String string2) {
        return this.contentType(string2, null);
    }

    public HttpRequest contentType(String string2, String string3) {
        if (string3 != null && string3.length() > 0) {
            String string4 = "; charset=";
            return this.header(HEADER_CONTENT_TYPE, string2 + "; charset=" + string3);
        }
        return this.header(HEADER_CONTENT_TYPE, string2);
    }

    public String contentType() {
        return this.header(HEADER_CONTENT_TYPE);
    }

    public int contentLength() {
        return this.intHeader(HEADER_CONTENT_LENGTH);
    }

    public HttpRequest contentLength(String string2) {
        return this.contentLength(Integer.parseInt(string2));
    }

    public HttpRequest contentLength(int n2) {
        this.getConnection().setFixedLengthStreamingMode(n2);
        return this;
    }

    public HttpRequest accept(String string2) {
        return this.header(HEADER_ACCEPT, string2);
    }

    public HttpRequest acceptJson() {
        return this.accept(CONTENT_TYPE_JSON);
    }

    protected HttpRequest copy(InputStream inputStream, OutputStream outputStream) {
        return (HttpRequest)new HttpRequest$9(this, inputStream, this.ignoreCloseExceptions, inputStream, outputStream).call();
    }

    protected HttpRequest copy(Reader reader, Writer writer) {
        return (HttpRequest)new HttpRequest$10(this, reader, this.ignoreCloseExceptions, reader, writer).call();
    }

    protected HttpRequest closeOutput() {
        if (this.output == null) {
            return this;
        }
        if (this.multipart) {
            this.output.a("\r\n--00content0boundary00--\r\n");
        }
        if (this.ignoreCloseExceptions) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {}
        } else {
            this.output.close();
        }
        this.output = null;
        return this;
    }

    protected HttpRequest closeOutputQuietly() {
        try {
            return this.closeOutput();
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
    }

    protected HttpRequest openOutput() {
        if (this.output != null) {
            return this;
        }
        this.getConnection().setDoOutput(true);
        String string2 = this.getParam(this.getConnection().getRequestProperty(HEADER_CONTENT_TYPE), PARAM_CHARSET);
        this.output = new HttpRequest$e(this.getConnection().getOutputStream(), string2, this.bufferSize);
        return this;
    }

    protected HttpRequest startPart() {
        if (!this.multipart) {
            this.multipart = true;
            this.contentType(CONTENT_TYPE_MULTIPART).openOutput();
            this.output.a("--00content0boundary00\r\n");
        } else {
            this.output.a("\r\n--00content0boundary00\r\n");
        }
        return this;
    }

    protected HttpRequest writePartHeader(String string2, String string3) {
        return this.writePartHeader(string2, string3, null);
    }

    protected HttpRequest writePartHeader(String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("form-data; name=\"").append(string2);
        if (string3 != null) {
            stringBuilder.append("\"; filename=\"").append(string3);
        }
        stringBuilder.append('\"');
        this.partHeader("Content-Disposition", stringBuilder.toString());
        if (string4 != null) {
            this.partHeader(HEADER_CONTENT_TYPE, string4);
        }
        return this.send(CRLF);
    }

    public HttpRequest part(String string2, String string3) {
        return this.part(string2, null, string3);
    }

    public HttpRequest part(String string2, String string3, String string4) {
        return this.part(string2, string3, null, string4);
    }

    public HttpRequest part(String string2, String string3, String string4, String string5) {
        try {
            this.startPart();
            this.writePartHeader(string2, string3, string4);
            this.output.a(string5);
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
        return this;
    }

    public HttpRequest part(String string2, Number number) {
        return this.part(string2, null, number);
    }

    public HttpRequest part(String string2, String string3, Number number) {
        return this.part(string2, string3, number != null ? number.toString() : null);
    }

    public HttpRequest part(String string2, File file) {
        return this.part(string2, null, file);
    }

    public HttpRequest part(String string2, String string3, File file) {
        return this.part(string2, string3, null, file);
    }

    public HttpRequest part(String string2, String string3, String string4, File file) {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
        return this.part(string2, string3, string4, bufferedInputStream);
    }

    public HttpRequest part(String string2, InputStream inputStream) {
        return this.part(string2, null, null, inputStream);
    }

    public HttpRequest part(String string2, String string3, String string4, InputStream inputStream) {
        try {
            this.startPart();
            this.writePartHeader(string2, string3, string4);
            this.copy(inputStream, this.output);
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
        return this;
    }

    public HttpRequest partHeader(String string2, String string3) {
        return this.send(string2).send(": ").send(string3).send(CRLF);
    }

    public HttpRequest send(File file) {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HttpRequest$HttpRequestException(fileNotFoundException);
        }
        return this.send(bufferedInputStream);
    }

    public HttpRequest send(byte[] byArray) {
        return this.send(new ByteArrayInputStream(byArray));
    }

    public HttpRequest send(InputStream inputStream) {
        try {
            this.openOutput();
            this.copy(inputStream, this.output);
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
        return this;
    }

    public HttpRequest send(Reader reader) {
        try {
            this.openOutput();
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.output, HttpRequest$e.a(this.output).charset());
        return (HttpRequest)new HttpRequest$2(this, outputStreamWriter, reader, outputStreamWriter).call();
    }

    public HttpRequest send(CharSequence charSequence) {
        try {
            this.openOutput();
            this.output.a(charSequence.toString());
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
        return this;
    }

    public OutputStreamWriter writer() {
        try {
            this.openOutput();
            return new OutputStreamWriter((OutputStream)this.output, HttpRequest$e.a(this.output).charset());
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
    }

    public HttpRequest form(Map map) {
        return this.form(map, CHARSET_UTF8);
    }

    public HttpRequest form(Map.Entry entry) {
        return this.form(entry, CHARSET_UTF8);
    }

    public HttpRequest form(Map.Entry entry, String string2) {
        return this.form(entry.getKey(), entry.getValue(), string2);
    }

    public HttpRequest form(Object object, Object object2) {
        return this.form(object, object2, CHARSET_UTF8);
    }

    public HttpRequest form(Object object, Object object2, String string2) {
        boolean bl2;
        boolean bl3 = bl2 = !this.form;
        if (bl2) {
            this.contentType(CONTENT_TYPE_FORM, string2);
            this.form = true;
        }
        string2 = HttpRequest.getValidCharset(string2);
        try {
            this.openOutput();
            if (!bl2) {
                this.output.write(38);
            }
            this.output.a(URLEncoder.encode(object.toString(), string2));
            this.output.write(61);
            if (object2 != null) {
                this.output.a(URLEncoder.encode(object2.toString(), string2));
            }
        }
        catch (IOException iOException) {
            throw new HttpRequest$HttpRequestException(iOException);
        }
        return this;
    }

    public HttpRequest form(Map map, String string2) {
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                this.form(entry, string2);
            }
        }
        return this;
    }

    public HttpRequest trustAllHosts() {
        HttpURLConnection httpURLConnection = this.getConnection();
        if (httpURLConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(HttpRequest.getTrustedVerifier());
        }
        return this;
    }

    public HttpRequest trustHosts() {
        HttpURLConnection httpURLConnection = this.getConnection();
        if (httpURLConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(HttpRequest.getTrustedVerifier((HttpsURLConnection)httpURLConnection));
        }
        return this;
    }

    public URL url() {
        return this.getConnection().getURL();
    }

    public String method() {
        return this.getConnection().getRequestMethod();
    }

    public HttpRequest useProxy(String string2, int n2) {
        if (this.connection != null) {
            throw new IllegalStateException("The connection has already been created. This method must be called before reading or writing to the request.");
        }
        this.httpProxyHost = string2;
        this.httpProxyPort = n2;
        return this;
    }

    public HttpRequest followRedirects(boolean bl2) {
        this.getConnection();
        HttpURLConnection.setFollowRedirects(bl2);
        return this;
    }

    static /* synthetic */ String access$000(String string2) {
        return HttpRequest.getValidCharset(string2);
    }

    static /* synthetic */ int access$100(HttpRequest httpRequest) {
        return httpRequest.bufferSize;
    }

    static {
        readTimeOut = 60000;
        connectTimeout = 60000;
        CONNECTION_FACTORY = HttpRequest$ConnectionFactory.DEFAULT;
    }
}

