/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message.common;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.umeng.commonsdk.debug.UMLog;
import com.umeng.commonsdk.utils.UMUtils;
import com.umeng.message.PushAgent;
import com.umeng.message.proguard.c;
import com.umeng.message.proguard.h;
import com.umeng.message.util.a;
import g.optional.push.fe;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.microedition.khronos.opengles.GL10;

public class UmengMessageDeviceConfig {
    private static final String b = UmengMessageDeviceConfig.class.getSimpleName();
    protected static final String a = "Unknown";
    private static final String c = "2G/3G";
    private static final String d = "Wi-Fi";
    public static final int DEFAULT_TIMEZONE = 8;
    private static boolean e = false;

    public static boolean isAppInstalled(String string2, Context context) {
        PackageManager packageManager = context.getPackageManager();
        boolean bl2 = false;
        try {
            packageManager.getPackageInfo(string2, 1);
            bl2 = true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            bl2 = false;
        }
        return bl2;
    }

    public static boolean isChinese(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        return locale.toString().equals(Locale.CHINA.toString());
    }

    public static boolean isScreenPortrait(Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }

    public static String getAppVersionCode(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            int n2 = packageInfo.versionCode;
            return String.valueOf(n2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return a;
        }
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return a;
        }
    }

    public static boolean checkPermission(Context context, String string2) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.checkPermission(string2, context.getPackageName()) == 0;
    }

    public static String getAppLabel(Context context) {
        ApplicationInfo applicationInfo;
        PackageManager packageManager = context.getPackageManager();
        try {
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            applicationInfo = null;
        }
        String string2 = applicationInfo != null ? packageManager.getApplicationLabel(applicationInfo) : "";
        return string2;
    }

    public static String[] getGPU(GL10 gL10) {
        try {
            String[] stringArray = new String[2];
            String string2 = gL10.glGetString(7936);
            String string3 = gL10.glGetString(7937);
            stringArray[0] = string2;
            stringArray[1] = string3;
            return stringArray;
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"Could not read gpu infor:", exception.getMessage()});
            return new String[0];
        }
    }

    public static String getCPU() {
        String string2 = null;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader("/proc/cpuinfo");
            if (fileReader != null) {
                try {
                    bufferedReader = new BufferedReader(fileReader, 1024);
                    string2 = bufferedReader.readLine();
                    bufferedReader.close();
                    fileReader.close();
                }
                catch (IOException iOException) {
                    UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"Could not read from file /proc/cpuinfo", iOException.getMessage()});
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"Could not open file /proc/cpuinfo", fileNotFoundException.getMessage()});
        }
        if (string2 != null) {
            int n2 = string2.indexOf(58) + 1;
            string2 = string2.substring(n2).trim();
        }
        return string2;
    }

    public static String getDeviceId(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"No IMEI."});
        }
        String string2 = "";
        try {
            if (UmengMessageDeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                string2 = telephonyManager.getDeviceId();
            }
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"No IMEI.", exception.getMessage()});
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"No IMEI."});
            string2 = UmengMessageDeviceConfig.getMac(context);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"Failed to take mac as IMEI. Try to use Secure.ANDROID_ID instead."});
                string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"getDeviceId: Secure.ANDROID_ID: " + string2});
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"Failed to take Secure.ANDROID_ID as IMEI. Try to use Serial_number instead."});
                    string2 = UmengMessageDeviceConfig.getSerial_number();
                    UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"getDeviceId: Serial_number: " + string2});
                    return string2;
                }
            }
        }
        return string2;
    }

    public static String getDIN(Context context) {
        String string2 = "";
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"No IMEI."});
        }
        try {
            if (UmengMessageDeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE") && !TextUtils.isEmpty((CharSequence)(string2 = telephonyManager.getDeviceId()))) {
                return string2;
            }
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"No IMEI.", exception.getMessage()});
        }
        return "";
    }

    public static String getDINAes(Context context) {
        String string2;
        block2: {
            string2 = "";
            try {
                string2 = UmengMessageDeviceConfig.getDIN(context);
                String string3 = PushAgent.getInstance(context).getMessageAppkey();
                string2 = string3 != null && 24 == string3.length() ? com.umeng.message.proguard.c.a(string2, "utf-8", string3.substring(0, 16)) : com.umeng.message.proguard.c.a(new String[]{string2, "utf-8"});
            }
            catch (Exception exception) {
                if (exception == null) break block2;
                UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"getDINAes:" + exception.getMessage()});
            }
        }
        return string2;
    }

    public static String getAndroidId(Context context) {
        String string2 = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static String getSerial_number() {
        String string2 = "";
        if (Build.VERSION.SDK_INT <= 25) {
            string2 = Build.SERIAL;
        } else {
            try {
                Class<?> clazz = Class.forName("android.os.Build");
                Method method = clazz.getMethod("getSerial", new Class[0]);
                string2 = (String)method.invoke(clazz, new Object[0]);
            }
            catch (Throwable throwable) {
                string2 = "";
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static String getDeviceIdUmengMD5(Context context) {
        return h.b(UmengMessageDeviceConfig.getDeviceId(context));
    }

    public static String getDeviceIdMD5(Context context) {
        return h.a(UmengMessageDeviceConfig.getDeviceId(context));
    }

    public static String getNetworkOperatorName(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager == null) {
                return a;
            }
            return telephonyManager.getNetworkOperatorName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return a;
        }
    }

    public static String getDisplayResolution(Context context) {
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            int n2 = displayMetrics.widthPixels;
            int n3 = displayMetrics.heightPixels;
            String string2 = String.valueOf(n3) + "*" + String.valueOf(n2);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return a;
        }
    }

    public static String[] getNetworkAccessMode(Context context) {
        String[] stringArray = new String[]{a, a};
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                return stringArray;
            }
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = d;
                return stringArray;
            }
            NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(0);
            if (networkInfo2 != null && networkInfo2.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = c;
                stringArray[1] = networkInfo2.getSubtypeName();
                return stringArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    public static boolean isWiFiAvailable(Context context) {
        return d.equals(UmengMessageDeviceConfig.getNetworkAccessMode(context)[0]);
    }

    public static Location getLocation(Context context) {
        LocationManager locationManager = null;
        try {
            Location location;
            locationManager = (LocationManager)context.getSystemService("location");
            if (UmengMessageDeviceConfig.checkPermission(context, "android.permission.ACCESS_FINE_LOCATION") && (location = locationManager.getLastKnownLocation("gps")) != null) {
                UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"get location from gps:" + location.getLatitude() + "," + location.getLongitude()});
                return location;
            }
            if (UmengMessageDeviceConfig.checkPermission(context, "android.permission.ACCESS_COARSE_LOCATION") && (location = locationManager.getLastKnownLocation("network")) != null) {
                UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"get location from network:" + location.getLatitude() + "," + location.getLongitude()});
                return location;
            }
            UMLog.mutlInfo((String)b, (int)2, (String)"Could not get location from GPS or Cell-id, lack ACCESS_COARSE_LOCATION or ACCESS_COARSE_LOCATION permission?");
            return null;
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{exception.getMessage()});
            return null;
        }
    }

    public static boolean isOnline(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                return networkInfo.isConnectedOrConnecting();
            }
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isSdCardWrittenable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static int getTimeZone(Context context) {
        try {
            Locale locale = UmengMessageDeviceConfig.a(context);
            Calendar calendar = Calendar.getInstance(locale);
            if (calendar != null) {
                return calendar.getTimeZone().getRawOffset() / 3600000;
            }
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"error in getTimeZone", exception.getMessage()});
        }
        return 8;
    }

    public static String[] getLocaleInfo(Context context) {
        String[] stringArray = new String[2];
        try {
            Locale locale = UmengMessageDeviceConfig.a(context);
            if (locale != null) {
                stringArray[0] = locale.getCountry();
                stringArray[1] = locale.getLanguage();
            }
            if (TextUtils.isEmpty((CharSequence)stringArray[0])) {
                stringArray[0] = a;
            }
            if (TextUtils.isEmpty((CharSequence)stringArray[1])) {
                stringArray[1] = a;
            }
            return stringArray;
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"error in getLocaleInfo", exception.getMessage()});
            return stringArray;
        }
    }

    private static Locale a(Context context) {
        Locale locale = null;
        try {
            Configuration configuration = new Configuration();
            Settings.System.getConfiguration((ContentResolver)context.getContentResolver(), (Configuration)configuration);
            if (configuration != null) {
                locale = configuration.locale;
            }
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"fail to read user config locale"});
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String getAppkey(Context context) {
        return UmengMessageDeviceConfig.getMetaData(context, "UMENG_APPKEY");
    }

    public static String getMetaData(Context context, String string2) {
        try {
            String string3;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && (string3 = applicationInfo.metaData.getString(string2)) != null) {
                return string3.trim();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{String.format("Could not read meta-data %s from AndroidManifest.xml.", string2)});
        return null;
    }

    public static String getMac(Context context) {
        if (Build.VERSION.SDK_INT <= 22) {
            try {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (UmengMessageDeviceConfig.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                    WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                    return wifiInfo.getMacAddress();
                }
                UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"Could not get mac address.[no permission android.permission.ACCESS_WIFI_STATE"});
            }
            catch (Exception exception) {
                UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"Could not get mac address." + exception.toString()});
            }
        } else {
            try {
                ArrayList<NetworkInterface> arrayList = Collections.list(NetworkInterface.getNetworkInterfaces());
                for (NetworkInterface networkInterface : arrayList) {
                    if (!networkInterface.getName().equalsIgnoreCase("wlan0")) continue;
                    byte[] byArray = networkInterface.getHardwareAddress();
                    if (byArray == null) {
                        return "";
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    for (byte by2 : byArray) {
                        stringBuilder.append(String.format("%02X:", by2));
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    }
                    return stringBuilder.toString();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return "";
    }

    public static String getUmid(Context context) {
        String string2 = UmengMessageDeviceConfig.b(context);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private static String b(Context context) {
        return UMUtils.getUMId((Context)context);
    }

    public static String getResolution(Context context) {
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            int n2 = -1;
            int n3 = -1;
            if ((context.getApplicationInfo().flags & 0x2000) == 0) {
                n2 = UmengMessageDeviceConfig.a(displayMetrics, "noncompatWidthPixels");
                n3 = UmengMessageDeviceConfig.a(displayMetrics, "noncompatHeightPixels");
            }
            if (n2 == -1 || n3 == -1) {
                n2 = displayMetrics.widthPixels;
                n3 = displayMetrics.heightPixels;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(n2);
            stringBuffer.append("*");
            stringBuffer.append(n3);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"read resolution fail", exception.getMessage()});
            return a;
        }
    }

    private static int a(Object object, String string2) {
        try {
            Field field = DisplayMetrics.class.getDeclaredField(string2);
            if (field != null) {
                field.setAccessible(true);
                return field.getInt(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return -1;
    }

    public static String getOperator(Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"read carrier fail", exception.getMessage()});
            return a;
        }
    }

    public static String getTimeString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String string2 = simpleDateFormat.format(date);
        return string2;
    }

    public static String getToday() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        String string2 = simpleDateFormat.format(date);
        return string2;
    }

    public static Date toTime(String string2) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = simpleDateFormat.parse(string2);
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getIntervalSeconds(Date date, Date date2) {
        if (date.after(date2)) {
            Date date3 = date;
            date = date2;
            date2 = date3;
        }
        long l2 = date.getTime();
        long l3 = date2.getTime();
        long l4 = l3 - l2;
        return (int)(l4 / 1000L);
    }

    public static String getChannel(Context context) {
        String string2 = a;
        try {
            Object object;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && applicationInfo.metaData != null && (object = applicationInfo.metaData.get("UMENG_CHANNEL")) != null) {
                String string3 = object.toString();
                if (string3 != null) {
                    string2 = string3;
                } else {
                    UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"\u5728AndroidManifest.xml\u4e2d\u8bfb\u53d6\u4e0d\u5230UMENG_CHANNEL meta-data"});
                }
            }
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"\u5728AndroidManifest.xml\u4e2d\u8bfb\u53d6\u4e0d\u5230UMENG_CHANNEL meta-data"});
            exception.printStackTrace();
        }
        return string2;
    }

    public static String getPackageName(Context context) {
        return context.getPackageName();
    }

    public static String getApplicationLable(Context context) {
        return context.getPackageManager().getApplicationLabel(context.getApplicationInfo()).toString();
    }

    public static boolean isDebug(Context context) {
        try {
            return (context.getApplicationInfo().flags & 2) != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getUtdid(Context context) {
        try {
            return fe.a(context);
        }
        catch (Throwable throwable) {
            UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"\u83b7\u53d6utdid\u5931\u8d25. " + throwable.getMessage()});
            return "";
        }
    }

    public static boolean isServiceWork(Context context, String string2, String string3) {
        boolean bl2 = false;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningServices(Integer.MAX_VALUE);
        if (list.size() <= 0) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string4 = ((ActivityManager.RunningServiceInfo)list.get((int)i2)).service.getClassName().toString();
            String string5 = ((ActivityManager.RunningServiceInfo)list.get((int)i2)).service.getPackageName().toString();
            if (!string4.equals(string2) || !string5.equals(string3)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public static String getServiceName(Context context, String string2, String string3) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent();
        intent.setAction(string2);
        List list = packageManager.queryIntentServices(intent, 0);
        ArrayList<ResolveInfo> arrayList = new ArrayList<ResolveInfo>();
        if (list != null && list.size() > 0) {
            for (ResolveInfo resolveInfo : list) {
                if (!resolveInfo.serviceInfo.packageName.equals(string3)) continue;
                arrayList.add(resolveInfo);
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            return ((ResolveInfo)arrayList.get((int)0)).serviceInfo.name;
        }
        return null;
    }

    public static boolean isIntentExist(Context context, String string2, String string3) {
        Intent intent;
        boolean bl2 = false;
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2)), 0);
        if (!list.isEmpty()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (!((ResolveInfo)list.get((int)i2)).activityInfo.packageName.equalsIgnoreCase(string3)) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public static boolean getDataData(String string2) {
        File file = null;
        boolean bl2 = false;
        file = new File("/data/app/" + string2 + "-1.apk");
        bl2 = file.exists();
        if (!bl2) {
            file = new File("/data/app/" + string2 + "-2.apk");
            bl2 = file.exists();
        }
        if (!bl2) {
            file = new File("/data/app/" + string2 + ".apk");
            bl2 = file.exists();
        }
        if (!bl2) {
            file = new File("/data/app/" + string2 + "-1");
            bl2 = file.exists();
        }
        if (!bl2) {
            file = new File("/data/app/" + string2 + "-2");
            bl2 = file.exists();
        }
        return bl2;
    }

    public static boolean isMIUI() {
        String string2 = "ro.miui.ui.version.code";
        String string3 = "ro.miui.ui.version.name";
        String string4 = "ro.miui.internal.storage";
        try {
            a a2 = com.umeng.message.util.a.g();
            return a2.a("ro.miui.ui.version.code", null) != null || a2.a("ro.miui.ui.version.name", null) != null || a2.a("ro.miui.internal.storage", null) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isMiui8() {
        boolean bl2 = false;
        try {
            a a2 = com.umeng.message.util.a.g();
            String string2 = a2.a("ro.miui.ui.version.name");
            if (string2 != null && string2.contains("8")) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }

    public static String isNotificationEnabled(Context context) {
        String string2 = "unknown";
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
                ApplicationInfo applicationInfo = context.getApplicationInfo();
                String string3 = context.getApplicationContext().getPackageName();
                int n2 = applicationInfo.uid;
                Class<?> clazz = null;
                clazz = Class.forName(AppOpsManager.class.getName());
                Method method = clazz.getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = clazz.getDeclaredField("OP_POST_NOTIFICATION");
                int n3 = (Integer)field.get(appOpsManager);
                int n4 = (Integer)method.invoke((Object)appOpsManager, n3, n2, string3);
                string2 = String.valueOf(n4 == 0);
            }
            catch (Exception exception) {
                UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"\u901a\u77e5\u5f00\u5173\u662f\u5426\u6253\u5f00\u5f02\u5e38"});
            }
        }
        return string2;
    }
}

