/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.service.receivers;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.huawei.hms.support.api.push.PushReceiver;
import com.ss.android.push.PushDependManager;
import com.ss.android.pushmanager.thirdparty.ISendTokenCallBack;
import g.optional.push.bk;
import g.optional.push.ev;
import org.json.JSONObject;

public class HWPushMessageHandler
extends PushReceiver {
    private static final String TAG = "HWPush";
    public static final int MSG_WHAT_SENT_TOKEN = 1;
    private Context mContext;
    private Handler mHandler = null;

    public void onPushState(Context context, boolean bl2) {
        super.onPushState(context, bl2);
        PushDependManager.inst().loggerD(TAG, "onPushState: " + bl2);
    }

    public void onToken(Context context, String string2) {
        if (context == null || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        try {
            PushDependManager.inst().loggerD(TAG, "getToken = " + string2);
            this.mContext = context.getApplicationContext();
            Handler handler = this.getHandler(context);
            handler.sendMessage(handler.obtainMessage(1, (Object)string2));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Handler getHandler(Context context) {
        if (this.mHandler == null) {
            this.mHandler = new HwHandler(Looper.getMainLooper(), context);
        }
        return this.mHandler;
    }

    public void onPushMsg(Context context, byte[] byArray, String string2) {
        if (context == null || byArray == null) {
            return;
        }
        String string3 = null;
        try {
            string3 = new String(byArray, "UTF-8");
            JSONObject jSONObject = PushDependManager.inst().getMessage(string3.getBytes(), false);
            if (jSONObject != null) {
                string3 = jSONObject.toString();
            }
            if (PushDependManager.inst().loggerDebug()) {
                PushDependManager.inst().loggerD(TAG, "Get HW_PUSH Message " + string3 != null ? string3 : String.valueOf(null));
            }
            HWPushMessageHandler.handleMessage(context, 1, string3, 7);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onEvent(Context context, PushReceiver.Event event, Bundle bundle) {
        try {
            if (PushReceiver.Event.NOTIFICATION_OPENED.equals((Object)event)) {
                PushDependManager.inst().loggerD(TAG, "onEvent: \u901a\u77e5\u680f\u4e2d\u7684\u901a\u77e5\u88ab\u70b9\u51fb\u6253\u5f00->" + event + " , bundle:" + bundle);
            } else if (PushReceiver.Event.NOTIFICATION_CLICK_BTN.equals((Object)event)) {
                PushDependManager.inst().loggerD(TAG, "onEvent: \u901a\u77e5\u680f\u4e2d\u901a\u77e5\u4e0a\u7684\u6309\u94ae\u88ab\u70b9\u51fb->" + event + " , bundle:" + bundle);
            }
            super.onEvent(context, event, bundle);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void handleMessage(Context context, int n2, String string2, int n3) {
        try {
            Intent intent = new Intent("com.ss.android.hw.message");
            intent.setPackage(context.getPackageName());
            intent.putExtra("message_type", n2);
            intent.putExtra("message_obj", string2);
            intent.putExtra("message_from", n3);
            bk.a(context, intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class HwHandler
    extends Handler {
        private final Context mContext;

        HwHandler(Looper looper, Context context) {
            super(looper);
            this.mContext = context;
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            switch (message.what) {
                case 1: {
                    if (this.mContext == null) {
                        return;
                    }
                    try {
                        final String string2 = (String)message.obj;
                        ISendTokenCallBack iSendTokenCallBack = new ISendTokenCallBack(){

                            @Override
                            public String getToken(Context context) {
                                return string2;
                            }

                            @Override
                            public int getType() {
                                return 7;
                            }
                        };
                        HWPushMessageHandler.handleMessage(this.mContext, 0, string2, 7);
                        PushDependManager.inst().sendToken(this.mContext, iSendTokenCallBack);
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put("label", (Object)"get_token");
                        jSONObject.put("type", 7);
                        jSONObject.put("token", (Object)string2);
                        PushDependManager.inst().sendMonitor(this.mContext, "ss_push", jSONObject);
                        ev.b(7);
                        break;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

