/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.hms.agent.common;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import com.huawei.android.hms.agent.common.ActivityMgr;
import com.huawei.android.hms.agent.common.EmptyConnectCallback;
import com.huawei.android.hms.agent.common.HMSAgentActivity;
import com.huawei.android.hms.agent.common.HMSAgentLog;
import com.huawei.android.hms.agent.common.IActivityDestroyedCallback;
import com.huawei.android.hms.agent.common.IActivityPauseCallback;
import com.huawei.android.hms.agent.common.IActivityResumeCallback;
import com.huawei.android.hms.agent.common.IClientConnectCallback;
import com.huawei.android.hms.agent.common.StrUtils;
import com.huawei.android.hms.agent.common.ThreadUtil;
import com.huawei.android.hms.agent.common.UIUtils;
import com.huawei.hms.activity.BridgeActivity;
import com.huawei.hms.api.ConnectionResult;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.api.HuaweiApiClient;
import com.huawei.hms.support.api.push.HuaweiPush;
import java.util.ArrayList;
import java.util.List;

public final class ApiClientMgr
implements IActivityDestroyedCallback,
IActivityPauseCallback,
IActivityResumeCallback,
HuaweiApiClient.ConnectionCallbacks,
HuaweiApiClient.OnConnectionFailedListener {
    public static final ApiClientMgr INST = new ApiClientMgr();
    private static final String PACKAGE_NAME_HIAPP = "com.huawei.appmarket";
    private static final Object CALLBACK_LOCK = new Object();
    private static final Object STATIC_CALLBACK_LOCK = new Object();
    private static final Object APICLIENT_LOCK = new Object();
    private static final int APICLIENT_CONNECT_TIMEOUT = 30000;
    private static final int UPDATE_OVER_ACTIVITY_CHECK_TIMEOUT = 3000;
    private static final int APICLIENT_STARTACTIVITY_TIMEOUT = 3000;
    private static final int APICLIENT_TIMEOUT_HANDLE_MSG = 3;
    private static final int APICLIENT_STARTACTIVITY_TIMEOUT_HANDLE_MSG = 4;
    private static final int UPDATE_OVER_ACTIVITY_CHECK_TIMEOUT_HANDLE_MSG = 5;
    private static final int MAX_RESOLVE_TIMES = 3;
    private Context context;
    private String curAppPackageName;
    private HuaweiApiClient apiClient;
    private boolean allowResolveConnectError = false;
    private boolean isResolving;
    private BridgeActivity resolveActivity;
    private boolean hasOverActivity = false;
    private int curLeftResolveTimes = 3;
    private List<IClientConnectCallback> connCallbacks = new ArrayList<IClientConnectCallback>();
    private List<IClientConnectCallback> staticCallbacks = new ArrayList<IClientConnectCallback>();
    private Handler timeoutHandler = new Handler(new Handler.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Message message) {
            boolean bl2;
            Object object = CALLBACK_LOCK;
            synchronized (object) {
                bl2 = !ApiClientMgr.this.connCallbacks.isEmpty();
            }
            if (message != null && message.what == 3 && bl2) {
                HMSAgentLog.d("connect time out");
                ApiClientMgr.this.resetApiClient();
                ApiClientMgr.this.onConnectEnd(-1007);
                return true;
            }
            if (message != null && message.what == 4 && bl2) {
                HMSAgentLog.d("start activity time out");
                ApiClientMgr.this.onConnectEnd(-1007);
                return true;
            }
            if (message != null && message.what == 5 && bl2) {
                HMSAgentLog.d("Discarded update dispose:hasOverActivity=" + ApiClientMgr.this.hasOverActivity + " resolveActivity=" + StrUtils.objDesc(ApiClientMgr.this.resolveActivity));
                if (ApiClientMgr.this.hasOverActivity && ApiClientMgr.this.resolveActivity != null && !ApiClientMgr.this.resolveActivity.isFinishing()) {
                    ApiClientMgr.this.onResolveErrorRst(13);
                }
                return true;
            }
            return false;
        }
    });

    private ApiClientMgr() {
    }

    public void init(Application application) {
        HMSAgentLog.d("init");
        this.context = application.getApplicationContext();
        this.curAppPackageName = application.getPackageName();
        ActivityMgr.INST.unRegisterActivitResumeEvent(this);
        ActivityMgr.INST.registerActivitResumeEvent(this);
        ActivityMgr.INST.unRegisterActivitPauseEvent(this);
        ActivityMgr.INST.registerActivitPauseEvent(this);
        ActivityMgr.INST.unRegisterActivitDestroyedEvent(this);
        ActivityMgr.INST.registerActivitDestroyedEvent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        HMSAgentLog.d("release");
        this.isResolving = false;
        this.resolveActivity = null;
        this.hasOverActivity = false;
        HuaweiApiClient huaweiApiClient = this.getApiClient();
        if (huaweiApiClient != null) {
            huaweiApiClient.disconnect();
        }
        Object object = APICLIENT_LOCK;
        synchronized (object) {
            this.apiClient = null;
        }
        object = STATIC_CALLBACK_LOCK;
        synchronized (object) {
            this.staticCallbacks.clear();
        }
        object = CALLBACK_LOCK;
        synchronized (object) {
            this.connCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HuaweiApiClient getApiClient() {
        Object object = APICLIENT_LOCK;
        synchronized (object) {
            return this.apiClient != null ? this.apiClient : this.resetApiClient();
        }
    }

    public boolean isConnect(HuaweiApiClient huaweiApiClient) {
        return huaweiApiClient != null && huaweiApiClient.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClientConnect(IClientConnectCallback iClientConnectCallback) {
        Object object = STATIC_CALLBACK_LOCK;
        synchronized (object) {
            this.staticCallbacks.add(iClientConnectCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientConnectCallback(IClientConnectCallback iClientConnectCallback) {
        Object object = STATIC_CALLBACK_LOCK;
        synchronized (object) {
            this.staticCallbacks.remove(iClientConnectCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HuaweiApiClient resetApiClient() {
        if (this.context == null) {
            HMSAgentLog.e("HMSAgent not init");
            return null;
        }
        Object object = APICLIENT_LOCK;
        synchronized (object) {
            if (this.apiClient != null) {
                ApiClientMgr.disConnectClientDelay(this.apiClient, 60000);
            }
            HMSAgentLog.d("reset client");
            this.apiClient = new HuaweiApiClient.Builder(this.context).addApi(HuaweiPush.PUSH_API).addConnectionCallbacks((HuaweiApiClient.ConnectionCallbacks)INST).addOnConnectionFailedListener((HuaweiApiClient.OnConnectionFailedListener)INST).build();
            return this.apiClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(IClientConnectCallback iClientConnectCallback, boolean bl2) {
        if (this.context == null) {
            this.aSysnCallback(-1000, iClientConnectCallback);
            return;
        }
        HuaweiApiClient huaweiApiClient = this.getApiClient();
        if (huaweiApiClient != null && huaweiApiClient.isConnected()) {
            HMSAgentLog.d("client is valid");
            this.aSysnCallback(0, iClientConnectCallback);
            return;
        }
        Object object = CALLBACK_LOCK;
        synchronized (object) {
            HMSAgentLog.d("client is invalid\uff1asize=" + this.connCallbacks.size());
            boolean bl3 = this.allowResolveConnectError = this.allowResolveConnectError || bl2;
            if (this.connCallbacks.isEmpty()) {
                this.connCallbacks.add(iClientConnectCallback);
                this.curLeftResolveTimes = 3;
                this.startConnect();
            } else {
                this.connCallbacks.add(iClientConnectCallback);
            }
        }
    }

    private void startConnect() {
        --this.curLeftResolveTimes;
        HMSAgentLog.d("start thread to connect");
        ThreadUtil.INST.excute(new Runnable(){

            @Override
            public void run() {
                HuaweiApiClient huaweiApiClient = ApiClientMgr.this.getApiClient();
                if (huaweiApiClient != null) {
                    HMSAgentLog.d("connect");
                    Activity activity = ActivityMgr.INST.getLastActivity();
                    ApiClientMgr.this.timeoutHandler.sendEmptyMessageDelayed(3, 30000L);
                    huaweiApiClient.connect(activity);
                } else {
                    HMSAgentLog.d("client is generate error");
                    ApiClientMgr.this.onConnectEnd(-1002);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectEnd(int n2) {
        HMSAgentLog.d("connect end:" + n2);
        Object object = CALLBACK_LOCK;
        synchronized (object) {
            for (IClientConnectCallback iClientConnectCallback : this.connCallbacks) {
                this.aSysnCallback(n2, iClientConnectCallback);
            }
            this.connCallbacks.clear();
            this.allowResolveConnectError = false;
        }
        object = STATIC_CALLBACK_LOCK;
        synchronized (object) {
            for (IClientConnectCallback iClientConnectCallback : this.staticCallbacks) {
                this.aSysnCallback(n2, iClientConnectCallback);
            }
            this.staticCallbacks.clear();
        }
    }

    private void aSysnCallback(final int n2, final IClientConnectCallback iClientConnectCallback) {
        ThreadUtil.INST.excute(new Runnable(){

            @Override
            public void run() {
                HuaweiApiClient huaweiApiClient = ApiClientMgr.this.getApiClient();
                HMSAgentLog.d("callback connect: rst=" + n2 + " apiClient=" + huaweiApiClient);
                iClientConnectCallback.onConnect(n2, huaweiApiClient);
            }
        });
    }

    @Override
    public void onActivityResume(Activity activity) {
        HuaweiApiClient huaweiApiClient = this.getApiClient();
        if (huaweiApiClient != null) {
            HMSAgentLog.d("tell hmssdk: onResume");
            huaweiApiClient.onResume(activity);
        }
        HMSAgentLog.d("is resolving:" + this.isResolving);
        if (this.isResolving && !PACKAGE_NAME_HIAPP.equals(this.curAppPackageName)) {
            if (activity instanceof BridgeActivity) {
                this.resolveActivity = (BridgeActivity)activity;
                this.hasOverActivity = false;
                HMSAgentLog.d("received bridgeActivity:" + StrUtils.objDesc(this.resolveActivity));
            } else if (this.resolveActivity != null && !this.resolveActivity.isFinishing()) {
                this.hasOverActivity = true;
                HMSAgentLog.d("received other Activity:" + StrUtils.objDesc(this.resolveActivity));
            }
            this.timeoutHandler.removeMessages(5);
            this.timeoutHandler.sendEmptyMessageDelayed(5, 3000L);
        }
    }

    @Override
    public void onActivityPause(Activity activity) {
        HuaweiApiClient huaweiApiClient = this.getApiClient();
        if (huaweiApiClient != null) {
            huaweiApiClient.onPause(activity);
        }
    }

    @Override
    public void onActivityDestroyed(Activity activity, Activity activity2) {
        if (activity2 == null) {
            this.resetApiClient();
        }
    }

    void onResolveErrorRst(int n2) {
        HuaweiApiClient huaweiApiClient;
        HMSAgentLog.d("result=" + n2);
        this.isResolving = false;
        this.resolveActivity = null;
        this.hasOverActivity = false;
        if (n2 == 0 && (huaweiApiClient = this.getApiClient()) != null && !huaweiApiClient.isConnecting() && !huaweiApiClient.isConnected() && this.curLeftResolveTimes > 0) {
            this.startConnect();
            return;
        }
        this.onConnectEnd(n2);
    }

    void onActivityLunched() {
        HMSAgentLog.d("resolve onActivityLunched");
        this.timeoutHandler.removeMessages(4);
        this.isResolving = true;
    }

    public void onConnected() {
        HMSAgentLog.d("connect success");
        this.timeoutHandler.removeMessages(3);
        this.onConnectEnd(0);
    }

    public void onConnectionSuspended(int n2) {
        HMSAgentLog.d("connect suspended");
        this.connect(new EmptyConnectCallback("onConnectionSuspended try end:"), true);
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        this.timeoutHandler.removeMessages(3);
        if (connectionResult == null) {
            HMSAgentLog.e("result is null");
            this.onConnectEnd(-1002);
            return;
        }
        int n2 = connectionResult.getErrorCode();
        HMSAgentLog.d("errCode=" + n2 + " allowResolve=" + this.allowResolveConnectError);
        if (HuaweiApiAvailability.getInstance().isUserResolvableError(n2) && this.allowResolveConnectError) {
            Activity activity = ActivityMgr.INST.getLastActivity();
            if (activity != null) {
                try {
                    this.timeoutHandler.sendEmptyMessageDelayed(4, 3000L);
                    Intent intent = new Intent((Context)activity, HMSAgentActivity.class);
                    intent.putExtra("HMSConnectionErrorCode", n2);
                    intent.putExtra("should_be_fullscreen", UIUtils.isActivityFullscreen(activity));
                    activity.startActivity(intent);
                    return;
                }
                catch (Exception exception) {
                    HMSAgentLog.e("start HMSAgentActivity exception:" + exception.getMessage());
                    this.timeoutHandler.removeMessages(4);
                    this.onConnectEnd(-1004);
                    return;
                }
            }
            HMSAgentLog.d("no activity");
            this.onConnectEnd(-1001);
            return;
        }
        this.onConnectEnd(n2);
    }

    private static void disConnectClientDelay(final HuaweiApiClient huaweiApiClient, int n2) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                huaweiApiClient.disconnect();
            }
        }, (long)n2);
    }
}

