/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.aidl.adapter;

import android.os.Build;
import android.os.RemoteException;
import anet.channel.util.ErrorConstant;
import anetwork.channel.NetworkCallBack$FinishListener;
import anetwork.channel.NetworkCallBack$InputStreamListener;
import anetwork.channel.NetworkCallBack$ResponseCodeListener;
import anetwork.channel.NetworkEvent$FinishEvent;
import anetwork.channel.aidl.Connection$Stub;
import anetwork.channel.aidl.ParcelableFuture;
import anetwork.channel.aidl.ParcelableInputStream;
import anetwork.channel.aidl.adapter.ParcelableInputStreamImpl;
import anetwork.channel.entity.g;
import anetwork.channel.statist.StatisticData;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ConnectionDelegate
extends Connection$Stub
implements NetworkCallBack$FinishListener,
NetworkCallBack$InputStreamListener,
NetworkCallBack$ResponseCodeListener {
    private ParcelableInputStreamImpl inputStream;
    private int statusCode;
    private String desc;
    private Map header;
    private StatisticData statisticData;
    private CountDownLatch statusLatch = new CountDownLatch(1);
    private CountDownLatch streamLatch = new CountDownLatch(1);
    private ParcelableFuture future;
    private g config;

    public ConnectionDelegate(int n2) {
        this.statusCode = n2;
        this.desc = ErrorConstant.getErrMsg(n2);
    }

    public ConnectionDelegate(g g2) {
        this.config = g2;
    }

    @Override
    public String getDesc() {
        this.waitCountDownLatch(this.statusLatch);
        return this.desc;
    }

    @Override
    public StatisticData getStatisticData() {
        return this.statisticData;
    }

    @Override
    public ParcelableInputStream getInputStream() {
        this.waitCountDownLatch(this.streamLatch);
        return this.inputStream;
    }

    @Override
    public int getStatusCode() {
        this.waitCountDownLatch(this.statusLatch);
        return this.statusCode;
    }

    @Override
    public Map getConnHeadFields() {
        this.waitCountDownLatch(this.statusLatch);
        return this.header;
    }

    @Override
    public void cancel() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public void setFuture(ParcelableFuture parcelableFuture) {
        this.future = parcelableFuture;
    }

    @Override
    public void onFinished(NetworkEvent$FinishEvent networkEvent$FinishEvent, Object object) {
        this.statusCode = networkEvent$FinishEvent.getHttpCode();
        this.desc = networkEvent$FinishEvent.getDesc() != null ? networkEvent$FinishEvent.getDesc() : ErrorConstant.getErrMsg(this.statusCode);
        this.statisticData = networkEvent$FinishEvent.getStatisticData();
        if (this.inputStream != null) {
            this.inputStream.writeEnd();
        }
        this.streamLatch.countDown();
        this.statusLatch.countDown();
    }

    private void waitCountDownLatch(CountDownLatch countDownLatch) {
        try {
            boolean bl2 = countDownLatch.await(this.config.b() + 1000, TimeUnit.MILLISECONDS);
            if (!bl2) {
                if (this.future != null) {
                    this.future.cancel(true);
                }
                throw this.buildRemoteException("wait time out");
            }
        }
        catch (InterruptedException interruptedException) {
            throw this.buildRemoteException("thread interrupt");
        }
    }

    private RemoteException buildRemoteException(String string2) {
        if (Build.VERSION.SDK_INT >= 15) {
            return new RemoteException(string2);
        }
        return new RemoteException();
    }

    @Override
    public boolean onResponseCode(int n2, Map map, Object object) {
        this.statusCode = n2;
        this.desc = ErrorConstant.getErrMsg(this.statusCode);
        this.header = map;
        this.statusLatch.countDown();
        return false;
    }

    @Override
    public void onInputStreamGet(ParcelableInputStream parcelableInputStream, Object object) {
        this.inputStream = (ParcelableInputStreamImpl)parcelableInputStream;
        this.streamLatch.countDown();
    }
}

