/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.util;

import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.os.Build;
import anet.channel.AwcnConfig;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.thread.ThreadPoolExecutorFactory;
import anet.channel.util.ALog;
import anet.channel.util.AppLifecycle$1;
import anet.channel.util.AppLifecycle$2;
import anet.channel.util.AppLifecycle$3;
import anet.channel.util.AppLifecycle$AppLifecycleListener;
import java.util.concurrent.CopyOnWriteArraySet;

public class AppLifecycle {
    private static CopyOnWriteArraySet listeners = new CopyOnWriteArraySet();
    public static volatile long lastEnterBackgroundTime = 0L;
    private static Application.ActivityLifecycleCallbacks mActivityLifecycleCallbacks = new AppLifecycle$2();
    private static ComponentCallbacks2 mComponentCallbacks2 = new AppLifecycle$3();

    private AppLifecycle() {
    }

    public static void initialize() {
        if (Build.VERSION.SDK_INT >= 14 && AwcnConfig.isAppLifeCycleListenerEnable()) {
            ((Application)GlobalAppRuntimeInfo.getContext().getApplicationContext()).registerActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
            GlobalAppRuntimeInfo.getContext().registerComponentCallbacks((ComponentCallbacks)mComponentCallbacks2);
        }
    }

    public static void registerLifecycleListener(AppLifecycle$AppLifecycleListener appLifecycle$AppLifecycleListener) {
        if (appLifecycle$AppLifecycleListener != null) {
            listeners.add(appLifecycle$AppLifecycleListener);
        }
    }

    public static void unregisterLifecycleListener(AppLifecycle$AppLifecycleListener appLifecycle$AppLifecycleListener) {
        listeners.remove(appLifecycle$AppLifecycleListener);
    }

    public static void onForeground() {
        if (GlobalAppRuntimeInfo.isAppBackground()) {
            GlobalAppRuntimeInfo.setBackground(false);
            AppLifecycle.notifyListener(true);
        }
    }

    public static void onBackground() {
        if (!GlobalAppRuntimeInfo.isAppBackground()) {
            GlobalAppRuntimeInfo.setBackground(true);
            lastEnterBackgroundTime = System.currentTimeMillis();
            AppLifecycle.notifyListener(false);
        }
    }

    private static void notifyListener(boolean bl2) {
        ALog.i("awcn.AppLifeCycle", "notifyListener", null, "foreground", bl2);
        ThreadPoolExecutorFactory.submitScheduledTask(new AppLifecycle$1(bl2));
    }

    static /* synthetic */ CopyOnWriteArraySet access$000() {
        return listeners;
    }
}

