/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.strategy;

import android.text.TextUtils;
import anet.channel.strategy.l$a;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ConnProtocol
implements Serializable {
    private static final long serialVersionUID = -3523201990674557001L;
    private static Map protocolMap = new HashMap();
    public static final ConnProtocol HTTP = ConnProtocol.valueOf("http", null, null);
    public static final ConnProtocol HTTPS = ConnProtocol.valueOf("https", null, null);
    public final String protocol;
    public final String rtt;
    public final String publicKey;
    public final String name;
    final int isHttp;

    public static ConnProtocol valueOf(l$a l$a) {
        if (l$a == null) {
            return null;
        }
        return ConnProtocol.valueOf(l$a.b, l$a.g, l$a.h);
    }

    public static ConnProtocol valueOf(String string2, String string3, String string4, boolean bl2) {
        return ConnProtocol.valueOf(string2, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnProtocol valueOf(String string2, String string3, String string4) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        String string5 = ConnProtocol.buildName(string2, string3, string4);
        Map map = protocolMap;
        synchronized (map) {
            if (protocolMap.containsKey(string5)) {
                return (ConnProtocol)protocolMap.get(string5);
            }
            ConnProtocol connProtocol = new ConnProtocol(string5, string2, string3, string4);
            protocolMap.put(string5, connProtocol);
            return connProtocol;
        }
    }

    private ConnProtocol(String string2, String string3, String string4, String string5) {
        this.name = string2;
        this.protocol = string3;
        this.rtt = string4;
        this.publicKey = string5;
        this.isHttp = "http".equalsIgnoreCase(string3) || "https".equalsIgnoreCase(string3) ? 1 : 0;
    }

    private static String buildName(String string2, String string3, String string4) {
        if (TextUtils.isEmpty((CharSequence)string4)) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(18);
        stringBuilder.append(string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append("_").append(string3);
        } else {
            stringBuilder.append("_0rtt");
        }
        stringBuilder.append("_");
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ConnProtocol)) {
            return false;
        }
        return this.name.equals(((ConnProtocol)object).name);
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 31 * n2 + this.protocol.hashCode();
        if (this.rtt != null) {
            n2 = 31 * n2 + this.rtt.hashCode();
        }
        if (this.publicKey != null) {
            n2 = 31 * n2 + this.publicKey.hashCode();
        }
        return n2;
    }
}

