/*
 * Decompiled with CFR 0.152.
 */
package org.android.spdy;

import android.content.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.android.spdy.AccsSSLCallback;
import org.android.spdy.SessionCb;
import org.android.spdy.SessionInfo;
import org.android.spdy.SoInstallMgrSdk;
import org.android.spdy.SpdyByteArray;
import org.android.spdy.SpdyDataProvider;
import org.android.spdy.SpdyErrorException;
import org.android.spdy.SpdyRequest;
import org.android.spdy.SpdySession;
import org.android.spdy.SpdySessionKind;
import org.android.spdy.SpdyVersion;
import org.android.spdy.Spdycb;
import org.android.spdy.SslCertcb;
import org.android.spdy.SslPermData;
import org.android.spdy.SslVersion;
import org.android.spdy.SuperviseConnectInfo;
import org.android.spdy.SuperviseData;
import org.android.spdy.spduLog;

public final class SpdyAgent {
    private static final int MAX_SPDY_SESSION_COUNT = 50;
    private AccsSSLCallback accsSSLCallback;
    static final int SPDY_SESSION_CREATE = 4096;
    static final int SPDY_DATA_CHUNK_RECV = 4097;
    static final int SPDY_DATA_RECV = 4098;
    static final int SPDY_DATA_SEND = 4099;
    static final int SPDY_STREAM_CLOSE = 4100;
    static final int SPDY_PING_RECV = 4101;
    static final int SPDY_REQUEST_RECV = 4102;
    static final int SPDY_SESSION_CLOSE = 4103;
    static final int SPDY_STREAM_RESPONSE_RECV = 4104;
    static final int SPDY_SESSION_FAILED_ERROR = 4105;
    static final int SPDY_CUSTOM_CONTROL_FRAME_RECV = 4106;
    static final int MODE_QUIC = 256;
    private HashMap<String, SpdySession> sessionMgr = new HashMap(5);
    private LinkedList<SpdySession> sessionQueue = new LinkedList();
    private long agentNativePtr;
    private AtomicBoolean closed = new AtomicBoolean();
    private String proxyUsername = null;
    private String proxyPassword = null;
    private static final String TNET_SO_VERSION = "tnet-3.1.14";
    public static volatile boolean enableDebug = false;
    public static volatile boolean enableTimeGaurd = false;
    private static final boolean HAVE_CLOSE = false;
    private static final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static final Lock r = rwLock.readLock();
    private static final Lock w = rwLock.writeLock();
    private static volatile boolean loadSucc = false;
    private static volatile SpdyAgent gSingleInstance = null;
    private static Object lock = new Object();
    private static Object domainHashLock = new Object();
    private static HashMap<String, Integer> domainHashMap = new HashMap();
    private static int totalDomain = 0;
    private static final int KB8 = 8192;
    private static final int KB32 = 32768;
    private static final int MB5 = 0x500000;
    public static final int ACCS_TEST_SERVER = 0;
    public static final int ACCS_ONLINE_SERVER = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSpdySession(String string2, String string3, int n2) {
        if (string2 != null) {
            w.lock();
            try {
                if (string2 != null) {
                    this.sessionMgr.remove(string2 + string3 + n2);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                w.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpdyAgent getInstance(Context context, SpdyVersion spdyVersion, SpdySessionKind spdySessionKind) throws UnsatisfiedLinkError, SpdyErrorException {
        if (gSingleInstance == null) {
            Object object = lock;
            synchronized (object) {
                if (gSingleInstance == null) {
                    gSingleInstance = new SpdyAgent(context, spdyVersion, spdySessionKind, null);
                }
            }
        }
        return gSingleInstance;
    }

    public static boolean checkLoadSucc() {
        return loadSucc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static SpdyAgent getInstance(Context context, SpdyVersion spdyVersion, SpdySessionKind spdySessionKind, AccsSSLCallback accsSSLCallback) throws UnsatisfiedLinkError, SpdyErrorException {
        if (gSingleInstance == null) {
            Object object = lock;
            synchronized (object) {
                if (gSingleInstance == null) {
                    gSingleInstance = new SpdyAgent(context, spdyVersion, spdySessionKind, accsSSLCallback);
                }
            }
        }
        return gSingleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDomainHashIndex(String string2) {
        Integer n2;
        Object object = domainHashLock;
        synchronized (object) {
            n2 = domainHashMap.get(string2);
            if (n2 == null) {
                domainHashMap.put(string2, ++totalDomain);
                n2 = totalDomain;
            }
        }
        return n2;
    }

    private SpdyAgent(Context context, SpdyVersion spdyVersion, SpdySessionKind spdySessionKind, AccsSSLCallback accsSSLCallback) throws UnsatisfiedLinkError {
        try {
            SoInstallMgrSdk.init(context);
            loadSucc = SoInstallMgrSdk.initSo(TNET_SO_VERSION, 1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            this.agentNativePtr = this.initAgent(spdyVersion.getInt(), spdySessionKind.getint(), SslVersion.SLIGHT_VERSION_V1.getint());
            this.accsSSLCallback = accsSSLCallback;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        this.closed.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLoadSo() throws SpdyErrorException {
        if (loadSucc) {
            return;
        }
        try {
            Object object = lock;
            synchronized (object) {
                if (loadSucc) {
                    return;
                }
                loadSucc = SoInstallMgrSdk.initSo(TNET_SO_VERSION, 1);
                this.agentNativePtr = this.initAgent(0, 0, 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (!loadSucc) {
            throw new SpdyErrorException("TNET_JNI_ERR_LOAD_SO_FAIL", -1108);
        }
    }

    public void setProxyUsernamePassword(String string2, String string3) {
        this.proxyUsername = string2;
        this.proxyPassword = string3;
    }

    static void securityCheck(int n2, int n3) {
        if (n2 >= 32768) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM:total=" + n2, -1102);
        }
        if (n3 >= 8192) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM:value=" + n3, -1102);
        }
    }

    static void tableListJudge(int n2) {
        if (n2 >= 0x500000) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM:total=" + n2, -1102);
        }
    }

    static void InvlidCharJudge(byte[] byArray, byte[] byArray2) {
        int n2;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            if ((byArray[n2] & 0xFF) >= 32 && (byArray[n2] & 0xFF) <= 126) continue;
            byArray[n2] = 63;
        }
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            if ((byArray2[n2] & 0xFF) >= 32 && (byArray2[n2] & 0xFF) <= 126) continue;
            byArray2[n2] = 63;
        }
    }

    static void headJudge(Map<String, String> map) {
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        if (map != null) {
            Set<Map.Entry<String, String>> set = map.entrySet();
            Iterator<Map.Entry<String, String>> iterator = set.iterator();
            Map.Entry<String, String> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                string2 = entry.getKey();
                string3 = entry.getValue();
                SpdyAgent.InvlidCharJudge(string2.getBytes(), string3.getBytes());
                SpdyAgent.securityCheck(n2 += string2.length() + 1 + string3.length(), string3.length());
            }
        }
    }

    static String mapBodyToString(Map<String, String> map) {
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null) {
            Set<Map.Entry<String, String>> set = map.entrySet();
            Iterator<Map.Entry<String, String>> iterator = set.iterator();
            Map.Entry<String, String> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                string2 = entry.getKey();
                string3 = entry.getValue();
                stringBuilder.append(string2).append('=').append(string3).append('&');
                SpdyAgent.tableListJudge(n2 += string2.length() + 1 + string3.length());
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    static byte[] dataproviderToByteArray(SpdyRequest spdyRequest, SpdyDataProvider spdyDataProvider) {
        byte[] byArray = null;
        String string2 = null;
        SpdyAgent.headJudge(spdyRequest.getHeaders());
        if (spdyDataProvider == null) {
            return null;
        }
        string2 = SpdyAgent.mapBodyToString(spdyDataProvider.postBody);
        byArray = string2 != null ? string2.getBytes() : spdyDataProvider.data;
        if (byArray != null && byArray.length >= 0x500000) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM:total=" + byArray.length, -1102);
        }
        return byArray;
    }

    @Deprecated
    public SpdySession createSession(String string2, Object object, SessionCb sessionCb, int n2) throws SpdyErrorException {
        return this.createSession(string2, "", object, sessionCb, null, n2, 0);
    }

    @Deprecated
    public SpdySession createSession(String string2, String string3, Object object, SessionCb sessionCb, int n2) throws SpdyErrorException {
        return this.createSession(string2, string3, object, sessionCb, null, n2, 0);
    }

    @Deprecated
    public SpdySession createSession(String string2, Object object, SessionCb sessionCb, SslCertcb sslCertcb, int n2) throws SpdyErrorException {
        return this.createSession(string2, "", object, sessionCb, sslCertcb, n2, 0);
    }

    public SpdySession createSession(SessionInfo sessionInfo) throws SpdyErrorException {
        return this.createSession(sessionInfo.getAuthority(), sessionInfo.getDomain(), sessionInfo.getSessonUserData(), sessionInfo.getSessionCb(), null, sessionInfo.getMode(), sessionInfo.getPubKeySeqNum(), sessionInfo.getConnectionTimeoutMs(), sessionInfo.getCertHost());
    }

    @Deprecated
    public SpdySession createSession(String string2, String string3, Object object, SessionCb sessionCb, SslCertcb sslCertcb, int n2, int n3) throws SpdyErrorException {
        return this.createSession(string2, string3, object, sessionCb, sslCertcb, n2, n3, -1);
    }

    public SpdySession createSession(String string2, String string3, Object object, SessionCb sessionCb, SslCertcb sslCertcb, int n2, int n3, int n4) throws SpdyErrorException {
        return this.createSession(string2, string3, object, sessionCb, sslCertcb, n2, n3, n4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpdySession createSession(String string2, String string3, Object object, SessionCb sessionCb, SslCertcb sslCertcb, int n2, int n3, int n4, String string4) throws SpdyErrorException {
        Object object2;
        if (string2 == null) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM", -1102);
        }
        String string5 = string2;
        String[] stringArray = string2.split("/");
        String[] stringArray2 = stringArray[0].split(":");
        byte[] byArray = "0.0.0.0".getBytes();
        char c2 = '\u0000';
        if (stringArray.length != 1) {
            object2 = stringArray[1].split(":");
            byArray = object2[0].getBytes();
            c2 = (char)Integer.parseInt(object2[1]);
        } else {
            string5 = string5 + "/0.0.0.0:0";
        }
        this.agentIsOpen();
        object2 = null;
        boolean bl2 = false;
        r.lock();
        try {
            object2 = this.sessionMgr.get(string5 + string3 + n2);
            if (this.sessionMgr.size() >= 50) {
                bl2 = true;
            }
        }
        finally {
            r.unlock();
        }
        if (bl2) {
            throw new SpdyErrorException("SPDY_SESSION_EXCEED_MAXED: session count exceed max", -1105);
        }
        if (object2 != null) {
            ((SpdySession)object2).increRefCount();
            return object2;
        }
        SpdySession spdySession = null;
        w.lock();
        try {
            object2 = this.sessionMgr.get(string5 + string3 + n2);
        }
        catch (Throwable throwable) {
            object2 = null;
        }
        if (object2 != null) {
            w.unlock();
            ((SpdySession)object2).increRefCount();
            return object2;
        }
        try {
            int n5;
            long l2;
            spdySession = new SpdySession(0L, this, string5, string3, sessionCb, n2, n3, object);
            byte[] byArray2 = string4 == null ? null : string4.getBytes();
            int n6 = this.getDomainHashIndex(string3 + n2);
            long l3 = this.proxyUsername != null && this.proxyPassword != null ? this.createSessionN(this.agentNativePtr, spdySession, n6, stringArray2[0].getBytes(), (char)Integer.parseInt(stringArray2[1]), byArray, c2, this.proxyUsername.getBytes(), this.proxyPassword.getBytes(), object, n2, n3, n4, byArray2) : this.createSessionN(this.agentNativePtr, spdySession, n6, stringArray2[0].getBytes(), (char)Integer.parseInt(stringArray2[1]), byArray, c2, null, null, object, n2, n3, n4, byArray2);
            spduLog.Logi("tnet-jni", " create new session: " + string2);
            if ((l3 & 1L) == 1L) {
                l2 = 0L;
                n5 = (int)(l3 >> 1);
            } else {
                l2 = l3;
                n5 = 0;
            }
            if (l2 != 0L) {
                spdySession.setSessionNativePtr(l2);
                this.sessionMgr.put(string5 + string3 + n2, spdySession);
                this.sessionQueue.add(spdySession);
            } else {
                if (n5 != 0) {
                    throw new SpdyErrorException("create session error: " + n5, n5);
                }
                spdySession = null;
            }
        }
        finally {
            w.unlock();
        }
        return spdySession;
    }

    @Deprecated
    public SpdySession submitRequest(SpdyRequest spdyRequest, SpdyDataProvider spdyDataProvider, Object object, Object object2, Spdycb spdycb, SessionCb sessionCb, SslCertcb sslCertcb, int n2) throws SpdyErrorException {
        SpdySession spdySession = this.createSession(spdyRequest.getAuthority(), spdyRequest.getDomain(), object, sessionCb, sslCertcb, n2, 0, spdyRequest.getConnectionTimeoutMs());
        spdySession.submitRequest(spdyRequest, spdyDataProvider, object2, spdycb);
        return spdySession;
    }

    @Deprecated
    public SpdySession submitRequest(SpdyRequest spdyRequest, SpdyDataProvider spdyDataProvider, Object object, Object object2, Spdycb spdycb, SessionCb sessionCb, SslCertcb sslCertcb, int n2, int n3) throws SpdyErrorException {
        SpdySession spdySession = this.createSession(spdyRequest.getAuthority(), spdyRequest.getDomain(), object, sessionCb, sslCertcb, n2, n3, spdyRequest.getConnectionTimeoutMs());
        spdySession.submitRequest(spdyRequest, spdyDataProvider, object2, spdycb);
        return spdySession;
    }

    public SpdySession submitRequest(SpdyRequest spdyRequest, SpdyDataProvider spdyDataProvider, Object object, Object object2, Spdycb spdycb, SessionCb sessionCb, int n2, int n3) throws SpdyErrorException {
        return this.submitRequest(spdyRequest, spdyDataProvider, object, object2, spdycb, sessionCb, null, n2, n3);
    }

    @Deprecated
    public SpdySession submitRequest(SpdyRequest spdyRequest, SpdyDataProvider spdyDataProvider, Object object, Object object2, Spdycb spdycb, SessionCb sessionCb, int n2) throws SpdyErrorException {
        return this.submitRequest(spdyRequest, spdyDataProvider, object, object2, spdycb, sessionCb, null, n2);
    }

    private void agentIsOpen() {
        if (this.closed.get()) {
            throw new SpdyErrorException("SPDY_JNI_ERR_ASYNC_CLOSE", -1104);
        }
        this.checkLoadSo();
    }

    public void close() {
    }

    void removeSession(SpdySession spdySession) {
        w.lock();
        try {
            this.sessionQueue.remove(spdySession);
        }
        finally {
            w.unlock();
        }
    }

    int closeSession(long l2) {
        return this.closeSessionN(l2);
    }

    static String[] mapToByteArray(Map<String, String> map) {
        if (map == null || map.size() <= 0) {
            return null;
        }
        int n2 = map.size() * 2;
        String[] stringArray = new String[n2];
        Set<Map.Entry<String, String>> set = map.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        Map.Entry<String, String> entry = null;
        int n3 = 0;
        while (iterator.hasNext()) {
            entry = iterator.next();
            stringArray[n3] = entry.getKey();
            stringArray[n3 + 1] = entry.getValue();
            n3 += 2;
        }
        return stringArray;
    }

    static Map<String, List<String>> stringArrayToMap(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(5);
        int n2 = 0;
        while (n2 + 2 <= stringArray.length) {
            if (stringArray[n2] == null || stringArray[n2 + 1] == null) {
                return null;
            }
            List<String> list = hashMap.get(stringArray[n2]);
            if (list == null) {
                list = new ArrayList<String>(1);
                hashMap.put(stringArray[n2], list);
            }
            list.add(stringArray[n2 + 1]);
            n2 += 2;
        }
        return hashMap;
    }

    @Deprecated
    public int setSessionKind(SpdySessionKind spdySessionKind) {
        int n2 = -1;
        this.agentIsOpen();
        try {
            n2 = this.setSessionKind(this.agentNativePtr, spdySessionKind.getint());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return n2;
    }

    @Deprecated
    public int setConnectTimeOut(int n2) {
        int n3 = 0;
        this.agentIsOpen();
        try {
            n3 = this.setConTimeout(this.agentNativePtr, n2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return n3;
    }

    public void setAccsSslCallback(AccsSSLCallback accsSSLCallback) {
        spduLog.Logi("tnet-jni", "[setAccsSslCallback] - " + accsSSLCallback.getClass());
        this.accsSSLCallback = accsSSLCallback;
    }

    private native int setConTimeout(long var1, int var3);

    private native long initAgent(int var1, int var2, int var3);

    private native int freeAgent(long var1);

    private native long getSession(long var1, byte[] var3, char var4);

    private native int closeSessionN(long var1);

    private native int setSessionKind(long var1, int var3);

    private native long createSessionN(long var1, SpdySession var3, int var4, byte[] var5, char var6, byte[] var7, char var8, byte[] var9, byte[] var10, Object var11, int var12, int var13, int var14, byte[] var15);

    private void spdySessionConnectCB(SpdySession spdySession, SuperviseConnectInfo superviseConnectInfo) {
        spduLog.Logi("tnet-jni", "[spdySessionConnectCB] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdySessionConnectCB] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdySessionConnectCB] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdySessionConnectCB(spdySession, superviseConnectInfo);
        }
    }

    private void spdyDataChunkRecvCB(SpdySession spdySession, boolean bl2, int n2, SpdyByteArray spdyByteArray, int n3) {
        spduLog.Logi("tnet-jni", "[spdyDataChunkRecvCB] - ");
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyDataChunkRecvCB] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyDataChunkRecvCB] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyDataChunkRecvCB(spdySession, bl2, l2, spdyByteArray, n3);
        }
    }

    private void spdyDataRecvCallback(SpdySession spdySession, boolean bl2, int n2, int n3, int n4) {
        spduLog.Logi("tnet-jni", "[spdyDataRecvCallback] - ");
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyDataRecvCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyDataRecvCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyDataRecvCallback(spdySession, bl2, l2, n3, n4);
        }
    }

    private void spdyDataSendCallback(SpdySession spdySession, boolean bl2, int n2, int n3, int n4) {
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyDataSendCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyDataSendCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyDataSendCallback(spdySession, bl2, l2, n3, n4);
        }
    }

    private void spdyStreamCloseCallback(SpdySession spdySession, int n2, int n3, int n4, SuperviseData superviseData) {
        spduLog.Logi("tnet-jni", "[spdyStreamCloseCallback] - ");
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyStreamCloseCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyStreamCloseCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyStreamCloseCallback(spdySession, l2, n3, n4, superviseData);
        }
    }

    private void spdyPingRecvCallback(SpdySession spdySession, int n2, Object object) {
        spduLog.Logi("tnet-jni", "[spdyPingRecvCallback] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyPingRecvCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyPingRecvCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyPingRecvCallback(spdySession, n2, object);
        }
    }

    private void spdyCustomControlFrameRecvCallback(SpdySession spdySession, Object object, int n2, int n3, int n4, int n5, byte[] byArray) {
        spduLog.Logi("tnet-jni", "[spdyCustomControlFrameRecvCallback] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyCustomControlFrameRecvCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyCustomControlFrameRecvCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyCustomControlFrameRecvCallback(spdySession, object, n2, n3, n4, n5, byArray);
        }
    }

    private void spdyCustomControlFrameFailCallback(SpdySession spdySession, Object object, int n2, int n3) {
        spduLog.Logi("tnet-jni", "[spdyCustomControlFrameFailCallback] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyCustomControlFrameFailCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyCustomControlFrameFailCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyCustomControlFrameFailCallback(spdySession, object, n2, n3);
        }
    }

    private void bioPingRecvCallback(SpdySession spdySession, int n2) {
        spduLog.Logi("tnet-jni", "[bioPingRecvCallback] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[bioPingRecvCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[bioPingRecvCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.bioPingRecvCallback(spdySession, n2);
        }
    }

    private void spdyRequestRecvCallback(SpdySession spdySession, int n2, int n3) {
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyRequestRecvCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyRequestRecvCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyRequestRecvCallback(spdySession, l2, n3);
        }
    }

    private void spdyStreamResponseRecv(SpdySession spdySession, int n2, String[] stringArray, int n3) {
        spduLog.Logi("tnet-jni", "[spdyStreamResponseRecv] - ");
        Map<String, List<String>> map = SpdyAgent.stringArrayToMap(stringArray);
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyStreamResponseRecv] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyStreamResponseRecv] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyOnStreamResponse(spdySession, l2, map, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spdySessionCloseCallback(SpdySession spdySession, Object object, SuperviseConnectInfo superviseConnectInfo, int n2) {
        spduLog.Logi("tnet-jni", "[spdySessionCloseCallback] - errorCode = " + n2);
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdySessionCloseCallback] - session is null");
        } else {
            try {
                if (spdySession.intenalcb == null) {
                    spduLog.Logi("tnet-jni", "[spdySessionCloseCallback] - session.intenalcb is null");
                } else {
                    spdySession.intenalcb.spdySessionCloseCallback(spdySession, object, superviseConnectInfo, n2);
                }
            }
            finally {
                spdySession.cleanUp();
            }
        }
        spdySession.releasePptr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spdySessionFailedError(SpdySession spdySession, int n2, Object object) {
        spduLog.Logi("tnet-jni", "[spdySessionFailedError] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdySessionFailedError] - session is null");
        } else {
            try {
                if (spdySession.intenalcb == null) {
                    spduLog.Logi("tnet-jni", "[spdySessionFailedError] - session.intenalcb is null");
                } else {
                    spdySession.intenalcb.spdySessionFailedError(spdySession, n2, object);
                }
            }
            finally {
                spdySession.cleanUp();
            }
        }
        spdySession.releasePptr();
    }

    private void spdySessionOnWritable(SpdySession spdySession, Object object, int n2) {
        spduLog.Logi("tnet-jni", "[spdySessionOnWritable] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdySessionOnWritable] - session is null");
        } else {
            try {
                if (spdySession.intenalcb == null) {
                    spduLog.Logi("tnet-jni", "[spdySessionOnWritable] - session.intenalcb is null");
                } else {
                    spdySession.intenalcb.spdySessionOnWritable(spdySession, object, n2);
                }
            }
            catch (Throwable throwable) {
                spduLog.Loge("tnet-jni", "[spdySessionOnWritable] - exception:" + throwable);
            }
        }
    }

    private byte[] getSSLPublicKey(int n2, byte[] byArray) {
        if (this.accsSSLCallback == null) {
            spduLog.Logd("tnet-jni", "[getSSLPublicKey] - accsSSLCallback is null.");
            return null;
        }
        return this.accsSSLCallback.getSSLPublicKey(n2, byArray);
    }

    private int putSSLMeta(SpdySession spdySession, byte[] byArray) {
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[putSSLMeta] - session is null");
            return -1;
        }
        if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[putSSLMeta] - session.intenalcb is null");
            return -1;
        }
        return spdySession.intenalcb.putSSLMeta(spdySession, byArray);
    }

    private byte[] getSSLMeta(SpdySession spdySession) {
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[getSSLMeta] - session is null");
            return null;
        }
        if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[getSSLMeta] - session.intenalcb is null");
            return null;
        }
        return spdySession.intenalcb.getSSLMeta(spdySession);
    }

    private void getPerformance(SpdySession spdySession, SslPermData sslPermData) {
    }

    public HashMap<String, SpdySession> getAllSession() {
        return this.sessionMgr;
    }

    private static void crashReporter(int n2) {
    }

    public int configLogFile(String string2, int n2, int n3) {
        return loadSucc ? this.configLogFileN(string2, n2, n3) : -1;
    }

    public int configLogFile(String string2, int n2, int n3, int n4) {
        return loadSucc ? this.configLogFileN(string2, n2, n3, n4) : -1;
    }

    public void logFileFlush() {
        if (loadSucc) {
            this.logFileFlushN();
        }
    }

    public void logFileClose() {
        if (loadSucc) {
            this.logFileFlushN();
            this.logFileCloseN();
        }
    }

    private native int configLogFileN(String var1, int var2, int var3);

    private native int configLogFileN(String var1, int var2, int var3, int var4);

    private native void logFileFlushN();

    private native void logFileCloseN();

    @Deprecated
    public void switchAccsServer(int n2) {
    }

    @Deprecated
    public static void inspect(String string2) {
    }

    private static native int configIpStackModeN(int var0);

    public static int configIpStackMode(int n2) {
        spduLog.Logi("tnet-jni", "[configIpStackMode] - " + n2);
        return SpdyAgent.configIpStackModeN(n2);
    }
}

