/*
 * Decompiled with CFR 0.152.
 */
package org.android.spdy;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class SoInstallMgrSdk {
    private static final String ARMEABI = "armeabi";
    private static final String X86 = "x86";
    private static final String MIPS = "mips";
    static Context mContext = null;
    private static final int EventID_SO_INIT = 21033;
    static final String LOGTAG = "INIT_SO";

    public static void init(Context context) {
        mContext = context;
    }

    public static boolean initSo(String string2, int n2) {
        return SoInstallMgrSdk.initSo(string2, n2, null);
    }

    public static boolean initSo(String string2, int n2, ClassLoader classLoader) {
        boolean bl2 = false;
        try {
            if (classLoader == null) {
                System.loadLibrary(string2);
            } else {
                Runtime runtime = Runtime.getRuntime();
                Class[] classArray = new Class[]{String.class, ClassLoader.class};
                Method method = Runtime.class.getDeclaredMethod("loadLibrary", classArray);
                method.setAccessible(true);
                method.invoke((Object)runtime, string2, classLoader);
            }
            bl2 = true;
        }
        catch (Exception exception) {
            bl2 = false;
            exception.printStackTrace();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl2 = false;
            unsatisfiedLinkError.printStackTrace();
        }
        catch (Error error) {
            bl2 = false;
            error.printStackTrace();
        }
        try {
            if (!bl2) {
                String string3;
                if (SoInstallMgrSdk.isExist(string2, n2)) {
                    boolean bl3 = SoInstallMgrSdk._loadUnzipSo(string2, n2, classLoader);
                    if (bl3) {
                        return bl3;
                    }
                    SoInstallMgrSdk.removeSoIfExit(string2, n2);
                }
                if (!(string3 = SoInstallMgrSdk._cpuType()).equalsIgnoreCase(MIPS) && !string3.equalsIgnoreCase(X86)) {
                    try {
                        bl2 = SoInstallMgrSdk.unZipSelectedFiles(string2, n2, classLoader);
                    }
                    catch (ZipException zipException) {
                        zipException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            bl2 = false;
            exception.printStackTrace();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl2 = false;
            unsatisfiedLinkError.printStackTrace();
        }
        catch (Error error) {
            bl2 = false;
            error.printStackTrace();
        }
        if (!bl2) {
            // empty if block
        }
        return bl2;
    }

    private static String _getFieldReflectively(Build build, String string2) {
        try {
            Field field = Build.class.getField(string2);
            return field.get(build).toString();
        }
        catch (Exception exception) {
            return "Unknown";
        }
    }

    private static String _cpuType() {
        String string2 = SoInstallMgrSdk._getFieldReflectively(new Build(), "CPU_ABI");
        if (string2 == null || string2.length() == 0 || string2.equals("Unknown")) {
            string2 = ARMEABI;
        }
        string2 = string2.toLowerCase();
        return string2;
    }

    static String _targetSoFile(String string2, int n2) {
        Context context = mContext;
        if (null == context) {
            return "";
        }
        String string3 = "/data/data/" + context.getPackageName() + "/files";
        File file = context.getFilesDir();
        if (file != null) {
            string3 = file.getPath();
        }
        return string3 + "/lib" + string2 + "bk" + n2 + ".so";
    }

    static void removeSoIfExit(String string2, int n2) {
        String string3 = SoInstallMgrSdk._targetSoFile(string2, n2);
        File file = new File(string3);
        if (file.exists()) {
            file.delete();
        }
    }

    static boolean isExist(String string2, int n2) {
        String string3 = SoInstallMgrSdk._targetSoFile(string2, n2);
        File file = new File(string3);
        return file.exists();
    }

    static boolean _loadUnzipSo(String string2, int n2, ClassLoader classLoader) {
        boolean bl2 = false;
        try {
            if (SoInstallMgrSdk.isExist(string2, n2)) {
                if (classLoader == null) {
                    System.load(SoInstallMgrSdk._targetSoFile(string2, n2));
                } else {
                    Runtime runtime = Runtime.getRuntime();
                    Class[] classArray = new Class[]{String.class, ClassLoader.class};
                    Method method = Runtime.class.getDeclaredMethod("load", classArray);
                    method.setAccessible(true);
                    method.invoke((Object)runtime, SoInstallMgrSdk._targetSoFile(string2, n2), classLoader);
                }
            }
            bl2 = true;
        }
        catch (Exception exception) {
            bl2 = false;
            exception.printStackTrace();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl2 = false;
            unsatisfiedLinkError.printStackTrace();
        }
        catch (Error error) {
            bl2 = false;
            error.printStackTrace();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean unZipSelectedFiles(String string2, int n2, ClassLoader classLoader) throws ZipException, IOException {
        String string3 = "lib/armeabi/lib" + string2 + ".so";
        try {
            String string4 = "";
            Context context = mContext;
            if (context == null) {
                return false;
            }
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            if (null != applicationInfo) {
                string4 = applicationInfo.sourceDir;
            }
            ZipFile zipFile = new ZipFile(string4);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string5 = zipEntry.getName();
                if (string5.contains("..") || string5.contains("\\") || string5.contains("%")) {
                    return false;
                }
                if (!zipEntry.getName().startsWith(string3)) continue;
                InputStream inputStream = null;
                FileOutputStream fileOutputStream = null;
                AbstractInterruptibleChannel abstractInterruptibleChannel = null;
                int n3 = 0;
                try {
                    int n4;
                    SoInstallMgrSdk.removeSoIfExit(string2, n2);
                    inputStream = zipFile.getInputStream(zipEntry);
                    fileOutputStream = context.openFileOutput("lib" + string2 + "bk" + n2 + ".so", 0);
                    abstractInterruptibleChannel = fileOutputStream.getChannel();
                    byte[] byArray = new byte[1024];
                    while ((n4 = inputStream.read(byArray)) > 0) {
                        ((FileChannel)abstractInterruptibleChannel).write(ByteBuffer.wrap(byArray, 0, n4));
                        n3 += n4;
                    }
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (abstractInterruptibleChannel != null) {
                        try {
                            abstractInterruptibleChannel.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (zipFile != null) {
                        zipFile.close();
                        zipFile = null;
                    }
                }
                if (n3 > 0) {
                    return SoInstallMgrSdk._loadUnzipSo(string2, n2, classLoader);
                }
                return false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }
}

