/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tlog.adapter;

import android.taobao.windvane.jsbridge.WVApiPlugin;
import android.taobao.windvane.jsbridge.WVCallBackContext;
import android.taobao.windvane.jsbridge.WVPluginManager;
import android.taobao.windvane.jsbridge.WVResult;
import android.text.TextUtils;
import com.taobao.tlog.adapter.AdapterForTLog;
import org.json.JSONException;
import org.json.JSONObject;

public class JSLogBridge
extends WVApiPlugin {
    private static final String LOGV = "logv";
    private static final String LOGD = "logd";
    private static final String LOGI = "logi";
    private static final String LOGW = "logw";
    private static final String LOGE = "loge";
    private static final String GETLOGLEVEL = "getLogLevel";
    private static final String tlogBridgeName = "tlogBridge";

    public static void init() {
        WVPluginManager.registerPlugin((String)tlogBridgeName, JSLogBridge.class, (boolean)true);
    }

    public boolean execute(String string2, String string3, WVCallBackContext wVCallBackContext) {
        if (!TextUtils.isEmpty((CharSequence)string2) && wVCallBackContext != null) {
            if (GETLOGLEVEL.equals(string2)) {
                WVResult wVResult = new WVResult();
                wVResult.addData("logLevel", AdapterForTLog.getLogLevel());
                wVCallBackContext.success(wVResult);
            } else if (LOGV.equals(string2)) {
                this.logv(string3, wVCallBackContext);
            } else if (LOGD.equals(string2)) {
                this.logd(string3, wVCallBackContext);
            } else if (LOGI.equals(string2)) {
                this.logi(string3, wVCallBackContext);
            } else if (LOGW.equals(string2)) {
                this.logw(string3, wVCallBackContext);
            } else if (LOGE.equals(string2)) {
                this.loge(string3, wVCallBackContext);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public void logv(String string2, WVCallBackContext wVCallBackContext) {
        LogBody logBody = this.getLog(string2);
        if (logBody != null) {
            AdapterForTLog.logv(logBody.tag, string2);
            wVCallBackContext.success();
        } else {
            wVCallBackContext.error("the tag is null!");
        }
    }

    public void logd(String string2, WVCallBackContext wVCallBackContext) {
        LogBody logBody = this.getLog(string2);
        if (logBody != null) {
            AdapterForTLog.logd(logBody.tag, string2);
            wVCallBackContext.success();
        } else {
            wVCallBackContext.error("the tag is null!");
        }
    }

    public void logi(String string2, WVCallBackContext wVCallBackContext) {
        LogBody logBody = this.getLog(string2);
        if (logBody != null) {
            AdapterForTLog.logi(logBody.tag, string2);
            wVCallBackContext.success();
        } else {
            wVCallBackContext.error("the tag is null!");
        }
    }

    public void logw(String string2, WVCallBackContext wVCallBackContext) {
        LogBody logBody = this.getLog(string2);
        if (logBody != null) {
            AdapterForTLog.logw(logBody.tag, string2);
            wVCallBackContext.success();
        } else {
            wVCallBackContext.error("the tag is null!");
        }
    }

    public void loge(String string2, WVCallBackContext wVCallBackContext) {
        LogBody logBody = this.getLog(string2);
        if (logBody != null) {
            AdapterForTLog.loge(logBody.tag, string2);
            wVCallBackContext.success();
        } else {
            wVCallBackContext.error("the tag is null!");
        }
    }

    private LogBody getLog(String string2) {
        try {
            LogBody logBody = new LogBody();
            JSONObject jSONObject = new JSONObject(string2);
            logBody.tag = jSONObject.optString("tag", "jsTag");
            logBody.data = jSONObject.optString("content", "");
            return logBody;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    class LogBody {
        String tag;
        String module;
        String data;

        LogBody() {
        }
    }
}

