/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import com.taobao.accs.ChannelService;
import com.taobao.accs.base.BaseService;
import com.taobao.accs.utl.ALog;

public class ChannelService
extends BaseService {
    public static int SDK_VERSION_CODE = 221;
    public static final int DEFAULT_FORGROUND_V = 24;
    static final int NOTIFY_ID = 9371;
    static final String TAG = "ChannelService";
    private static ChannelService mInstance;
    private boolean mFristStarted = true;
    public static final String SUPPORT_FOREGROUND_VERSION_KEY = "support_foreground_v";

    public static ChannelService getInstance() {
        return mInstance;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        mInstance = this;
        if (Build.VERSION.SDK_INT < 18) {
            try {
                this.startForeground(9371, new Notification());
            }
            catch (Throwable throwable) {
                ALog.e(TAG, "ChannelService onCreate", throwable, new Object[0]);
            }
        }
    }

    @Override
    public int onStartCommand(Intent intent, int n2, int n3) {
        if (this.mFristStarted) {
            this.mFristStarted = false;
            ChannelService.startKernel(this.getApplicationContext());
        }
        return super.onStartCommand(intent, n2, n3);
    }

    @Override
    public void onDestroy() {
        if (Build.VERSION.SDK_INT < 18) {
            try {
                this.stopForeground(true);
            }
            catch (Throwable throwable) {
                ALog.e(TAG, "ChannelService onDestroy", throwable, new Object[0]);
            }
        }
        ChannelService.stopKernel(this.getApplicationContext());
        super.onDestroy();
    }

    static void startKernel(Context context) {
        try {
            int n2 = ChannelService.getSupportForegroundVer(context);
            if (Build.VERSION.SDK_INT < n2) {
                Intent intent = new Intent(context, KernelService.class);
                intent.setPackage(context.getPackageName());
                context.startService(intent);
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "startKernel", throwable, new Object[0]);
        }
    }

    static void stopKernel(Context context) {
        try {
            int n2 = ChannelService.getSupportForegroundVer(context);
            if (Build.VERSION.SDK_INT < n2) {
                Intent intent = new Intent(context, KernelService.class);
                intent.setPackage(context.getPackageName());
                context.stopService(intent);
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "stopKernel", throwable, new Object[0]);
        }
    }

    static int getSupportForegroundVer(Context context) {
        int n2 = 24;
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences("ACCS_SDK", 0);
            n2 = sharedPreferences.getInt(SUPPORT_FOREGROUND_VERSION_KEY, 24);
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "getSupportForegroundVer fail:", throwable, "key", SUPPORT_FOREGROUND_VERSION_KEY);
        }
        return n2;
    }
}

