/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.taobao.accs.AccsClientConfig$Builder;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.k;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AccsClientConfig {
    private static final String TAG = "AccsClientConfig";
    public static final int SECURITY_TAOBAO = 0;
    public static final int SECURITY_OPEN = 1;
    public static final int SECURITY_OFF = 2;
    public static final String DEFAULT_CONFIGTAG = "default";
    public static final String[] DEFAULT_CENTER_HOSTS = new String[]{"msgacs.m.taobao.com", "msgacs.wapa.taobao.com", "msgacs.waptest.taobao.com"};
    private static final String[] DEFAULT_CHANNEL_HOSTS = new String[]{"accscdn.m.taobao.com", "acs.wapa.taobao.com", "acs.waptest.taobao.com"};
    private static Context mContext;
    public static boolean loadedStaticConfig;
    public static int mEnv;
    private static Map mReleaseConfigs;
    private static Map mPreviewConfigs;
    private static Map mDebugConfigs;
    private String mAppKey;
    private String mAppSecret;
    private String mInappHost;
    private String mChannelHost;
    private String mStoreId;
    private int mSecurity;
    private String mAuthCode;
    private int mInappPubKey;
    private int mChannelPubKey;
    private boolean mKeepalive;
    private boolean mAutoUnit;
    private String mTag;
    private int mConfigEnv;
    private boolean mDisableChannel;
    private boolean mQuickReconnect;
    private boolean mAccsHeartbeatEnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getContext() {
        if (mContext != null) {
            return mContext;
        }
        Class<AccsClientConfig> clazz = AccsClientConfig.class;
        synchronized (AccsClientConfig.class) {
            if (mContext != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mContext;
            }
            try {
                Class<?> clazz2 = Class.forName("android.app.ActivityThread");
                Object object = clazz2.getMethod("currentActivityThread", new Class[0]).invoke(clazz2, new Object[0]);
                mContext = (Context)object.getClass().getMethod("getApplication", new Class[0]).invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return mContext;
        }
    }

    protected AccsClientConfig() {
    }

    public static AccsClientConfig getConfig(String string2) {
        Map map;
        switch (mEnv) {
            case 1: {
                map = mPreviewConfigs;
                break;
            }
            case 2: {
                map = mDebugConfigs;
                break;
            }
            default: {
                map = mReleaseConfigs;
            }
        }
        for (AccsClientConfig accsClientConfig : map.values()) {
            if (!accsClientConfig.mAppKey.equals(string2) || accsClientConfig.mConfigEnv != mEnv) continue;
            return accsClientConfig;
        }
        ALog.e(TAG, "getConfigByTag return null", "appkey", string2);
        return null;
    }

    public static AccsClientConfig getConfigByTag(String string2) {
        Map map;
        switch (mEnv) {
            case 1: {
                map = mPreviewConfigs;
                break;
            }
            case 2: {
                map = mDebugConfigs;
                break;
            }
            default: {
                map = mReleaseConfigs;
            }
        }
        AccsClientConfig accsClientConfig = (AccsClientConfig)map.get(string2);
        if (accsClientConfig == null) {
            ALog.e(TAG, "getConfigByTag return null", "configTag", string2);
        }
        return accsClientConfig;
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public String getAppSecret() {
        return this.mAppSecret;
    }

    public String getInappHost() {
        return this.mInappHost;
    }

    public String getChannelHost() {
        return this.mChannelHost;
    }

    public int getSecurity() {
        return this.mSecurity;
    }

    public String getAuthCode() {
        return this.mAuthCode;
    }

    public int getInappPubKey() {
        return this.mInappPubKey;
    }

    public int getChannelPubKey() {
        return this.mChannelPubKey;
    }

    public boolean isKeepalive() {
        return this.mKeepalive;
    }

    public boolean isAutoUnit() {
        return this.mAutoUnit;
    }

    public String getTag() {
        return this.mTag;
    }

    public int getConfigEnv() {
        return this.mConfigEnv;
    }

    public boolean getDisableChannel() {
        return this.mDisableChannel;
    }

    public boolean isQuickReconnect() {
        return this.mQuickReconnect;
    }

    public String getStoreId() {
        return this.mStoreId;
    }

    public boolean isAccsHeartbeatEnable() {
        return this.mAccsHeartbeatEnable;
    }

    public String toString() {
        return "AccsClientConfig{" + "Tag=" + this.mTag + ", ConfigEnv=" + this.mConfigEnv + ", AppKey=" + this.mAppKey + ", AppSecret=" + this.mAppSecret + ", InappHost=" + this.mInappHost + ", ChannelHost=" + this.mChannelHost + ", Security=" + this.mSecurity + ", AuthCode=" + this.mAuthCode + ", InappPubKey=" + this.mInappPubKey + ", ChannelPubKey=" + this.mChannelPubKey + ", Keepalive=" + this.mKeepalive + ", AutoUnit=" + this.mAutoUnit + ", DisableChannel=" + this.mDisableChannel + ", QuickReconnect=" + this.mQuickReconnect + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AccsClientConfig accsClientConfig = (AccsClientConfig)object;
        if (!this.mInappHost.equals(accsClientConfig.mInappHost)) {
            return false;
        }
        if (this.mInappPubKey != accsClientConfig.mInappPubKey) {
            return false;
        }
        if (!this.mChannelHost.equals(accsClientConfig.mChannelHost)) {
            return false;
        }
        if (this.mChannelPubKey != accsClientConfig.mChannelPubKey) {
            return false;
        }
        if (this.mSecurity != accsClientConfig.mSecurity) {
            return false;
        }
        if (this.mConfigEnv != accsClientConfig.mConfigEnv) {
            return false;
        }
        if (!this.mAppKey.equals(accsClientConfig.mAppKey)) {
            return false;
        }
        if (this.mKeepalive != accsClientConfig.mKeepalive) {
            return false;
        }
        if (this.mDisableChannel != accsClientConfig.mDisableChannel) {
            return false;
        }
        if (this.mAuthCode != null ? !this.mAuthCode.equals(accsClientConfig.mAuthCode) : accsClientConfig.mAuthCode != null) {
            return false;
        }
        if (this.mAppSecret != null ? !this.mAppSecret.equals(accsClientConfig.mAppSecret) : accsClientConfig.mAppSecret != null) {
            return false;
        }
        return this.mTag.equals(accsClientConfig.mTag);
    }

    static /* synthetic */ String access$002(AccsClientConfig accsClientConfig, String string2) {
        accsClientConfig.mAppKey = string2;
        return accsClientConfig.mAppKey;
    }

    static /* synthetic */ String access$102(AccsClientConfig accsClientConfig, String string2) {
        accsClientConfig.mAppSecret = string2;
        return accsClientConfig.mAppSecret;
    }

    static /* synthetic */ String access$202(AccsClientConfig accsClientConfig, String string2) {
        accsClientConfig.mAuthCode = string2;
        return accsClientConfig.mAuthCode;
    }

    static /* synthetic */ boolean access$302(AccsClientConfig accsClientConfig, boolean bl2) {
        accsClientConfig.mKeepalive = bl2;
        return accsClientConfig.mKeepalive;
    }

    static /* synthetic */ boolean access$402(AccsClientConfig accsClientConfig, boolean bl2) {
        accsClientConfig.mAutoUnit = bl2;
        return accsClientConfig.mAutoUnit;
    }

    static /* synthetic */ int access$502(AccsClientConfig accsClientConfig, int n2) {
        accsClientConfig.mInappPubKey = n2;
        return accsClientConfig.mInappPubKey;
    }

    static /* synthetic */ int access$602(AccsClientConfig accsClientConfig, int n2) {
        accsClientConfig.mChannelPubKey = n2;
        return accsClientConfig.mChannelPubKey;
    }

    static /* synthetic */ String access$702(AccsClientConfig accsClientConfig, String string2) {
        accsClientConfig.mInappHost = string2;
        return accsClientConfig.mInappHost;
    }

    static /* synthetic */ String access$802(AccsClientConfig accsClientConfig, String string2) {
        accsClientConfig.mChannelHost = string2;
        return accsClientConfig.mChannelHost;
    }

    static /* synthetic */ String access$902(AccsClientConfig accsClientConfig, String string2) {
        accsClientConfig.mTag = string2;
        return accsClientConfig.mTag;
    }

    static /* synthetic */ String access$1002(AccsClientConfig accsClientConfig, String string2) {
        accsClientConfig.mStoreId = string2;
        return accsClientConfig.mStoreId;
    }

    static /* synthetic */ int access$1102(AccsClientConfig accsClientConfig, int n2) {
        accsClientConfig.mConfigEnv = n2;
        return accsClientConfig.mConfigEnv;
    }

    static /* synthetic */ boolean access$1202(AccsClientConfig accsClientConfig, boolean bl2) {
        accsClientConfig.mDisableChannel = bl2;
        return accsClientConfig.mDisableChannel;
    }

    static /* synthetic */ boolean access$1302(AccsClientConfig accsClientConfig, boolean bl2) {
        accsClientConfig.mQuickReconnect = bl2;
        return accsClientConfig.mQuickReconnect;
    }

    static /* synthetic */ boolean access$1402(AccsClientConfig accsClientConfig, boolean bl2) {
        accsClientConfig.mAccsHeartbeatEnable = bl2;
        return accsClientConfig.mAccsHeartbeatEnable;
    }

    static /* synthetic */ int access$1100(AccsClientConfig accsClientConfig) {
        return accsClientConfig.mConfigEnv;
    }

    static /* synthetic */ String access$100(AccsClientConfig accsClientConfig) {
        return accsClientConfig.mAppSecret;
    }

    static /* synthetic */ int access$1502(AccsClientConfig accsClientConfig, int n2) {
        accsClientConfig.mSecurity = n2;
        return accsClientConfig.mSecurity;
    }

    static /* synthetic */ String access$700(AccsClientConfig accsClientConfig) {
        return accsClientConfig.mInappHost;
    }

    static /* synthetic */ String access$800(AccsClientConfig accsClientConfig) {
        return accsClientConfig.mChannelHost;
    }

    static /* synthetic */ String[] access$1600() {
        return DEFAULT_CHANNEL_HOSTS;
    }

    static /* synthetic */ String access$900(AccsClientConfig accsClientConfig) {
        return accsClientConfig.mTag;
    }

    static /* synthetic */ String access$000(AccsClientConfig accsClientConfig) {
        return accsClientConfig.mAppKey;
    }

    static /* synthetic */ Map access$1700() {
        return mPreviewConfigs;
    }

    static /* synthetic */ Map access$1800() {
        return mDebugConfigs;
    }

    static /* synthetic */ Map access$1900() {
        return mReleaseConfigs;
    }

    static {
        loadedStaticConfig = false;
        mEnv = 0;
        mReleaseConfigs = new ConcurrentHashMap(1);
        mPreviewConfigs = new ConcurrentHashMap(1);
        mDebugConfigs = new ConcurrentHashMap(1);
        try {
            Bundle bundle = k.g(AccsClientConfig.getContext());
            if (bundle != null) {
                String string2 = bundle.getString("accsConfigTags", null);
                ALog.i(TAG, "init config from xml", "configtags", string2);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    String[] stringArray = string2.split("\\|");
                    if (stringArray == null) {
                        stringArray = new String[]{string2};
                    }
                    for (String string3 : stringArray) {
                        if (TextUtils.isEmpty((CharSequence)string3)) continue;
                        int n2 = bundle.getInt(string3 + "_accsAppkey", -1);
                        String string4 = n2 < 0 ? null : String.valueOf(n2);
                        String string5 = bundle.getString(string3 + "_accsAppSecret");
                        String string6 = bundle.getString(string3 + "_authCode");
                        boolean bl2 = bundle.getBoolean(string3 + "_keepAlive", true);
                        boolean bl3 = bundle.getBoolean(string3 + "_autoUnit", true);
                        int n3 = bundle.getInt(string3 + "_inappPubkey", -1);
                        int n4 = bundle.getInt(string3 + "_channelPubkey", -1);
                        String string7 = bundle.getString(string3 + "_inappHost");
                        String string8 = bundle.getString(string3 + "_channelHost");
                        int n5 = bundle.getInt(string3 + "_configEnv", 0);
                        boolean bl4 = bundle.getBoolean(string3 + "_disableChannel");
                        if (TextUtils.isEmpty((CharSequence)string4)) continue;
                        new AccsClientConfig$Builder().setTag(string3).setConfigEnv(n5).setAppKey(string4).setAppSecret(string5).setAutoCode(string6).setKeepAlive(bl2).setAutoUnit(bl3).setInappHost(string7).setInappPubKey(n3).setChannelHost(string8).setChannelPubKey(n4).setDisableChannel(bl4).build();
                        ALog.i(TAG, "init config from xml", new Object[0]);
                    }
                    loadedStaticConfig = true;
                }
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "init config from xml", throwable, new Object[0]);
        }
    }
}

