/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs;

import android.content.Context;
import android.text.TextUtils;
import anet.channel.SessionCenter;
import anet.channel.entity.ENV;
import com.taobao.accs.ACCSManager;
import com.taobao.accs.ACCSManager$AccsRequest;
import com.taobao.accs.AccsClientConfig;
import com.taobao.accs.AccsClientConfig$Builder;
import com.taobao.accs.AccsException;
import com.taobao.accs.IAppReceiver;
import com.taobao.accs.ILoginInfo;
import com.taobao.accs.b;
import com.taobao.accs.base.AccsAbstractDataListener;
import com.taobao.accs.base.TaoBaseService$ExtraInfo;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.k;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ACCSClient {
    protected b mAccsManager;
    private static String TAG = "ACCSClient";
    private String OTAG = TAG;
    private static Context mContext;
    private AccsClientConfig mConfig;
    public static Map mACCSClients;

    public ACCSClient(AccsClientConfig accsClientConfig) {
        this.mConfig = accsClientConfig;
        this.OTAG = this.OTAG + accsClientConfig.getTag();
        this.mAccsManager = ACCSManager.getAccsInstance(mContext, accsClientConfig.getAppKey(), accsClientConfig.getTag());
    }

    public static synchronized String init(Context context, String string2) {
        if (context == null || TextUtils.isEmpty((CharSequence)string2)) {
            throw new AccsException("params error");
        }
        AccsClientConfig accsClientConfig = AccsClientConfig.getConfigByTag(string2);
        if (!AccsClientConfig.loadedStaticConfig) {
            AccsClientConfig$Builder accsClientConfig$Builder = new AccsClientConfig$Builder();
            accsClientConfig = accsClientConfig$Builder.setAppKey(string2).build();
            ALog.i(TAG, "init", "create config, appkey as tag");
        }
        return ACCSClient.init(context, accsClientConfig);
    }

    public static synchronized String init(Context context, AccsClientConfig accsClientConfig) {
        boolean bl2;
        if (context == null || accsClientConfig == null) {
            throw new AccsException("init AccsClient params error");
        }
        boolean bl3 = bl2 = (context.getApplicationInfo().flags & 2) != 0;
        if (bl2) {
            ALog.isUseTlog = false;
            anet.channel.util.ALog.setUseTlog(false);
        }
        mContext = context.getApplicationContext();
        ALog.d(TAG, "init", "config", accsClientConfig);
        return accsClientConfig.getTag();
    }

    public static ACCSClient getAccsClient() {
        return ACCSClient.getAccsClient(null);
    }

    public static synchronized ACCSClient getAccsClient(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "default";
            ALog.w(TAG, "getAccsClient", "configTag is null, use default!");
        }
        ALog.i(TAG, "getAccsClient", "configTag", string2);
        AccsClientConfig accsClientConfig = AccsClientConfig.getConfigByTag(string2);
        if (accsClientConfig == null) {
            ALog.e(TAG, "getAccsClient", "configTag not exist, please init first!!");
            throw new AccsException("configTag not exist");
        }
        ACCSClient aCCSClient = (ACCSClient)mACCSClients.get(string2);
        if (aCCSClient == null) {
            ALog.d(TAG, "getAccsClient create client", new Object[0]);
            aCCSClient = new ACCSClient(accsClientConfig);
            mACCSClients.put(string2, aCCSClient);
            aCCSClient.updateConfig(accsClientConfig);
            return aCCSClient;
        }
        if (accsClientConfig.equals(aCCSClient.mConfig)) {
            ALog.i(TAG, "getAccsClient exists", new Object[0]);
        } else {
            ALog.i(TAG, "getAccsClient update config", "old config", aCCSClient.mConfig.getTag(), "new config", accsClientConfig.getTag());
            aCCSClient.updateConfig(accsClientConfig);
        }
        return aCCSClient;
    }

    private void updateConfig(AccsClientConfig accsClientConfig) {
        this.mConfig = accsClientConfig;
        this.mAccsManager = ACCSManager.getAccsInstance(mContext, accsClientConfig.getAppKey(), accsClientConfig.getTag());
        if (this.mAccsManager != null) {
            this.mAccsManager.a(accsClientConfig);
        }
    }

    public static synchronized void setEnvironment(Context context, int n2) {
        int n3 = n2;
        try {
            int n4;
            if (context != null) {
                int n5 = n4 = (context.getApplicationInfo().flags & 2) != 0 ? 1 : 0;
                if (n4 != 0) {
                    ALog.isUseTlog = false;
                    anet.channel.util.ALog.setUseTlog(false);
                }
            }
            if (n2 < 0 || n2 > 2) {
                ALog.e(TAG, "env error", "env", n2);
                n3 = 0;
            }
            n4 = AccsClientConfig.mEnv;
            AccsClientConfig.mEnv = n3;
            if (n4 != n3 && k.e(context)) {
                ALog.i(TAG, "setEnvironment", "preEnv", n4, "toEnv", n3);
                k.c(context);
                k.f(context);
                k.d(context);
                if (n3 == 2) {
                    SessionCenter.switchEnvironment(ENV.TEST);
                } else if (n3 == 1) {
                    SessionCenter.switchEnvironment(ENV.PREPARE);
                }
                for (Map.Entry entry : mACCSClients.entrySet()) {
                    try {
                        ACCSClient.getAccsClient((String)entry.getKey());
                    }
                    catch (AccsException accsException) {
                        ALog.e(TAG, "setEnvironment update client", accsException, new Object[0]);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "setEnvironment", throwable, new Object[0]);
        }
        finally {
            k.a(context, n3);
        }
    }

    public void bindApp(String string2, IAppReceiver iAppReceiver) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "bindApp mAccsManager null", new Object[0]);
            return;
        }
        String string3 = this.mConfig.getAppKey();
        this.mConfig.getAppSecret();
        this.mAccsManager.a(mContext, string3, string2, iAppReceiver);
    }

    public void bindUser(String string2) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "bindUser mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext, string2);
    }

    public void bindUser(String string2, boolean bl2) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "bindUser mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext, string2, bl2);
    }

    public void unbindUser() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unbindUser mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext);
    }

    public void bindService(String string2) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "bindService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.b(mContext, string2);
    }

    public void unbindService(String string2) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unbindService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.c(mContext, string2);
    }

    public String sendData(ACCSManager$AccsRequest aCCSManager$AccsRequest) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "sendData mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.a(mContext, aCCSManager$AccsRequest);
    }

    public String sendRequest(ACCSManager$AccsRequest aCCSManager$AccsRequest) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "sendRequest mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.b(mContext, aCCSManager$AccsRequest);
    }

    public String sendPushResponse(ACCSManager$AccsRequest aCCSManager$AccsRequest, TaoBaseService$ExtraInfo taoBaseService$ExtraInfo) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "sendPushResponse mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.a(mContext, aCCSManager$AccsRequest, taoBaseService$ExtraInfo);
    }

    public boolean isNetworkReachable() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "isNetworkReachable mAccsManager null", new Object[0]);
            return false;
        }
        return this.mAccsManager.b(mContext);
    }

    public void forceDisableService() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "forceDisableService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.c(mContext);
    }

    public void forceEnableService() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "forceEnableService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.d(mContext);
    }

    public void startInAppConnection(String string2, IAppReceiver iAppReceiver) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "startInAppConnection mAccsManager null", new Object[0]);
            return;
        }
        String string3 = this.mConfig.getAppKey();
        this.mConfig.getAppSecret();
        this.mAccsManager.b(mContext, string3, string2, iAppReceiver);
    }

    public void setLoginInfo(ILoginInfo iLoginInfo) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "setLoginInfo mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext, iLoginInfo);
    }

    public void clearLoginInfo() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "clearLoginInfo mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.e(mContext);
    }

    public boolean cancel(String string2) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "cancel mAccsManager null", new Object[0]);
            return false;
        }
        return this.mAccsManager.a(string2);
    }

    public boolean isChannelError(int n2) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "isChannelError mAccsManager null", new Object[0]);
            return true;
        }
        return this.mAccsManager.a(n2);
    }

    public Map getChannelState() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "getChannelState mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.a();
    }

    public Map forceReConnectChannel() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "forceReConnectChannel mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.b();
    }

    public String getUserUnit() {
        return null;
    }

    public void registerSerivce(String string2, String string3) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "registerSerivce mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext, string2, string3);
    }

    public void unRegisterSerivce(String string2) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unRegisterSerivce mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.d(mContext, string2);
    }

    public void registerDataListener(String string2, AccsAbstractDataListener accsAbstractDataListener) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "registerDataListener mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext, string2, accsAbstractDataListener);
    }

    public void unRegisterDataListener(String string2) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unRegisterDataListener mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.e(mContext, string2);
    }

    public void sendBusinessAck(String string2, String string3, String string4, short s2, String string5, Map map) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "sendBusinessAck mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(string2, string3, string4, s2, string5, map);
    }

    static {
        mACCSClients = new ConcurrentHashMap(2);
    }
}

