/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.message;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.bytedance.ttgame.module.push.R;
import com.meizu.cloud.pushsdk.MzPushMessageReceiver;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import com.ss.android.push.PushDependManager;
import g.optional.push.bk;
import g.optional.push.ev;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import org.json.JSONObject;

public class MzMessageReceiver
extends MzPushMessageReceiver {
    public void onHandleIntent(Context context, Intent intent) {
        try {
            super.onHandleIntent(context, intent);
            MzMessageReceiver.printLog("onHandleIntent " + intent.toUri(0));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void onRegister(Context context, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        MzMessageReceiver.printLog("register " + string2);
        this.handleMessage(context, 0, string2, 8);
    }

    public void onMessage(Context context, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        MzMessageReceiver.printLog("message " + string2);
        JSONObject jSONObject = null;
        try {
            char c2 = string2.charAt(0);
            if (c2 != 'a' && c2 != 'c') {
                string2 = 'a' + string2;
            }
            jSONObject = PushDependManager.inst().getMessage(string2.getBytes(), true);
        }
        catch (DataFormatException dataFormatException) {
            dataFormatException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (jSONObject == null) {
            return;
        }
        this.handleMessage(context, 1, jSONObject.toString(), 8);
    }

    public void onMessage(Context context, Intent intent) {
        try {
            Object object;
            JSONObject jSONObject = new JSONObject();
            Bundle bundle = intent.getExtras();
            if (bundle != null && !bundle.isEmpty()) {
                object = bundle.keySet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    try {
                        jSONObject.put(string2, bundle.get(string2));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            object = jSONObject.toString();
            MzMessageReceiver.printLog("flyme3 onMessage " + (String)object);
            this.onMessage(context, (String)object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void onUpdateNotificationBuilder(PushNotificationBuilder pushNotificationBuilder) {
        pushNotificationBuilder.setmStatusbarIcon(R.drawable.mz_push_notification_small_icon);
    }

    public void onUnRegister(Context context, boolean bl2) {
        MzMessageReceiver.printLog("onUnRegister: " + bl2);
    }

    public void onPushStatus(Context context, PushSwitchStatus pushSwitchStatus) {
        if (pushSwitchStatus == null) {
            return;
        }
        MzMessageReceiver.printLog("pushStatus " + pushSwitchStatus.toString());
    }

    public void onRegisterStatus(Context context, RegisterStatus registerStatus) {
        if (registerStatus == null) {
            return;
        }
        if ("200".equals(registerStatus.getCode())) {
            this.handleMessage(context, 0, registerStatus.getPushId(), 8);
        } else {
            String string2 = "code = " + registerStatus.getCode() + " message = " + registerStatus.getMessage();
            this.handleMessage(context, 2, string2, 8);
            ev.a(8, 104, registerStatus.getCode(), registerStatus.getMessage());
        }
        MzMessageReceiver.printLog("registerStatus " + registerStatus.toString());
    }

    public void onUnRegisterStatus(Context context, UnRegisterStatus unRegisterStatus) {
        if (unRegisterStatus == null) {
            return;
        }
        MzMessageReceiver.printLog("unRegisterStatus " + unRegisterStatus.toString());
    }

    public void onSubTagsStatus(Context context, SubTagsStatus subTagsStatus) {
        if (subTagsStatus == null) {
            return;
        }
        MzMessageReceiver.printLog("subTagsStatus " + subTagsStatus.toString());
    }

    public void onSubAliasStatus(Context context, SubAliasStatus subAliasStatus) {
        if (subAliasStatus == null) {
            return;
        }
        if (TextUtils.equals((CharSequence)"200", (CharSequence)subAliasStatus.code)) {
            ev.b(8);
        } else {
            ev.a(8, 105, subAliasStatus.getCode(), subAliasStatus.getMessage());
        }
        MzMessageReceiver.printLog("subAliasStatus " + subAliasStatus.toString());
    }

    public void onNotificationClicked(Context context, MzPushMessage mzPushMessage) {
        PushDependManager.inst().loggerD("MzPushMessageReceiver", "onNotificationClicked title " + mzPushMessage.getTitle() + "content " + mzPushMessage.getContent() + " selfDefineContentString " + mzPushMessage.getSelfDefineContentString() + " notifyId " + mzPushMessage.getNotifyId());
        String string2 = mzPushMessage.getTitle();
        String string3 = mzPushMessage.getContent();
        String string4 = mzPushMessage.getSelfDefineContentString();
        if (context == null || TextUtils.isEmpty((CharSequence)string4)) {
            return;
        }
        MzMessageReceiver.printLog("onNotificationClicked " + string2 + " " + string3 + " " + string4);
        JSONObject jSONObject = null;
        try {
            char c2 = string4.charAt(0);
            if (c2 != 'a' && c2 != 'c') {
                string4 = 'a' + string4;
            }
            jSONObject = PushDependManager.inst().getMessage(string4.getBytes(), true);
            jSONObject.put("pass_through", 0);
        }
        catch (DataFormatException dataFormatException) {
            dataFormatException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (jSONObject == null) {
            return;
        }
        PushDependManager.inst().onClickNotPassThroughNotification(context, 1, jSONObject.toString(), 8, null);
    }

    public void onNotificationArrived(Context context, MzPushMessage mzPushMessage) {
        PushDependManager.inst().loggerD("MzPushMessageReceiver", "onNotificationArrived title " + mzPushMessage.getTitle() + "content " + mzPushMessage.getContent() + " selfDefineContentString " + mzPushMessage.getSelfDefineContentString() + " notifyId " + mzPushMessage.getNotifyId());
        String string2 = mzPushMessage.getTitle();
        String string3 = mzPushMessage.getContent();
        String string4 = mzPushMessage.getSelfDefineContentString();
        if (context == null || TextUtils.isEmpty((CharSequence)string4)) {
            return;
        }
        MzMessageReceiver.printLog("onNotificationArrived " + string2 + " " + string3 + " " + string4);
        JSONObject jSONObject = null;
        try {
            char c2 = string4.charAt(0);
            if (c2 != 'a' && c2 != 'c') {
                string4 = 'a' + string4;
            }
            if ((jSONObject = PushDependManager.inst().getMessage(string4.getBytes(), true)) == null) {
                return;
            }
            PushDependManager.inst().onNotificationArrived(context, jSONObject);
        }
        catch (DataFormatException dataFormatException) {
            dataFormatException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void onNotificationDeleted(Context context, MzPushMessage mzPushMessage) {
        PushDependManager.inst().loggerD("MzPushMessageReceiver", "onNotificationDeleted title " + mzPushMessage.getTitle() + "content " + mzPushMessage.getContent() + " selfDefineContentString " + mzPushMessage.getSelfDefineContentString() + " notifyId " + mzPushMessage.getNotifyId());
    }

    private void handleMessage(Context context, int n2, String string2, int n3) {
        try {
            Intent intent = new Intent("com.ss.android.mz.message");
            intent.setPackage(context.getPackageName());
            intent.putExtra("message_type", n2);
            intent.putExtra("message_obj", string2);
            intent.putExtra("message_from", n3);
            bk.a(context, intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printLog(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        if (!PushDependManager.inst().loggerDebug()) {
            return;
        }
        PushDependManager.inst().loggerD("MzPush", string2);
    }
}

