/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.hms.agent.push;

import android.os.Handler;
import android.os.Looper;
import com.huawei.android.hms.agent.common.ApiClientMgr;
import com.huawei.android.hms.agent.common.BaseApiAgent;
import com.huawei.android.hms.agent.common.CallbackCodeRunnable;
import com.huawei.android.hms.agent.common.HMSAgentLog;
import com.huawei.android.hms.agent.common.StrUtils;
import com.huawei.android.hms.agent.push.handler.GetTokenHandler;
import com.huawei.hms.api.HuaweiApiClient;
import com.huawei.hms.support.api.client.ApiClient;
import com.huawei.hms.support.api.client.PendingResult;
import com.huawei.hms.support.api.client.ResultCallback;
import com.huawei.hms.support.api.client.Status;
import com.huawei.hms.support.api.push.HuaweiPush;
import com.huawei.hms.support.api.push.TokenResult;

public class GetTokenApi
extends BaseApiAgent {
    private static final int MAX_RETRY_TIMES = 1;
    private GetTokenHandler handler;
    private int retryTimes = 1;

    @Override
    public void onConnect(int n2, HuaweiApiClient huaweiApiClient) {
        if (huaweiApiClient == null || !ApiClientMgr.INST.isConnect(huaweiApiClient)) {
            HMSAgentLog.e("client not connted");
            this.onPushTokenResult(n2, null);
            return;
        }
        PendingResult pendingResult = HuaweiPush.HuaweiPushApi.getToken((ApiClient)huaweiApiClient);
        pendingResult.setResultCallback((ResultCallback)new ResultCallback<TokenResult>(){

            public void onResult(TokenResult tokenResult) {
                if (tokenResult == null) {
                    HMSAgentLog.e("result is null");
                    GetTokenApi.this.onPushTokenResult(-1002, null);
                    return;
                }
                Status status = tokenResult.getStatus();
                if (status == null) {
                    HMSAgentLog.e("status is null");
                    GetTokenApi.this.onPushTokenResult(-1003, null);
                    return;
                }
                int n2 = status.getStatusCode();
                HMSAgentLog.d("status=" + status);
                if ((n2 == 907135006 || n2 == 907135003) && GetTokenApi.this.retryTimes > 0) {
                    GetTokenApi.this.retryTimes--;
                    GetTokenApi.this.connect();
                } else {
                    GetTokenApi.this.onPushTokenResult(n2, tokenResult);
                }
            }
        });
    }

    void onPushTokenResult(int n2, TokenResult tokenResult) {
        HMSAgentLog.i("getToken:callback=" + StrUtils.objDesc(this.handler) + " retCode=" + n2);
        if (this.handler != null) {
            new Handler(Looper.getMainLooper()).post((Runnable)new CallbackCodeRunnable(this.handler, n2));
            this.handler = null;
        }
        this.retryTimes = 1;
    }

    public void getToken(GetTokenHandler getTokenHandler) {
        HMSAgentLog.i("getToken:handler=" + StrUtils.objDesc(getTokenHandler));
        this.handler = getTokenHandler;
        this.retryTimes = 1;
        this.connect();
    }
}

