/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.hms.agent.push;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.huawei.android.hms.agent.common.ApiClientMgr;
import com.huawei.android.hms.agent.common.BaseApiAgent;
import com.huawei.android.hms.agent.common.CallbackCodeRunnable;
import com.huawei.android.hms.agent.common.HMSAgentLog;
import com.huawei.android.hms.agent.common.StrUtils;
import com.huawei.android.hms.agent.common.ThreadUtil;
import com.huawei.android.hms.agent.push.handler.DeleteTokenHandler;
import com.huawei.hms.api.HuaweiApiClient;
import com.huawei.hms.support.api.client.ApiClient;
import com.huawei.hms.support.api.push.HuaweiPush;

public class DeleteTokenApi
extends BaseApiAgent {
    private String token;
    private DeleteTokenHandler handler;

    @Override
    public void onConnect(final int n2, final HuaweiApiClient huaweiApiClient) {
        ThreadUtil.INST.excute(new Runnable(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)DeleteTokenApi.this.token)) {
                    if (huaweiApiClient == null || !ApiClientMgr.INST.isConnect(huaweiApiClient)) {
                        HMSAgentLog.e("client not connted");
                        DeleteTokenApi.this.onDeleteTokenResult(n2);
                    } else {
                        try {
                            HuaweiPush.HuaweiPushApi.deleteToken((ApiClient)huaweiApiClient, DeleteTokenApi.this.token);
                            DeleteTokenApi.this.onDeleteTokenResult(0);
                        }
                        catch (Exception exception) {
                            HMSAgentLog.e("\u5220\u9664TOKEN\u5931\u8d25:" + exception.getMessage());
                            DeleteTokenApi.this.onDeleteTokenResult(-1008);
                        }
                    }
                } else {
                    HMSAgentLog.e("\u5220\u9664TOKEN\u5931\u8d25: \u8981\u5220\u9664\u7684token\u4e3a\u7a7a");
                    DeleteTokenApi.this.onDeleteTokenResult(-1009);
                }
            }
        });
    }

    void onDeleteTokenResult(int n2) {
        HMSAgentLog.i("deleteToken:callback=" + StrUtils.objDesc(this.handler) + " retCode=" + n2);
        if (this.handler != null) {
            new Handler(Looper.getMainLooper()).post((Runnable)new CallbackCodeRunnable(this.handler, n2));
            this.handler = null;
        }
    }

    public void deleteToken(String string2, DeleteTokenHandler deleteTokenHandler) {
        HMSAgentLog.i("deleteToken:token:" + StrUtils.objDesc(string2) + " handler=" + StrUtils.objDesc(deleteTokenHandler));
        this.token = string2;
        this.handler = deleteTokenHandler;
        this.connect();
    }
}

