/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.hms.agent.common;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import com.huawei.android.hms.agent.common.ActivityMgr;
import com.huawei.android.hms.agent.common.BaseApiAgent;
import com.huawei.android.hms.agent.common.CallbackCodeRunnable;
import com.huawei.android.hms.agent.common.HMSAgentLog;
import com.huawei.android.hms.agent.common.StrUtils;
import com.huawei.android.hms.agent.common.handler.CheckUpdateHandler;
import com.huawei.hms.api.CheckUpdatelistener;
import com.huawei.hms.api.HuaweiApiClient;

public class CheckUpdateApi
extends BaseApiAgent
implements CheckUpdatelistener {
    private CheckUpdateHandler handler;
    private Activity activity;

    @Override
    public void onConnect(int n2, HuaweiApiClient huaweiApiClient) {
        HMSAgentLog.d("onConnect:" + n2);
        Activity activity = ActivityMgr.INST.getLastActivity();
        if (activity != null && huaweiApiClient != null) {
            huaweiApiClient.checkUpdate(activity, (CheckUpdatelistener)this);
        } else if (this.activity != null && huaweiApiClient != null) {
            huaweiApiClient.checkUpdate(this.activity, (CheckUpdatelistener)this);
        } else {
            HMSAgentLog.e("no activity to checkUpdate");
            this.onCheckUpdateResult(-1001);
            return;
        }
    }

    public void onResult(int n2) {
        this.onCheckUpdateResult(n2);
    }

    private void onCheckUpdateResult(int n2) {
        HMSAgentLog.i("checkUpdate:callback=" + StrUtils.objDesc(this.handler) + " retCode=" + n2);
        if (this.handler != null) {
            new Handler(Looper.getMainLooper()).post((Runnable)new CallbackCodeRunnable(this.handler, n2));
            this.handler = null;
        }
        this.activity = null;
    }

    public void checkUpdate(Activity activity, CheckUpdateHandler checkUpdateHandler) {
        HMSAgentLog.i("checkUpdate:handler=" + StrUtils.objDesc(checkUpdateHandler));
        this.handler = checkUpdateHandler;
        this.activity = activity;
        this.connect();
    }
}

