/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.hms.agent.common;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.huawei.android.hms.agent.common.HMSAgentLog;
import com.huawei.android.hms.agent.common.IActivityDestroyedCallback;
import com.huawei.android.hms.agent.common.IActivityPauseCallback;
import com.huawei.android.hms.agent.common.IActivityResumeCallback;
import com.huawei.android.hms.agent.common.StrUtils;
import java.util.ArrayList;
import java.util.List;

public final class ActivityMgr
implements Application.ActivityLifecycleCallbacks {
    public static final ActivityMgr INST = new ActivityMgr();
    private static final Object LOCK_LASTACTIVITIES = new Object();
    private Application application;
    private List<Activity> curActivities = new ArrayList<Activity>();
    private List<IActivityResumeCallback> resumeCallbacks = new ArrayList<IActivityResumeCallback>();
    private List<IActivityPauseCallback> pauseCallbacks = new ArrayList<IActivityPauseCallback>();
    private List<IActivityDestroyedCallback> destroyedCallbacks = new ArrayList<IActivityDestroyedCallback>();

    private ActivityMgr() {
    }

    public void init(Application application, Activity activity) {
        HMSAgentLog.d("init");
        if (this.application != null) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
        this.application = application;
        this.setCurActivity(activity);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void release() {
        HMSAgentLog.d("release");
        if (this.application != null) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
        this.clearCurActivities();
        this.clearActivitResumeCallbacks();
        this.clearActivitPauseCallbacks();
        this.application = null;
    }

    public void registerActivitResumeEvent(IActivityResumeCallback iActivityResumeCallback) {
        HMSAgentLog.d("registerOnResume:" + StrUtils.objDesc(iActivityResumeCallback));
        this.resumeCallbacks.add(iActivityResumeCallback);
    }

    public void unRegisterActivitResumeEvent(IActivityResumeCallback iActivityResumeCallback) {
        HMSAgentLog.d("unRegisterOnResume:" + StrUtils.objDesc(iActivityResumeCallback));
        this.resumeCallbacks.remove(iActivityResumeCallback);
    }

    public void registerActivitPauseEvent(IActivityPauseCallback iActivityPauseCallback) {
        HMSAgentLog.d("registerOnPause:" + StrUtils.objDesc(iActivityPauseCallback));
        this.pauseCallbacks.add(iActivityPauseCallback);
    }

    public void unRegisterActivitPauseEvent(IActivityPauseCallback iActivityPauseCallback) {
        HMSAgentLog.d("unRegisterOnPause:" + StrUtils.objDesc(iActivityPauseCallback));
        this.pauseCallbacks.remove(iActivityPauseCallback);
    }

    public void registerActivitDestroyedEvent(IActivityDestroyedCallback iActivityDestroyedCallback) {
        HMSAgentLog.d("registerOnDestroyed:" + StrUtils.objDesc(iActivityDestroyedCallback));
        this.destroyedCallbacks.add(iActivityDestroyedCallback);
    }

    public void unRegisterActivitDestroyedEvent(IActivityDestroyedCallback iActivityDestroyedCallback) {
        HMSAgentLog.d("unRegisterOnDestroyed:" + StrUtils.objDesc(iActivityDestroyedCallback));
        this.destroyedCallbacks.remove(iActivityDestroyedCallback);
    }

    public void clearActivitResumeCallbacks() {
        HMSAgentLog.d("clearOnResumeCallback");
        this.resumeCallbacks.clear();
    }

    public void clearActivitPauseCallbacks() {
        HMSAgentLog.d("clearOnPauseCallback");
        this.pauseCallbacks.clear();
    }

    public Activity getLastActivity() {
        return this.getLastActivityInner();
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        HMSAgentLog.d("onCreated:" + StrUtils.objDesc(activity));
        this.setCurActivity(activity);
    }

    public void onActivityStarted(Activity activity) {
        HMSAgentLog.d("onStarted:" + StrUtils.objDesc(activity));
        this.setCurActivity(activity);
    }

    public void onActivityResumed(Activity activity) {
        HMSAgentLog.d("onResumed:" + StrUtils.objDesc(activity));
        this.setCurActivity(activity);
        ArrayList<IActivityResumeCallback> arrayList = new ArrayList<IActivityResumeCallback>(this.resumeCallbacks);
        for (IActivityResumeCallback iActivityResumeCallback : arrayList) {
            iActivityResumeCallback.onActivityResume(activity);
        }
    }

    public void onActivityPaused(Activity activity) {
        HMSAgentLog.d("onPaused:" + StrUtils.objDesc(activity));
        ArrayList<IActivityPauseCallback> arrayList = new ArrayList<IActivityPauseCallback>(this.pauseCallbacks);
        for (IActivityPauseCallback iActivityPauseCallback : arrayList) {
            iActivityPauseCallback.onActivityPause(activity);
        }
    }

    public void onActivityStopped(Activity activity) {
        HMSAgentLog.d("onStopped:" + StrUtils.objDesc(activity));
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
        HMSAgentLog.d("onDestroyed:" + StrUtils.objDesc(activity));
        this.removeActivity(activity);
        ArrayList<IActivityDestroyedCallback> arrayList = new ArrayList<IActivityDestroyedCallback>(this.destroyedCallbacks);
        for (IActivityDestroyedCallback iActivityDestroyedCallback : arrayList) {
            iActivityDestroyedCallback.onActivityDestroyed(activity, this.getLastActivityInner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActivity(Activity activity) {
        Object object = LOCK_LASTACTIVITIES;
        synchronized (object) {
            this.curActivities.remove(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurActivity(Activity activity) {
        Object object = LOCK_LASTACTIVITIES;
        synchronized (object) {
            int n2 = this.curActivities.indexOf(activity);
            if (n2 == -1) {
                this.curActivities.add(activity);
            } else if (n2 < this.curActivities.size() - 1) {
                this.curActivities.remove(activity);
                this.curActivities.add(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Activity getLastActivityInner() {
        Object object = LOCK_LASTACTIVITIES;
        synchronized (object) {
            if (this.curActivities.size() > 0) {
                return this.curActivities.get(this.curActivities.size() - 1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCurActivities() {
        Object object = LOCK_LASTACTIVITIES;
        synchronized (object) {
            this.curActivities.clear();
        }
    }
}

