/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.util;

import java.security.MessageDigest;

public class StringUtils {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String concatString(String string2, String string3) {
        return new StringBuilder(string2.length() + string3.length()).append(string2).append(string3).toString();
    }

    public static String concatString(String string2, String string3, String string4) {
        return new StringBuilder(string2.length() + string3.length() + string4.length()).append(string2).append(string3).append(string4).toString();
    }

    public static String buildKey(String string2, String string3) {
        return StringUtils.concatString(string2, "://", string3);
    }

    public static String simplifyString(String string2, int n2) {
        if (string2.length() <= n2) {
            return string2;
        }
        return StringUtils.concatString(string2.substring(0, n2), "......");
    }

    public static String stringNull2Empty(String string2) {
        return string2 == null ? "" : string2;
    }

    public static String md5ToHex(String string2) {
        if (string2 == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return StringUtils.bytesToHexString(messageDigest.digest(string2.getBytes("utf-8")));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String bytesToHexString(byte[] byArray, char[] cArray) {
        int n2 = byArray.length;
        char[] cArray2 = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray2[n3++] = cArray[(0xF0 & byArray[i2]) >>> 4];
            cArray2[n3++] = cArray[0xF & byArray[i2]];
        }
        return new String(cArray2);
    }

    public static String bytesToHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return StringUtils.bytesToHexString(byArray, DIGITS_LOWER);
    }

    public static boolean isNotBlank(String string2) {
        return !StringUtils.isBlank(string2);
    }

    public static boolean isBlank(String string2) {
        int n2;
        if (string2 == null || (n2 = string2.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isStringEqual(String string2, String string3) {
        return string2 == null && string3 == null || string2 != null && string2.equals(string3);
    }
}

