/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.status;

import android.content.Context;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Pair;
import anet.channel.status.NetworkStatusHelper$INetworkStatusChangeListener;
import anet.channel.status.NetworkStatusHelper$NetworkStatus;
import anet.channel.status.a;
import anet.channel.status.b;
import anet.channel.thread.ThreadPoolExecutorFactory;
import anet.channel.util.ALog;
import anet.channel.util.g;
import java.net.InetAddress;
import java.util.concurrent.CopyOnWriteArraySet;

public class NetworkStatusHelper {
    private static final String TAG = "awcn.NetworkStatusHelper";
    static CopyOnWriteArraySet listeners = new CopyOnWriteArraySet();

    public static synchronized void startListener(Context context) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        b.a = context;
        b.a();
        b.c();
    }

    public void stopListener(Context context) {
        b.b();
    }

    public static void addStatusChangeListener(NetworkStatusHelper$INetworkStatusChangeListener networkStatusHelper$INetworkStatusChangeListener) {
        listeners.add(networkStatusHelper$INetworkStatusChangeListener);
    }

    public static void removeStatusChangeListener(NetworkStatusHelper$INetworkStatusChangeListener networkStatusHelper$INetworkStatusChangeListener) {
        listeners.remove(networkStatusHelper$INetworkStatusChangeListener);
    }

    static void notifyStatusChanged(NetworkStatusHelper$NetworkStatus networkStatusHelper$NetworkStatus) {
        ThreadPoolExecutorFactory.submitScheduledTask(new a(networkStatusHelper$NetworkStatus));
    }

    public static NetworkStatusHelper$NetworkStatus getStatus() {
        return b.c;
    }

    public static String getNetworkSubType() {
        return b.d;
    }

    public static String getApn() {
        return b.e;
    }

    public static String getCarrier() {
        return b.h;
    }

    public static String getSimOp() {
        return b.i;
    }

    public static boolean isRoaming() {
        return b.k;
    }

    public static String getWifiBSSID() {
        return b.g;
    }

    public static String getWifiSSID() {
        return b.f;
    }

    public static String getDnsServerAddress() {
        if (!b.l.isEmpty()) {
            return ((InetAddress)b.l.get(0)).getHostAddress();
        }
        return b.f();
    }

    public static boolean isConnected() {
        if (Build.VERSION.SDK_INT >= 24 ? b.b : b.c != NetworkStatusHelper$NetworkStatus.NO) {
            return true;
        }
        try {
            NetworkInfo networkInfo = b.e();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isProxy() {
        NetworkStatusHelper$NetworkStatus networkStatusHelper$NetworkStatus = b.c;
        String string2 = b.e;
        return networkStatusHelper$NetworkStatus == NetworkStatusHelper$NetworkStatus.WIFI && NetworkStatusHelper.getWifiProxy() != null || networkStatusHelper$NetworkStatus.isMobile() && (string2.contains("wap") || g.a() != null);
    }

    public static String getProxyType() {
        NetworkStatusHelper$NetworkStatus networkStatusHelper$NetworkStatus = b.c;
        if (networkStatusHelper$NetworkStatus == NetworkStatusHelper$NetworkStatus.WIFI && NetworkStatusHelper.getWifiProxy() != null) {
            return "proxy";
        }
        if (networkStatusHelper$NetworkStatus.isMobile() && b.e.contains("wap")) {
            return "wap";
        }
        if (networkStatusHelper$NetworkStatus.isMobile() && g.a() != null) {
            return "auth";
        }
        return "";
    }

    public static Pair getWifiProxy() {
        if (b.c != NetworkStatusHelper$NetworkStatus.WIFI) {
            return null;
        }
        return b.j;
    }

    public static void printNetworkDetail() {
        try {
            NetworkStatusHelper$NetworkStatus networkStatusHelper$NetworkStatus = NetworkStatusHelper.getStatus();
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("\nNetwork detail*******************************\n");
            stringBuilder.append("Status: ").append(networkStatusHelper$NetworkStatus.getType()).append('\n');
            stringBuilder.append("Subtype: ").append(NetworkStatusHelper.getNetworkSubType()).append('\n');
            if (networkStatusHelper$NetworkStatus != NetworkStatusHelper$NetworkStatus.NO) {
                if (networkStatusHelper$NetworkStatus.isMobile()) {
                    stringBuilder.append("Apn: ").append(NetworkStatusHelper.getApn()).append('\n');
                    stringBuilder.append("Carrier: ").append(NetworkStatusHelper.getCarrier()).append('\n');
                } else {
                    stringBuilder.append("BSSID: ").append(NetworkStatusHelper.getWifiBSSID()).append('\n');
                    stringBuilder.append("SSID: ").append(NetworkStatusHelper.getWifiSSID()).append('\n');
                }
            }
            if (NetworkStatusHelper.isProxy()) {
                stringBuilder.append("Proxy: ").append(NetworkStatusHelper.getProxyType()).append('\n');
                Pair pair = NetworkStatusHelper.getWifiProxy();
                if (pair != null) {
                    stringBuilder.append("ProxyHost: ").append((String)pair.first).append('\n');
                    stringBuilder.append("ProxyPort: ").append(pair.second).append('\n');
                }
            }
            stringBuilder.append("*********************************************");
            ALog.i(TAG, stringBuilder.toString(), null, new Object[0]);
        }
        catch (Exception exception) {}
    }
}

