/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.statist;

import anet.channel.Session;
import anet.channel.statist.SessionStatistic;
import anet.channel.statist.StatObject;
import anet.channel.status.NetworkStatusHelper;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionConnStat
extends StatObject {
    public String netType = NetworkStatusHelper.getNetworkSubType();
    public String ip;
    public int port;
    public int ipRefer = 0;
    public int ipType = 1;
    public String protocolType;
    public String host;
    public int ret;
    public int retryTimes = -1;
    public String errorCode;
    public String errorMsg;
    public double lng = 90000.0;
    public double lat = 90000.0;
    public float accuracy = -1.0f;
    public int roaming;
    public int isProxy = 0;
    public String mnc;
    public String bssid = NetworkStatusHelper.getWifiBSSID();
    public String unit;
    public StringBuilder errorTrace;
    public JSONObject extra;
    public long totalTime = 0L;
    public long authTime = 0L;
    public volatile boolean isCommited = false;
    public volatile long start = 0L;
    public volatile long startConnect = 0L;

    public SessionConnStat() {
        this.roaming = NetworkStatusHelper.isRoaming() ? 1 : 0;
        this.mnc = NetworkStatusHelper.getSimOp();
    }

    public void syncValueFromSession(Session session) {
        SessionStatistic sessionStatistic = session.q;
        this.ip = sessionStatistic.ip;
        this.port = sessionStatistic.port;
        this.ipRefer = sessionStatistic.ipRefer;
        this.ipType = sessionStatistic.ipType;
        this.protocolType = sessionStatistic.conntype;
        this.host = sessionStatistic.host;
        this.isProxy = sessionStatistic.isProxy;
        this.authTime = sessionStatistic.authTime;
        this.unit = session.getUnit();
        if (this.unit == null && this.ipRefer == 1) {
            this.unit = "LocalDNS";
        }
    }

    @Override
    public boolean beforeCommit() {
        if (this.isCommited) {
            return false;
        }
        this.isCommited = true;
        return true;
    }

    public void appendErrorTrace(int n2) {
        if (this.errorTrace == null) {
            this.errorTrace = new StringBuilder();
        }
        if (this.errorTrace.length() > 0) {
            this.errorTrace.append(",");
        }
        this.errorTrace.append(n2).append("=").append(System.currentTimeMillis() - this.startConnect);
    }

    public void putExtra(String string2, Object object) {
        try {
            if (this.extra == null) {
                this.extra = new JSONObject();
            }
            this.extra.put(string2, object);
        }
        catch (JSONException jSONException) {}
    }
}

