/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.statist;

import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.entity.ConnType;
import anet.channel.statist.StatObject;
import anet.channel.status.NetworkStatusHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class RequestStatistic
extends StatObject {
    public volatile String host;
    public volatile String ip;
    public volatile int port;
    public volatile boolean isSSL;
    public volatile int ipRefer = 0;
    public volatile int ipType = 1;
    public volatile boolean isProxy;
    public volatile String proxyType = "";
    public volatile String netType = "";
    public volatile String bssid = null;
    public volatile String protocolType;
    public volatile boolean isDNS = false;
    public volatile int retryTimes;
    public volatile String bizId;
    public volatile String f_refer;
    public volatile int ret;
    public volatile int statusCode = 0;
    public volatile String msg = "";
    public volatile String contentEncoding = null;
    public volatile String contentType = null;
    public volatile int degraded = 0;
    public volatile String isBg = "";
    public volatile StringBuilder errorTrace = null;
    public volatile String url;
    public double lng = 90000.0;
    public double lat = 90000.0;
    public float accuracy = -1.0f;
    public int roaming = 0;
    public String mnc = "0";
    public String unit;
    public JSONObject extra = null;
    public volatile long reqHeadInflateSize = 0L;
    public volatile long reqBodyInflateSize = 0L;
    public volatile long reqHeadDeflateSize = 0L;
    public volatile long reqBodyDeflateSize = 0L;
    public volatile long rspHeadDeflateSize = 0L;
    public volatile long rspBodyDeflateSize = 0L;
    public volatile long rspHeadInflateSize = 0L;
    public volatile long rspBodyInflateSize = 0L;
    public volatile long retryCostTime = 0L;
    public volatile long connWaitTime = 0L;
    public volatile long sendBeforeTime = 0L;
    public volatile long processTime = 0L;
    public volatile long sendDataTime = 0L;
    public volatile long firstDataTime = 0L;
    public volatile long recDataTime = 0L;
    public volatile long serverRT = 0L;
    public volatile long cacheTime = 0L;
    public volatile long lastProcessTime = 0L;
    public volatile long callbackTime = 0L;
    public volatile long oneWayTime = 0L;
    public volatile long sendDataSize = 0L;
    public volatile long recDataSize = 0L;
    public volatile long waitingTime = 0L;
    public final AtomicBoolean isDone = new AtomicBoolean(false);
    public volatile boolean spdyRequestSend = false;
    public volatile long start = 0L;
    public volatile long reqStart = 0L;
    public volatile long sendStart = 0L;
    public volatile long sendEnd = 0L;
    public volatile long rspStart = 0L;
    public volatile long rspEnd = 0L;
    public volatile long contentLength = 0L;
    public volatile int tnetErrorCode = 0;

    public RequestStatistic(String string2, String string3) {
        this.host = string2;
        this.proxyType = NetworkStatusHelper.getProxyType();
        this.isProxy = !this.proxyType.isEmpty();
        this.netType = NetworkStatusHelper.getNetworkSubType();
        this.bssid = NetworkStatusHelper.getWifiBSSID();
        this.isBg = GlobalAppRuntimeInfo.isAppBackground() ? "bg" : "fg";
        this.roaming = NetworkStatusHelper.isRoaming() ? 1 : 0;
        this.mnc = NetworkStatusHelper.getSimOp();
        this.bizId = string3;
    }

    public void setConnType(ConnType connType) {
        this.isSSL = connType.isSSL();
        this.protocolType = connType.toString();
    }

    public void setIPAndPort(String string2, int n2) {
        this.ip = string2;
        this.port = n2;
        if (string2 != null) {
            this.isDNS = true;
        }
        if (this.retryTimes == 0 && string2 != null) {
            this.putExtra("firstIp", string2);
        }
    }

    public void setIpInfo(int n2, int n3) {
        this.ipRefer = n2;
        this.ipType = n3;
    }

    public void appendErrorTrace(String string2) {
        if (this.errorTrace == null) {
            this.errorTrace = new StringBuilder();
        }
        if (this.errorTrace.length() != 0) {
            this.errorTrace.append(",");
        }
        this.errorTrace.append(string2).append("=").append(System.currentTimeMillis() - this.reqStart);
    }

    public void recordRedirect(int n2, String string2) {
        this.url = string2;
        this.appendErrorTrace(String.valueOf(n2));
        long l2 = System.currentTimeMillis();
        this.retryCostTime += l2 - this.start;
        this.start = l2;
    }

    public void putExtra(String string2, Object object) {
        try {
            if (this.extra == null) {
                this.extra = new JSONObject();
            }
            this.extra.put(string2, object);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("[RequestStatistic]ret=").append(this.ret);
        stringBuilder.append(",statusCode=").append(this.statusCode);
        stringBuilder.append(",msg=").append(this.msg);
        stringBuilder.append(",host=").append(this.host);
        stringBuilder.append(",ip=").append(this.ip);
        stringBuilder.append(",port=").append(this.port);
        stringBuilder.append(",protocolType=").append(this.protocolType);
        stringBuilder.append(",retryTime=").append(this.retryTimes);
        stringBuilder.append(",retryCostTime=").append(this.retryCostTime);
        stringBuilder.append(",processTime=").append(this.processTime);
        stringBuilder.append(",connWaitTime=").append(this.connWaitTime);
        stringBuilder.append(",cacheTime=").append(this.cacheTime);
        stringBuilder.append(",sendDataTime=").append(this.sendDataTime);
        stringBuilder.append(",firstDataTime=").append(this.firstDataTime);
        stringBuilder.append(",recDataTime=").append(this.recDataTime);
        stringBuilder.append(",lastProcessTime=").append(this.lastProcessTime);
        stringBuilder.append(",oneWayTime=").append(this.oneWayTime);
        stringBuilder.append(",callbackTime=").append(this.callbackTime);
        stringBuilder.append(",serverRT=").append(this.serverRT);
        stringBuilder.append(",sendSize=").append(this.sendDataSize);
        stringBuilder.append(",recDataSize=").append(this.recDataSize);
        stringBuilder.append(",originalDataSize=").append(this.rspBodyDeflateSize);
        if (this.extra != null) {
            stringBuilder.append(",extra=").append(this.extra.toString());
        }
        stringBuilder.append(",url=").append(this.url);
        return stringBuilder.toString();
    }

    @Override
    public boolean beforeCommit() {
        return this.statusCode != -200;
    }
}

