/*
 * Decompiled with CFR 0.152.
 */
package anet.channel;

import android.content.Context;
import android.text.TextUtils;
import android.util.LruCache;
import anet.channel.AccsSessionManager;
import anet.channel.AwcnConfig;
import anet.channel.Config;
import anet.channel.Config$Builder;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.NoAvailStrategyException;
import anet.channel.Session;
import anet.channel.SessionCenter$a;
import anet.channel.SessionGetCallback;
import anet.channel.SessionInfo;
import anet.channel.SessionRequest;
import anet.channel.b;
import anet.channel.d;
import anet.channel.d.a;
import anet.channel.entity.ConnType;
import anet.channel.entity.ConnType$TypeLevel;
import anet.channel.entity.ENV;
import anet.channel.entity.c;
import anet.channel.security.ISecurity;
import anet.channel.status.NetworkStatusHelper;
import anet.channel.strategy.ConnProtocol;
import anet.channel.strategy.StrategyCenter;
import anet.channel.strategy.l$b;
import anet.channel.strategy.l$d;
import anet.channel.util.ALog;
import anet.channel.util.AppLifecycle;
import anet.channel.util.HttpUrl;
import anet.channel.util.StringUtils;
import anet.channel.util.Utils;
import anet.channel.util.i;
import java.net.ConnectException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.android.spdy.SpdyAgent;
import org.android.spdy.SpdySessionKind;
import org.android.spdy.SpdyVersion;

public class SessionCenter {
    public static final String TAG = "awcn.SessionCenter";
    static Map a = new HashMap();
    private static boolean j = false;
    Context b;
    String c;
    Config d;
    final d e = new d();
    final LruCache f = new LruCache(32);
    final b g = new b();
    final AccsSessionManager h;
    final SessionCenter$a i = new SessionCenter$a(this, null);

    public static synchronized void init(Context context) {
        if (context == null) {
            ALog.e(TAG, "context is null!", null, new Object[0]);
            throw new NullPointerException("init failed. context is null");
        }
        GlobalAppRuntimeInfo.setContext(context.getApplicationContext());
        if (!j) {
            a.put(Config.DEFAULT_CONFIG, new SessionCenter(Config.DEFAULT_CONFIG));
            AppLifecycle.initialize();
            NetworkStatusHelper.startListener(context);
            StrategyCenter.getInstance().initialize(GlobalAppRuntimeInfo.getContext());
            if (GlobalAppRuntimeInfo.isTargetProcess()) {
                anet.channel.d.a.a();
                anet.channel.f.a.a();
            }
            j = true;
        }
    }

    public static synchronized void init(Context context, String string2) {
        SessionCenter.init(context, string2, GlobalAppRuntimeInfo.getEnv());
    }

    public static synchronized void init(Context context, String string2, ENV eNV) {
        if (context == null) {
            ALog.e(TAG, "context is null!", null, new Object[0]);
            throw new NullPointerException("init failed. context is null");
        }
        Config config = Config.getConfig(string2, eNV);
        if (config == null) {
            config = new Config$Builder().setAppkey(string2).setEnv(eNV).build();
        }
        SessionCenter.init(context, config);
    }

    public static synchronized void init(Context context, Config config) {
        if (context == null) {
            ALog.e(TAG, "context is null!", null, new Object[0]);
            throw new NullPointerException("init failed. context is null");
        }
        if (config == null) {
            ALog.e(TAG, "paramter config is null!", null, new Object[0]);
            throw new NullPointerException("init failed. config is null");
        }
        SessionCenter.init(context);
        if (!a.containsKey(config)) {
            SessionCenter sessionCenter = new SessionCenter(config);
            a.put(config, sessionCenter);
        }
    }

    private SessionCenter(Config config) {
        this.b = GlobalAppRuntimeInfo.getContext();
        this.d = config;
        this.c = config.getAppkey();
        this.i.a();
        this.h = new AccsSessionManager(this);
        if (!config.getAppkey().equals("[default]")) {
            ISecurity iSecurity = config.getSecurity();
            String string2 = config.getAppkey();
            anet.channel.strategy.dispatch.a.a(new anet.channel.c(this, string2, iSecurity));
        }
    }

    public synchronized void switchEnv(ENV eNV) {
        SessionCenter.switchEnvironment(eNV);
    }

    public static synchronized void switchEnvironment(ENV eNV) {
        try {
            Object object;
            if (GlobalAppRuntimeInfo.getEnv() != eNV) {
                ALog.i(TAG, "switch env", null, new Object[]{"old", GlobalAppRuntimeInfo.getEnv(), "new", eNV});
                GlobalAppRuntimeInfo.setEnv(eNV);
                StrategyCenter.getInstance().switchEnv();
                object = SpdyAgent.getInstance(GlobalAppRuntimeInfo.getContext(), SpdyVersion.SPDY3, SpdySessionKind.NONE_SESSION);
                ((SpdyAgent)object).switchAccsServer(eNV == ENV.TEST ? 0 : 1);
            }
            object = a.entrySet().iterator();
            while (object.hasNext()) {
                SessionCenter sessionCenter = (SessionCenter)object.next().getValue();
                if (sessionCenter.d.getEnv() == eNV) continue;
                ALog.i(TAG, "remove instance", sessionCenter.c, new Object[]{"ENVIRONMENT", sessionCenter.d.getEnv()});
                sessionCenter.h.forceCloseSession(false);
                sessionCenter.i.b();
                object.remove();
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "switch env error.", null, throwable, new Object[0]);
        }
    }

    public static synchronized SessionCenter getInstance(String string2) {
        Config config = Config.getConfigByTag(string2);
        if (config == null) {
            throw new RuntimeException("tag not exist!");
        }
        return SessionCenter.getInstance(config);
    }

    public static synchronized SessionCenter getInstance(Config config) {
        Object object;
        if (config == null) {
            throw new NullPointerException("config is null!");
        }
        if (!j && (object = Utils.getAppContext()) != null) {
            SessionCenter.init(object);
        }
        if ((object = (SessionCenter)a.get(config)) == null) {
            object = new SessionCenter(config);
            a.put(config, object);
        }
        return object;
    }

    public static synchronized SessionCenter getInstance() {
        Object object;
        if (!j && (object = Utils.getAppContext()) != null) {
            SessionCenter.init(object);
        }
        object = null;
        for (Map.Entry entry : a.entrySet()) {
            object = (SessionCenter)entry.getValue();
            if (entry.getKey() == Config.DEFAULT_CONFIG) continue;
            return object;
        }
        return object;
    }

    public Session getThrowsException(String string2, long l2) {
        return this.a(HttpUrl.parse(string2), anet.channel.entity.c.c, l2, null);
    }

    public Session getThrowsException(String string2, ConnType$TypeLevel connType$TypeLevel, long l2) {
        return this.a(HttpUrl.parse(string2), connType$TypeLevel == ConnType$TypeLevel.SPDY ? anet.channel.entity.c.a : anet.channel.entity.c.b, l2, null);
    }

    public Session getThrowsException(HttpUrl httpUrl, int n2, long l2) {
        return this.a(httpUrl, n2, l2, null);
    }

    public Session getThrowsException(HttpUrl httpUrl, ConnType$TypeLevel connType$TypeLevel, long l2) {
        return this.a(httpUrl, connType$TypeLevel == ConnType$TypeLevel.SPDY ? anet.channel.entity.c.a : anet.channel.entity.c.b, l2, null);
    }

    public Session get(String string2, long l2) {
        return this.get(HttpUrl.parse(string2), anet.channel.entity.c.c, l2);
    }

    public Session get(String string2, ConnType$TypeLevel connType$TypeLevel, long l2) {
        return this.get(HttpUrl.parse(string2), connType$TypeLevel == ConnType$TypeLevel.SPDY ? anet.channel.entity.c.a : anet.channel.entity.c.b, l2);
    }

    public Session get(HttpUrl httpUrl, ConnType$TypeLevel connType$TypeLevel, long l2) {
        return this.get(httpUrl, connType$TypeLevel == ConnType$TypeLevel.SPDY ? anet.channel.entity.c.a : anet.channel.entity.c.b, l2);
    }

    public Session get(HttpUrl httpUrl, int n2, long l2) {
        Session session = null;
        try {
            session = this.a(httpUrl, n2, l2, null);
        }
        catch (InvalidParameterException invalidParameterException) {
            ALog.e(TAG, "[Get]param url is invalid", this.c, invalidParameterException, "url", httpUrl);
        }
        catch (TimeoutException timeoutException) {
            ALog.e(TAG, "[Get]timeout exception", this.c, timeoutException, "url", httpUrl.urlString());
        }
        catch (ConnectException connectException) {
            ALog.e(TAG, "[Get]connect exception", this.c, "errMsg", connectException.getMessage(), "url", httpUrl.urlString());
        }
        catch (NoAvailStrategyException noAvailStrategyException) {
            ALog.i(TAG, "[Get]" + noAvailStrategyException.getMessage(), this.c, null, "url", httpUrl.urlString());
        }
        catch (Exception exception) {
            ALog.e(TAG, "[Get]" + exception.getMessage(), this.c, null, "url", httpUrl.urlString());
        }
        return session;
    }

    public void asyncGet(HttpUrl httpUrl, int n2, long l2, SessionGetCallback sessionGetCallback) {
        if (sessionGetCallback == null) {
            throw new NullPointerException("cb is null");
        }
        if (l2 <= 0L) {
            throw new InvalidParameterException("timeout must > 0");
        }
        try {
            Session session = this.a(httpUrl, n2, l2, sessionGetCallback);
            if (session != null) {
                sessionGetCallback.onSessionGetSuccess(session);
            }
        }
        catch (Exception exception) {
            sessionGetCallback.onSessionGetFail();
        }
    }

    public void registerSessionInfo(SessionInfo sessionInfo) {
        this.g.a(sessionInfo);
        if (sessionInfo.isKeepAlive) {
            this.h.checkAndStartSession();
        }
    }

    public void unregisterSessionInfo(String string2) {
        SessionInfo sessionInfo = this.g.a(string2);
        if (sessionInfo != null && sessionInfo.isKeepAlive) {
            this.h.checkAndStartSession();
        }
    }

    public void registerPublicKey(String string2, int n2) {
        this.g.a(string2, n2);
    }

    public static void checkAndStartAccsSession() {
        for (SessionCenter sessionCenter : a.values()) {
            sessionCenter.h.checkAndStartSession();
        }
    }

    public void forceRecreateAccsSession() {
        this.h.forceCloseSession(true);
    }

    private SessionRequest a(HttpUrl httpUrl) {
        String string2 = StrategyCenter.getInstance().getCNameByHost(httpUrl.host());
        String string3 = string2 == null ? httpUrl.host() : string2;
        String string4 = httpUrl.scheme();
        if (!httpUrl.isSchemeLocked()) {
            string4 = StrategyCenter.getInstance().getSchemeByHost(string3, string4);
        }
        String string5 = StringUtils.concatString(string4, "://", string3);
        return this.a(string5);
    }

    protected Session a(HttpUrl httpUrl, int n2, long l2, SessionGetCallback sessionGetCallback) {
        if (!j) {
            ALog.e(TAG, "getInternal not inited!", this.c, new Object[0]);
            throw new IllegalStateException("getInternal not inited");
        }
        if (httpUrl == null) {
            throw new InvalidParameterException("httpUrl is null");
        }
        ALog.d(TAG, "getInternal", this.c, "u", httpUrl.urlString(), "sessionType", n2 == anet.channel.entity.c.a ? "LongLink" : "ShortLink", "timeout", l2);
        SessionRequest sessionRequest = this.a(httpUrl);
        Session session = this.e.a(sessionRequest, n2);
        if (session != null) {
            ALog.d(TAG, "get internal hit cache session", this.c, "session", session);
        } else {
            SessionInfo sessionInfo;
            if (this.d == Config.DEFAULT_CONFIG && n2 != anet.channel.entity.c.b) {
                if (sessionGetCallback != null) {
                    sessionGetCallback.onSessionGetFail();
                }
                return null;
            }
            if (GlobalAppRuntimeInfo.isAppBackground() && n2 == anet.channel.entity.c.a && AwcnConfig.isAccsSessionCreateForbiddenInBg() && (sessionInfo = this.g.b(httpUrl.host())) != null && sessionInfo.isAccs) {
                ALog.w(TAG, "app background, forbid to create accs session", this.c, new Object[0]);
                throw new ConnectException("accs session connecting forbidden in background");
            }
            sessionRequest.a(this.b, n2, anet.channel.util.i.a(this.c), sessionGetCallback, l2);
            if (sessionGetCallback == null && l2 > 0L && (n2 == anet.channel.entity.c.c || sessionRequest.b() == n2)) {
                sessionRequest.a(l2);
                session = this.e.a(sessionRequest, n2);
                if (session == null) {
                    throw new ConnectException("session connecting failed or timeout");
                }
            }
        }
        return session;
    }

    public void enterBackground() {
        AppLifecycle.onBackground();
    }

    public void enterForeground() {
        AppLifecycle.onForeground();
    }

    private void a(l$d l$d) {
        try {
            l$b[] l$bArray = l$d.b;
            for (int i2 = 0; i2 < l$bArray.length; ++i2) {
                l$b l$b = l$bArray[i2];
                if (l$b.k) {
                    this.b(l$b);
                }
                if (l$b.e == null) continue;
                this.a(l$b);
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "checkStrategy failed", this.c, exception, new Object[0]);
        }
    }

    private void a(l$b l$b) {
        List list = this.e.a(this.a(StringUtils.buildKey(l$b.c, l$b.a)));
        for (Session session : list) {
            if (StringUtils.isStringEqual(session.l, l$b.e)) continue;
            ALog.i(TAG, "unit change", session.p, "session unit", session.l, "unit", l$b.e);
            session.close(true);
        }
    }

    private void b(l$b l$b) {
        ALog.i(TAG, "find effectNow", this.c, "host", l$b.a);
        Object[] objectArray = l$b.h;
        Object[] objectArray2 = l$b.f;
        List list = this.e.a(this.a(StringUtils.buildKey(l$b.c, l$b.a)));
        for (Session session : list) {
            int n2;
            if (session.getConnType().isHttpType()) continue;
            boolean bl2 = false;
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                if (!session.getIp().equals(objectArray2[n2])) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                if (ALog.isPrintLog(2)) {
                    ALog.i(TAG, "ip not match", session.p, "session ip", session.getIp(), "ips", Arrays.toString(objectArray2));
                }
                session.close(true);
                continue;
            }
            n2 = 0;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (session.getPort() != objectArray[i2].a || !session.getConnType().equals(ConnType.valueOf(ConnProtocol.valueOf(objectArray[i2])))) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) continue;
            if (ALog.isPrintLog(2)) {
                ALog.i(TAG, "aisle not match", session.p, "port", session.getPort(), "connType", session.getConnType(), "aisle", Arrays.toString(objectArray));
            }
            session.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionRequest a(String string2) {
        SessionRequest sessionRequest;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        LruCache lruCache = this.f;
        synchronized (lruCache) {
            sessionRequest = (SessionRequest)this.f.get((Object)string2);
            if (sessionRequest == null) {
                sessionRequest = new SessionRequest(string2, this);
                this.f.put((Object)string2, (Object)sessionRequest);
            }
        }
        return sessionRequest;
    }

    static /* synthetic */ void a(SessionCenter sessionCenter, l$d l$d) {
        sessionCenter.a(l$d);
    }

    static /* synthetic */ boolean a() {
        return j;
    }
}

