/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bdlocation.service;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.bytedance.bdlocation.BDLocation;
import com.bytedance.bdlocation.BaseLocate;
import com.bytedance.bdlocation.LocationUtil;
import com.bytedance.bdlocation.Util;
import com.bytedance.bdlocation.client.BDLocationClient;
import com.bytedance.bdlocation.client.BDLocationConfig;
import com.bytedance.bdlocation.client.BDLocationException;
import com.bytedance.bdlocation.client.BDPoint;
import com.bytedance.bdlocation.client.LocationOption;
import com.bytedance.bdlocation.service.QPSController;
import g.optional.location.aq;
import g.optional.location.ay;
import g.optional.location.cg;
import g.optional.location.cj;
import g.optional.location.ck;
import g.optional.location.v;
import java.util.List;
import java.util.Locale;

@Keep
public class SystemBaseLocationImpl
extends BaseLocate {
    public static final String LOCATION_NAME = "Android";
    public static final String SYS_GEOCODE_NAME = "Android";
    public static final String LBS_GEOCODE_NAME = "LBS";
    private LocationManager mManager;
    private BDLocationClient.Callback mCallback;
    private LocationOption mOption;
    private BDLocation mLastLocation;
    private boolean mGpsDisabled;
    private boolean mNetworkDisabled;
    private LocationListener mNetWorkListener = new LocationListener(){

        public void onLocationChanged(Location location) {
            try {
                if (!ay.a().b()) {
                    SystemBaseLocationImpl.this.stopLocation();
                }
                SystemBaseLocationImpl.this.mLastLocation = SystemBaseLocationImpl.this.transform(location, 4);
                SystemBaseLocationImpl.this.geocodeAndCallback(SystemBaseLocationImpl.this.mLastLocation, SystemBaseLocationImpl.this.mOption, SystemBaseLocationImpl.this.mCallback);
            }
            catch (Exception exception) {
                cj.a("SysLocation:network listener error", exception);
            }
        }

        public void onStatusChanged(String string, int n2, Bundle bundle) {
        }

        public void onProviderEnabled(String string) {
            SystemBaseLocationImpl.this.mNetworkDisabled = false;
        }

        public void onProviderDisabled(String string) {
            cj.b("SysLocation:onProviderDisabled:" + string);
            SystemBaseLocationImpl.this.mNetworkDisabled = true;
            SystemBaseLocationImpl.this.checkAndCallback();
        }
    };
    private LocationListener mGPSListener = new LocationListener(){

        public void onLocationChanged(Location location) {
            try {
                if (!ay.a().b()) {
                    SystemBaseLocationImpl.this.stopLocation();
                }
                SystemBaseLocationImpl.this.mLastLocation = SystemBaseLocationImpl.this.transform(location, 1);
                SystemBaseLocationImpl.this.geocodeAndCallback(SystemBaseLocationImpl.this.mLastLocation, SystemBaseLocationImpl.this.mOption, SystemBaseLocationImpl.this.mCallback);
            }
            catch (Exception exception) {
                cj.a("SysLocation:GPS listener error", exception);
            }
        }

        public void onStatusChanged(String string, int n2, Bundle bundle) {
        }

        public void onProviderEnabled(String string) {
            SystemBaseLocationImpl.this.mNetworkDisabled = false;
        }

        public void onProviderDisabled(String string) {
            cj.b("SysLocation:onProviderDisabled:" + string);
            SystemBaseLocationImpl.this.mGpsDisabled = true;
            SystemBaseLocationImpl.this.checkAndCallback();
        }
    };

    @Keep
    public SystemBaseLocationImpl(Context context, QPSController qPSController) {
        super(context, qPSController);
        this.mManager = (LocationManager)context.getSystemService("location");
    }

    @VisibleForTesting
    @Keep
    public SystemBaseLocationImpl(Context context, @Nullable LocationManager locationManager) {
        super(context, null);
        this.mContext = context;
        this.mManager = locationManager == null ? (LocationManager)context.getSystemService("location") : locationManager;
    }

    @Override
    public String getLocateName() {
        return "Android";
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void startLocation(@NonNull BDLocationClient.Callback callback, @NonNull LocationOption locationOption, @NonNull Looper looper) {
        if (!Util.isLocationEnabled()) {
            BDLocationException bDLocationException = new BDLocationException("\u5b9a\u4f4d\u670d\u52a1\u6ca1\u6709\u5f00\u542f\uff0c\u8bf7\u5728\u8bbe\u7f6e\u4e2d\u6253\u5f00\u5b9a\u4f4d\u670d\u52a1\u5f00\u5173", "Android", "7");
            callback.onError(bDLocationException);
            return;
        }
        if (BDLocationConfig.getAppBackgroundProvider().b()) {
            return;
        }
        this.mCallback = callback;
        this.mOption = locationOption;
        boolean bl2 = locationOption.getInterval() == 0L;
        try {
            long l2;
            if (bl2) {
                Location location = cg.a(this.mManager, "gps");
                Location location2 = cg.a(this.mManager, "network");
                if (location2 != null && LocationUtil.checkCacheTime(location2.getTime(), locationOption.getMaxCacheTime()) && !LocationUtil.isEmpty(location2)) {
                    this.geocodeAndCallback(this.transform(location2, 4, true), locationOption, this.mCallback);
                    return;
                }
                if (location != null && LocationUtil.checkCacheTime(location.getTime(), locationOption.getMaxCacheTime()) && !LocationUtil.isEmpty(location)) {
                    this.geocodeAndCallback(this.transform(location, 1, true), locationOption, this.mCallback);
                    return;
                }
            }
            long l3 = l2 = locationOption.getInterval() > 0L ? locationOption.getInterval() : 300L;
            if (ck.a("android.permission.ACCESS_FINE_LOCATION")) {
                if (locationOption.getMode() == 0) {
                    this.mManager.requestLocationUpdates("network", l2, 0.0f, this.mNetWorkListener, looper);
                } else if (locationOption.getMode() == 1) {
                    this.mManager.requestLocationUpdates("gps", l2, 0.0f, this.mGPSListener, looper);
                } else {
                    this.mManager.requestLocationUpdates("network", l2, 0.0f, this.mNetWorkListener, looper);
                    this.mManager.requestLocationUpdates("gps", l2, 0.0f, this.mGPSListener, looper);
                }
            }
            this.onLocateStart("Android");
            cj.c("SysLocation:Android startLocation");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void stopLocation() {
        try {
            this.mManager.removeUpdates(this.mNetWorkListener);
            this.mManager.removeUpdates(this.mGPSListener);
            cj.c("SysLocation:Android stopLocation");
        }
        catch (Exception exception) {
            cj.a("SysLocation:android stop location error", exception);
        }
    }

    @Override
    @Nullable
    public List<aq> getPoiSync(@NonNull BDPoint bDPoint, String string) {
        return null;
    }

    @Override
    @Nullable
    public List<v> getAoiSync(@NonNull BDPoint bDPoint, String string) {
        return null;
    }

    @Override
    @Nullable
    public BDPoint convertGCJ02(@NonNull BDPoint bDPoint) {
        return null;
    }

    @Override
    @Nullable
    public BDLocation geocode(@NonNull BDPoint bDPoint, String string) {
        if ("wgs".equals(string)) {
            BDLocation bDLocation = new BDLocation(bDPoint.getProvider(), "Android");
            bDLocation.setLatitude(bDPoint.getLatitude());
            bDLocation.setLongitude(bDPoint.getLongitude());
            BDLocation bDLocation2 = null;
            try {
                bDLocation2 = LocationUtil.geocode(this.mContext, bDLocation);
            }
            catch (Exception exception) {
                cj.a("SysLocation:geocode error", exception);
            }
            return bDLocation2;
        }
        return null;
    }

    @Override
    public void setLocale(Locale locale) {
    }

    private BDLocation transform(Location location, int n2) {
        return this.transform(location, n2, false);
    }

    private BDLocation transform(Location location, int n2, boolean bl2) {
        if (location != null) {
            BDLocation bDLocation = new BDLocation(location, "Android");
            bDLocation.setLocationType(n2);
            bDLocation.setCache(bl2);
            return bDLocation;
        }
        return null;
    }

    @VisibleForTesting
    public void setLocation(BDLocation bDLocation) {
        this.mLastLocation = bDLocation;
    }

    private boolean checkProviderDisabled(int n2) {
        if (n2 == 2) {
            return this.mGpsDisabled && this.mNetworkDisabled;
        }
        if (n2 == 0) {
            return this.mNetworkDisabled;
        }
        return this.mGpsDisabled;
    }

    private void checkAndCallback() {
        if (this.checkProviderDisabled(this.mOption.getMode())) {
            this.geocodeAndCallback(null, this.mOption, this.mCallback);
        }
    }

    @Override
    public boolean needGeocode(BDLocation bDLocation, LocationOption locationOption) {
        return true;
    }
}

