/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bdlocation.client;

import android.app.Activity;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import com.bytedance.bdlocation.BDLocation;
import com.bytedance.bdlocation.Util;
import com.bytedance.bdlocation.client.BDLocationException;
import com.bytedance.bdlocation.client.BDPoint;
import com.bytedance.bdlocation.client.LocationOption;
import com.bytedance.bdlocation.service.SystemBaseLocationImpl;
import g.optional.location.ab;
import g.optional.location.ad;
import g.optional.location.aq;
import g.optional.location.ay;
import g.optional.location.be;
import g.optional.location.bv;
import g.optional.location.cj;
import g.optional.location.t;
import g.optional.location.v;
import g.optional.location.y;
import g.optional.location.z;
import java.util.List;

public class BDLocationClient {
    private LocationOption mOption;
    private boolean isStart;
    private int mId;
    private String mTag;
    private ILocationClient mClient = new ILocationClient(){

        @Override
        public void onStartLocation(@Nullable int n2) {
            BDLocationClient.this.mId = n2;
        }

        @Override
        public void onStopLocation() {
            BDLocationClient.this.isStart = false;
        }
    };

    public BDLocationClient(@NonNull String string) {
        this.mTag = string;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public void startLocation(@Nullable Callback callback) {
        BDLocationClient bDLocationClient = this;
        synchronized (bDLocationClient) {
            if (!this.isStart) {
                this.isStart = true;
                if (this.mOption.getInterval() < 1000L) {
                    this.mOption.setInterval(1000L);
                }
                ay.a().a(callback, new LocationOption(this.mOption), this.mClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public void stopLocation() {
        BDLocationClient bDLocationClient = this;
        synchronized (bDLocationClient) {
            ay.a().a(this.mId);
            this.isStart = false;
        }
    }

    @Nullable
    @WorkerThread
    public BDLocation getLocation() throws BDLocationException {
        if (this.mOption.getInterval() != 0L) {
            this.mOption.setInterval(0L);
        }
        return ay.a().a(new LocationOption(this.mOption));
    }

    public void getLocation(@NonNull Callback callback) {
        if (this.mOption.getInterval() != 0L) {
            this.mOption.setInterval(0L);
        }
        ay.a().a(callback, new LocationOption(this.mOption));
    }

    @WorkerThread
    public BDLocation getIPLocation() {
        BDLocation bDLocation = null;
        try {
            bDLocation = SystemBaseLocationImpl.getGeocodeResult(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bDLocation;
    }

    @Nullable
    @WorkerThread
    public z getBdLBSResult(boolean bl2) {
        z z2 = null;
        if (bl2) {
            z2 = ay.a().d().b();
        }
        if (z2 == null) {
            try {
                z2 = SystemBaseLocationImpl.getLocateResult();
            }
            catch (BDLocationException bDLocationException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return z2;
    }

    @Nullable
    @WorkerThread
    public y getBdGisResult(double d2, double d3) {
        y y2 = null;
        try {
            y2 = SystemBaseLocationImpl.getGisResult(d2, d3);
        }
        catch (BDLocationException bDLocationException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return y2;
    }

    @Nullable
    @WorkerThread
    public ad getCountry() {
        try {
            return t.b();
        }
        catch (Exception exception) {
            cj.a("", exception);
            return null;
        }
    }

    @WorkerThread
    public boolean setUserSelectedLocation(ab ab2) {
        try {
            return t.a(ab2);
        }
        catch (Exception exception) {
            cj.a("", exception);
            return false;
        }
    }

    @Nullable
    @WorkerThread
    public List<aq> getPoi(@NonNull BDPoint bDPoint, String string) {
        return ay.a().a(bDPoint, string);
    }

    @Nullable
    @WorkerThread
    public List<v> getAoi(@NonNull BDPoint bDPoint, String string) {
        return ay.a().b(bDPoint, string);
    }

    @WorkerThread
    @Nullable
    public BDPoint convertGCJ02(@NonNull BDPoint bDPoint) {
        return ay.a().a(bDPoint);
    }

    @WorkerThread
    @Nullable
    public BDLocation geocode(@NonNull BDPoint bDPoint, String string) {
        return ay.a().c(bDPoint, string);
    }

    public BDLocationClient setLocationInterval(long l2) {
        this.mOption.interval = l2;
        return this;
    }

    public void requestLocationPermission(Activity activity) {
        Util.requestLocationPermission(activity);
    }

    public void onRequestPermissionsResult(int n2, String[] stringArray, int[] nArray) {
        Util.onRequestPermissionsResult(n2, stringArray, nArray);
    }

    public BDLocationClient setMaxCacheTime(long l2) {
        this.mOption.maxCacheTime = l2;
        return this;
    }

    public BDLocationClient setMaxCacheTimeForLocateFail(long l2) {
        this.mOption.maxCacheTimeForLocateFail = l2;
        return this;
    }

    public BDLocationClient setLocationTimeOut(long l2) {
        this.mOption.locationTimeOutMs = l2;
        return this;
    }

    public BDLocationClient setLocationMode(int n2) {
        this.mOption.mode = n2;
        return this;
    }

    public int getLocationMode() {
        return this.mOption.mode;
    }

    public BDLocationClient setGeocodeMode(int n2) {
        this.mOption.geocodeMode = n2;
        return this;
    }

    public int getLocateAccuracy() {
        return this.mOption.locateAccuracy;
    }

    public BDLocationClient setLocateAccuracy(int n2) {
        this.mOption.locateAccuracy = n2;
        return this;
    }

    public BDLocationClient setTraceCallback(bv bv2) {
        this.mOption.setTraceCallback(bv2);
        return this;
    }

    public BDLocationClient reset() {
        this.mOption = new LocationOption(this.mTag);
        this.mOption.setMaxCacheTime(600000L);
        this.mOption.setLocationTimeOutMs(30000L);
        return this;
    }

    @VisibleForTesting(otherwise=2)
    public boolean getIsStart() {
        return this.isStart;
    }

    @VisibleForTesting(otherwise=2)
    public Long getInterval() {
        return this.mOption.getInterval();
    }

    @VisibleForTesting(otherwise=2)
    public int getId() {
        return this.mId;
    }

    @VisibleForTesting(otherwise=2)
    public LocationOption getOption() {
        return this.mOption;
    }

    public BDLocation getLastKnowLocation() {
        BDLocation bDLocation = null;
        try {
            be be2 = ay.a().d();
            bDLocation = be2.a().c;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bDLocation;
    }

    public static interface LocationNotification {
        public void onLocationChanged(BDLocation var1, BDLocation var2);
    }

    public static interface ILocationClient {
        public void onStartLocation(@Nullable int var1);

        public void onStopLocation();
    }

    public static interface Callback {
        public void onLocationChanged(@Nullable BDLocation var1);

        public void onError(@Nullable BDLocationException var1);
    }
}

