/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.module.location.impl;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.location.LocationManager;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bytedance.bdlocation.BDLocation;
import com.bytedance.bdlocation.client.BDLocationClient;
import com.bytedance.bdlocation.client.BDLocationConfig;
import com.bytedance.bdlocation.client.BDLocationException;
import com.bytedance.retrofit2.Call;
import com.bytedance.ttgame.framework.module.network.AppExecutors;
import com.bytedance.ttgame.framework.module.network.IRetrofit;
import com.bytedance.ttgame.framework.module.network.IRetrofitService;
import com.bytedance.ttgame.framework.module.spi.ServiceManager;
import com.bytedance.ttgame.module.location.api.ILocationService;
import com.bytedance.ttgame.module.location.api.callback.LbsCallback;
import com.bytedance.ttgame.module.location.api.model.lbs.ErrorCode;
import com.bytedance.ttgame.module.location.api.model.lbs.ErrorRep;
import com.bytedance.ttgame.module.location.api.model.lbs.LocationDataResult;
import com.bytedance.ttgame.module.location.api.model.lbs.NearPoiDataResult;
import com.bytedance.ttgame.module.location.api.model.lbs.NoDataResult;
import com.bytedance.ttgame.module.location.api.model.lbs.PoiFilter;
import com.bytedance.ttgame.module.location.api.model.lbs.Response;
import com.bytedance.ttgame.module.location.impl.DelDataRequest;
import com.bytedance.ttgame.module.location.impl.GetNearRequest;
import com.bytedance.ttgame.module.location.impl.LatLng;
import com.bytedance.ttgame.module.location.impl.Point;
import com.bytedance.ttgame.module.location.impl.ReportDataRequest;
import com.bytedance.ttgame.module.location.impl.Request;
import com.bytedance.ttgame.module.location.impl.permission.LocationPermissionUtil;
import com.bytedance.ttgame.sdk.module.core.internal.ChannelConstants;
import com.bytedance.ttgame.sdk.module.core.internal.GameSdkConfig;
import com.bytedance.ttgame.sdk.module.core.internal.SdkCoreData;
import com.bytedance.ttgame.sdk.module.location.model.Location;
import g.main.ams;
import g.main.anl;
import g.main.avq;
import g.main.axw;
import g.optional.location.cq;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.json.JSONException;
import org.json.JSONObject;
import timber.log.Timber;

public class LocationService
implements ILocationService {
    public static String TAG = "LocationService";
    public static final String SETTINGS_ID = "locationsdk";
    public static final String REPORT_AT_START = "report_at_start";
    public static final String REPORT_POI_MAX = "report_poi_max";
    public static final String REPORT_INTERVAL_SECONDS = "report_interval_seconds";
    public static final String REPORT_DEVICE_INFO = "report_device_info";
    public static final String REPORT_BSS_MAX = "report_bss_max";
    public static final String REPORT_WIFI_MAX = "report_wifi_max";
    public static final String REPORT_GPS = "report_gps";
    public static final String REPORT_DEVICE_INFO_AT_START = "report_device_info_at_start";
    public static final String KEY = "locationsdk";
    IRetrofit retrofit = ((IRetrofitService)ServiceManager.get().getService(IRetrofitService.class)).createNewRetrofit(ChannelConstants.GSDK_SERVER_URL);
    private static final int LOCATION_TIMEOUT = 30000;

    @Override
    public void initLocationSDK(Application application) {
        Timber.tag((String)"locationtest").w("locationinit", new Object[]{"app:" + application});
        BDLocationConfig.setChineseChannel(false);
        BDLocationConfig.setIsUploadGPS(false);
        BDLocationConfig.setBaseUrl(ChannelConstants.GSDK_SERVER_URL);
        this.requestLocationSetting();
        BDLocationConfig.init(application);
    }

    @Override
    public void requestAndUpdateCurrentLocation(Activity activity, LbsCallback<LocationDataResult> lbsCallback) {
        String[] stringArray = this.getLocationPermissions();
        LocationPermissionUtil.a.a(activity, stringArray, (Function2<? super Boolean, ? super String, Unit>)((Function2)(bl2, string) -> {
            if (bl2.booleanValue()) {
                this.getLocationPoint(lbsCallback);
            } else {
                lbsCallback.onFailed(new ErrorRep(ErrorCode.PERMISSION_DENY_ERROR.ordinal(), "please enable gps-related permissions, includes READ_EXTERNAL_STORAGE and ACCESS_FINE_LOCATION"));
            }
            return null;
        }));
    }

    private String[] getLocationPermissions() {
        String[] stringArray = Build.VERSION.SDK_INT >= 28 ? new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION", "android.permission.READ_EXTERNAL_STORAGE"} : new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.READ_EXTERNAL_STORAGE"};
        return stringArray;
    }

    @Override
    public Location getLocationByIp(Context context) {
        return axw.cx((Context)context);
    }

    @Override
    public Location getLocationInfo(Context context) {
        return axw.cz((Context)context);
    }

    @Override
    public void reportPoiData(Activity activity, final String string, final String string2, final Map<String, String> map, final LbsCallback<NoDataResult> lbsCallback) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            lbsCallback.onFailed(new ErrorRep(ErrorCode.PARAM_INVALID_ERROR.ordinal(), "dataSet or primaryKey should not be empty"));
            return;
        }
        if (this.checkGPSPermission(activity)) {
            lbsCallback.onFailed(new ErrorRep(ErrorCode.PERMISSION_DENY_ERROR.ordinal(), "please enable gps-related permissions, includes READ_EXTERNAL_STORAGE and ACCESS_FINE_LOCATION"));
            return;
        }
        if (this.checkGPSOpen(activity)) {
            lbsCallback.onFailed(new ErrorRep(ErrorCode.GPS_NOT_OPEN_ERROR.ordinal(), "please open gps"));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)GameSdkConfig.getUniqueId())) {
            lbsCallback.onFailed(new ErrorRep(ErrorCode.NOT_LOGIN_ERROR.ordinal(), "please login"));
            return;
        }
        this.getLocationPoint(new cq(){

            @Override
            public void a(BDLocation bDLocation) {
                ArrayList<Point> arrayList = new ArrayList<Point>();
                arrayList.add(new Point(string2, map, new LatLng(bDLocation.getLongitude(), bDLocation.getLatitude())));
                ReportDataRequest reportDataRequest = new ReportDataRequest(string, SdkCoreData.getInstance().getConfig().appId, GameSdkConfig.getAccessToken(), arrayList);
                ((Request)LocationService.this.retrofit.create(Request.class)).reportPOIData(reportDataRequest).enqueue((ams)new ams<Response<Object>>(){

                    public void a(Call<Response<Object>> call, anl<Response<Object>> anl2) {
                        if (anl2 != null && anl2.isSuccessful()) {
                            if (((Response)anl2.CD()).code == 0) {
                                lbsCallback.onSuccess(new NoDataResult(((Response)anl2.CD()).code, ((Response)anl2.CD()).message));
                            } else {
                                lbsCallback.onFailed(new ErrorRep(ErrorCode.REPORT_LOCATION_ERROR.ordinal(), ((Response)anl2.CD()).code + ((Response)anl2.CD()).message));
                            }
                        } else {
                            lbsCallback.onFailed(new ErrorRep(ErrorCode.REPORT_LOCATION_ERROR.ordinal(), "report data failed,http status:" + anl2.CB()));
                        }
                    }

                    public void a(Call<Response<Object>> call, Throwable throwable) {
                        lbsCallback.onFailed(new ErrorRep(ErrorCode.NET_ERROR.ordinal(), "network abnormal,request failed"));
                    }
                });
            }

            @Override
            public void a(String string3) {
                lbsCallback.onFailed(new ErrorRep(ErrorCode.GET_LOCATION_FAILED_ERROR.ordinal(), "get location failed:" + string3));
            }
        });
    }

    private void getLocationPoint(final cq cq2) {
        final BDLocationClient bDLocationClient = new BDLocationClient("projectG-lbs");
        bDLocationClient.setLocationMode(2).setLocationTimeOut(30000L).getLocation(new BDLocationClient.Callback(){

            @Override
            public void onLocationChanged(@Nullable BDLocation bDLocation) {
                AppExecutors.getInstance().mainThread().execute(() -> {
                    if (bDLocation == null) {
                        cq2.a("get location failed");
                    } else {
                        cq2.a(bDLocation);
                    }
                });
                bDLocationClient.stopLocation();
            }

            @Override
            public void onError(@Nullable BDLocationException bDLocationException) {
                AppExecutors.getInstance().mainThread().execute(() -> {
                    if (bDLocationException != null) {
                        cq2.a(bDLocationException.getMessage());
                    } else {
                        cq2.a("null");
                    }
                });
                bDLocationClient.stopLocation();
            }
        });
    }

    private void getLocationPoint(final LbsCallback<LocationDataResult> lbsCallback) {
        final BDLocationClient bDLocationClient = new BDLocationClient("projectG-lbs");
        bDLocationClient.setLocationMode(2).setLocationTimeOut(30000L).getLocation(new BDLocationClient.Callback(){

            @Override
            public void onLocationChanged(@Nullable BDLocation bDLocation) {
                AppExecutors.getInstance().mainThread().execute(() -> {
                    if (bDLocation != null) {
                        Location location = LocationService.this.bdLocationToLocation(bDLocation);
                        lbsCallback.onSuccess(new LocationDataResult(ErrorCode.SUCCESS.ordinal(), location));
                    } else {
                        lbsCallback.onFailed(new ErrorRep(ErrorCode.NET_ERROR.ordinal(), "network abnormal,request failed"));
                    }
                });
                bDLocationClient.stopLocation();
            }

            @Override
            public void onError(@Nullable BDLocationException bDLocationException) {
                bDLocationClient.stopLocation();
                lbsCallback.onFailed(new ErrorRep(ErrorCode.NET_ERROR.ordinal(), "network abnormal,request failed"));
            }
        });
    }

    private Location bdLocationToLocation(BDLocation bDLocation) {
        Location location = new Location();
        location.setCountry(bDLocation.getCountry());
        location.setCountryCode(bDLocation.getCountryCode());
        location.setProvince(bDLocation.getAdministrativeArea());
        location.setCity(bDLocation.getCity());
        location.setDistrict(bDLocation.getDistrict());
        location.setDisputed(bDLocation.getIsDisputed());
        location.setLatitude(bDLocation.getLatitude());
        location.setLongitude(bDLocation.getLongitude());
        location.setCountryAsci(bDLocation.getCountryAsciName());
        location.setProvinceAsci(bDLocation.getSubdivisionAsciName());
        location.setCityAsci(bDLocation.getCityAsciName());
        location.setDistrictAsci(bDLocation.getDistrictAsciName());
        if (axw.Hh()) {
            location.setCountryGeoNameId(bDLocation.getCountryId());
            location.setAdministrativeAreaGeoNameId(bDLocation.getSubdivisionId());
            location.setCityGeoNameId(bDLocation.getCityId());
            location.setDistrictGeoNameId(bDLocation.getDistrictId());
        }
        return location;
    }

    @Override
    public void getNearPoiData(Activity activity, final String string, final double d2, final double d3, final int n2, final List<PoiFilter> list, final LbsCallback<NearPoiDataResult> lbsCallback) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            lbsCallback.onFailed(new ErrorRep(ErrorCode.PARAM_INVALID_ERROR.ordinal(), "dataSet should not be empty"));
            return;
        }
        if (this.checkGPSPermission(activity)) {
            lbsCallback.onFailed(new ErrorRep(ErrorCode.PERMISSION_DENY_ERROR.ordinal(), "please enable gps-related permissions, includes READ_EXTERNAL_STORAGE and ACCESS_FINE_LOCATION"));
            return;
        }
        if (this.checkGPSOpen(activity)) {
            lbsCallback.onFailed(new ErrorRep(ErrorCode.GPS_NOT_OPEN_ERROR.ordinal(), "please open gps"));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)GameSdkConfig.getUniqueId())) {
            lbsCallback.onFailed(new ErrorRep(ErrorCode.NOT_LOGIN_ERROR.ordinal(), "please login"));
            return;
        }
        this.getLocationPoint(new cq(){

            @Override
            public void a(BDLocation bDLocation) {
                GetNearRequest getNearRequest = new GetNearRequest(string, SdkCoreData.getInstance().getConfig().appId, GameSdkConfig.getAccessToken(), d3, d2, n2, new LatLng(bDLocation.getLongitude(), bDLocation.getLatitude()), list);
                ((Request)LocationService.this.retrofit.create(Request.class)).getPOIDataList(getNearRequest).enqueue((ams)new ams<Response<NearPoiDataResult>>(){

                    public void a(Call<Response<NearPoiDataResult>> call, anl<Response<NearPoiDataResult>> anl2) {
                        if (anl2 != null && anl2.isSuccessful()) {
                            if (((Response)anl2.CD()).code == 0) {
                                lbsCallback.onSuccess(((Response)anl2.CD()).data);
                            } else {
                                lbsCallback.onFailed(new ErrorRep(ErrorCode.GET_NEAR_POI_DATA_ERROR.ordinal(), ((Response)anl2.CD()).code + ((Response)anl2.CD()).message));
                            }
                        } else {
                            lbsCallback.onFailed(new ErrorRep(ErrorCode.GET_NEAR_POI_DATA_ERROR.ordinal(), "get near poi data failed,http status:" + anl2.CB()));
                        }
                    }

                    public void a(Call<Response<NearPoiDataResult>> call, Throwable throwable) {
                        lbsCallback.onFailed(new ErrorRep(ErrorCode.NET_ERROR.ordinal(), "network abnormal,request failed"));
                    }
                });
            }

            @Override
            public void a(String string2) {
                lbsCallback.onFailed(new ErrorRep(ErrorCode.GET_LOCATION_FAILED_ERROR.ordinal(), "get location failed:" + string2));
            }
        });
    }

    @Override
    public void deletePoiPoint(String string, List<String> list, final LbsCallback<NoDataResult> lbsCallback) {
        if (TextUtils.isEmpty((CharSequence)string) || list == null || list.size() <= 0) {
            lbsCallback.onFailed(new ErrorRep(ErrorCode.PARAM_INVALID_ERROR.ordinal(), "dataSet and primaryKeys should not be empty"));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)GameSdkConfig.getUniqueId())) {
            lbsCallback.onFailed(new ErrorRep(ErrorCode.NOT_LOGIN_ERROR.ordinal(), "please login"));
            return;
        }
        DelDataRequest delDataRequest = new DelDataRequest(string, SdkCoreData.getInstance().getConfig().appId, GameSdkConfig.getAccessToken(), list);
        ((Request)this.retrofit.create(Request.class)).deletePOIData(delDataRequest).enqueue((ams)new ams<Response<Object>>(){

            public void a(Call<Response<Object>> call, anl<Response<Object>> anl2) {
                if (anl2 != null && anl2.isSuccessful()) {
                    if (((Response)anl2.CD()).code == 0) {
                        lbsCallback.onSuccess(new NoDataResult(((Response)anl2.CD()).code, ((Response)anl2.CD()).message));
                    } else {
                        lbsCallback.onFailed(new ErrorRep(ErrorCode.DEL_POI_DATA_ERROR.ordinal(), ((Response)anl2.CD()).code + ((Response)anl2.CD()).message));
                    }
                } else {
                    lbsCallback.onFailed(new ErrorRep(ErrorCode.DEL_POI_DATA_ERROR.ordinal(), "delete poi data failed,http status:" + anl2.CB()));
                }
            }

            public void a(Call<Response<Object>> call, Throwable throwable) {
                lbsCallback.onFailed(new ErrorRep(ErrorCode.NET_ERROR.ordinal(), "network abnormal,request failed"));
            }
        });
    }

    private boolean checkGPSOpen(Activity activity) {
        LocationManager locationManager = (LocationManager)activity.getSystemService("location");
        return !locationManager.isProviderEnabled("gps");
    }

    private boolean checkGPSPermission(Activity activity) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        String[] stringArray = this.getLocationPermissions();
        LocationPermissionUtil.a.a(activity, stringArray, (Function2<? super Boolean, ? super String, Unit>)((Function2)(bl2, string) -> {
            if (bl2.booleanValue()) {
                atomicBoolean.set(false);
            } else {
                atomicBoolean.set(true);
            }
            return null;
        }));
        return atomicBoolean.get();
    }

    private void requestLocationSetting() {
        avq.bam.a(settingsData -> {
            if (settingsData == null) {
                return null;
            }
            try {
                boolean bl2;
                JSONObject jSONObject = settingsData.getAppSettings();
                JSONObject jSONObject2 = jSONObject.getJSONObject("locationsdk");
                if (jSONObject2 == null) {
                    return null;
                }
                Timber.tag((String)TAG).i(jSONObject2.toString(), new Object[0]);
                if (jSONObject2.has(REPORT_AT_START)) {
                    bl2 = jSONObject2.optInt(REPORT_AT_START) == 1;
                    BDLocationConfig.setUpload(bl2);
                }
                if (jSONObject2.has(REPORT_POI_MAX)) {
                    bl2 = jSONObject2.optInt(REPORT_POI_MAX) == 1;
                    BDLocationConfig.setUploadPoi(bl2);
                }
                if (jSONObject2.has(REPORT_INTERVAL_SECONDS)) {
                    BDLocationConfig.setUploadInterval(jSONObject2.optLong(REPORT_INTERVAL_SECONDS));
                }
                if (jSONObject2.has(REPORT_DEVICE_INFO)) {
                    bl2 = jSONObject2.optInt(REPORT_DEVICE_INFO) == 1;
                    BDLocationConfig.setUploadMccAndSystemRegionInfo(bl2);
                }
                if (jSONObject2.has(REPORT_BSS_MAX)) {
                    bl2 = jSONObject2.optInt(REPORT_BSS_MAX) == 1;
                    BDLocationConfig.setUploadBaseSite(bl2);
                }
                if (jSONObject2.has(REPORT_WIFI_MAX)) {
                    BDLocationConfig.setWifiNum(jSONObject2.optInt(REPORT_WIFI_MAX));
                }
                if (jSONObject2.has(REPORT_GPS)) {
                    bl2 = jSONObject2.optInt(REPORT_GPS) == 1;
                    BDLocationConfig.setIsUploadGPS(bl2);
                }
                if (jSONObject2.has(REPORT_DEVICE_INFO_AT_START)) {
                    bl2 = jSONObject2.optInt(REPORT_DEVICE_INFO_AT_START) == 1;
                    BDLocationConfig.setReportAtStart(bl2);
                }
            }
            catch (JSONException jSONException) {
                Timber.tag((String)TAG).d((Throwable)jSONException);
            }
            return null;
        });
    }
}

