/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bdlocation.client;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import g.optional.location.bt;
import g.optional.location.bv;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class LocationOption {
    long locationTimeOutMs;
    long interval;
    int mode = 2;
    long maxCacheTime = 30000L;
    long maxCacheTimeForLocateFail = 604800000L;
    @NonNull
    bt mTrace;
    int geocodeMode = 2;
    int locateAccuracy = 1;
    public static final int Battery_Saving = 0;
    public static final int Device_Sensors = 1;
    public static final int Hight_Accuracy = 2;
    public static final int NO_GEOCODE = 0;
    public static final int SYSTEM_GEOCODE = 1;
    public static final int THIRD_GEOCODE = 2;
    public static final int DISTRICT_LEVEL = 0;
    public static final int POI_LEVEL = 1;

    public LocationOption(String string) {
        this.mTrace = new bt(string);
    }

    public LocationOption(LocationOption locationOption) {
        this.locationTimeOutMs = locationOption.locationTimeOutMs;
        this.interval = locationOption.interval;
        this.mode = locationOption.mode;
        this.maxCacheTime = locationOption.maxCacheTime;
        this.maxCacheTimeForLocateFail = locationOption.maxCacheTimeForLocateFail;
        this.mTrace = locationOption.mTrace;
        this.geocodeMode = locationOption.geocodeMode;
        this.locateAccuracy = locationOption.locateAccuracy;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationOption)) {
            return false;
        }
        LocationOption locationOption = (LocationOption)object;
        if (this.locationTimeOutMs != locationOption.locationTimeOutMs) {
            return false;
        }
        if (this.interval != locationOption.interval) {
            return false;
        }
        if (this.geocodeMode != locationOption.geocodeMode) {
            return false;
        }
        if (this.maxCacheTimeForLocateFail != locationOption.maxCacheTimeForLocateFail) {
            return false;
        }
        if (this.locateAccuracy != locationOption.locateAccuracy) {
            return false;
        }
        return this.mode == locationOption.mode;
    }

    public int hashCode() {
        int n2 = (int)(this.locationTimeOutMs ^ this.locationTimeOutMs >>> 32);
        n2 = 31 * n2 + (int)(this.interval ^ this.interval >>> 32);
        n2 = 31 * n2 + this.mode;
        n2 = 31 * n2 + this.geocodeMode;
        n2 = 31 * n2 + this.locateAccuracy;
        n2 = 31 * n2 + (int)(this.maxCacheTime ^ this.maxCacheTime >>> 32);
        n2 = 31 * n2 + (int)(this.maxCacheTimeForLocateFail ^ this.maxCacheTimeForLocateFail >>> 32);
        return n2;
    }

    public String toString() {
        return "LocationOption{locationTimeOutMs=" + this.locationTimeOutMs + ", interval=" + this.interval + ", mode=" + this.mode + ", geocodeMode=" + this.geocodeMode + ", locateAccuracy=" + this.locateAccuracy + ", maxCacheTime=" + this.maxCacheTime + ", maxCacheTimeForLocateFail=" + this.maxCacheTimeForLocateFail + ", mTrace=" + this.mTrace + '}';
    }

    public long getLocationTimeOutMs() {
        return this.locationTimeOutMs;
    }

    public void setLocationTimeOutMs(long l2) {
        this.locationTimeOutMs = l2;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long l2) {
        this.interval = l2;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n2) {
        this.mode = n2;
    }

    public long getMaxCacheTime() {
        return this.maxCacheTime;
    }

    public void setMaxCacheTime(long l2) {
        this.maxCacheTime = l2;
    }

    public long getMaxCacheTimeForLocateFail() {
        return this.maxCacheTimeForLocateFail;
    }

    public void setMaxCacheTimeForLocateFail(long l2) {
        this.maxCacheTimeForLocateFail = l2;
    }

    @VisibleForTesting(otherwise=4)
    public void setTrace(@NonNull bt bt2) {
        this.mTrace = bt2;
    }

    public bt getTrace() {
        return this.mTrace;
    }

    public int geocodeMode() {
        return this.geocodeMode;
    }

    public void setGeocodeMode(int n2) {
        this.geocodeMode = n2;
    }

    public int getLocateAccuracy() {
        return this.locateAccuracy;
    }

    public void setLocateAccuracy(int n2) {
        this.locateAccuracy = n2;
    }

    public void setTraceCallback(bv bv2) {
        this.mTrace.a(bv2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LocateAccuracy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GeocodeMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LocationMode {
    }
}

