/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bdlocation;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.os.Looper;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.PermissionChecker;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.bdlocation.BDLocation;
import com.bytedance.bdlocation.client.BDLocationConfig;
import com.bytedance.bdlocation.client.LocationOption;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import g.optional.location.ay;
import g.optional.location.be;
import g.optional.location.by;
import g.optional.location.bz;
import g.optional.location.ce;
import g.optional.location.ch;
import g.optional.location.cj;
import g.optional.location.cn;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Util {
    private static ExecutorService sWorker = Executors.newSingleThreadExecutor();
    private static final String TAG = "Util";
    private static final int NO_RESPONCE = -1;
    private static int currentGPSState = -1;
    private static boolean isFinish = false;
    private static int LOCATION_REQUEST_PERMISSIONS_CODE = 4104;
    private static final int GPS_WAITING_TIME = 300;
    public static Gson sGson = new GsonBuilder().addDeserializationExclusionStrategy((ExclusionStrategy)new cn()).addSerializationExclusionStrategy((ExclusionStrategy)new cn()).registerTypeHierarchyAdapter(Location.class, (Object)new ch()).registerTypeHierarchyAdapter(Location.class, (Object)new ce()).registerTypeHierarchyAdapter(BDLocation.class, (Object)new bz()).registerTypeHierarchyAdapter(BDLocation.class, (Object)new by()).create();
    public static int LOCATION_PERMISSION_OK = 1;
    public static int LOCATION_PERMISSION_NO = 71;

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static JsonElement safeToJsonTree(Object object) {
        JsonElement jsonElement = null;
        try {
            jsonElement = sGson.toJsonTree(object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jsonElement;
    }

    public static int checkLocationPermissions(Context context) {
        try {
            String[] stringArray;
            for (String string : stringArray = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"}) {
                if (PermissionChecker.checkSelfPermission((Context)context, (String)string) != 0) continue;
                return LOCATION_PERMISSION_OK;
            }
            return LOCATION_PERMISSION_NO;
        }
        catch (Exception exception) {
            return LOCATION_PERMISSION_NO;
        }
    }

    public static boolean hasLocationPermissions(Context context) {
        return Util.checkLocationPermissions(context) == LOCATION_PERMISSION_OK;
    }

    public static void requestLocationPermission(Activity activity) {
        if (Util.canRequestLocationPermission() && Util.checkLocationPermissions(BDLocationConfig.getContext()) != LOCATION_PERMISSION_OK) {
            Util.requestPermission(activity, new String[]{"android.permission.ACCESS_FINE_LOCATION"}, LOCATION_REQUEST_PERMISSIONS_CODE);
        }
    }

    public static void requestPermission(Activity activity, String[] stringArray, int n2) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray, (int)n2);
    }

    public static void onRequestPermissionsResult(int n2, String[] stringArray, int[] nArray) {
        if (n2 == LOCATION_REQUEST_PERMISSIONS_CODE) {
            if (nArray.length > 0 && nArray[0] == 0) {
                Log.d((String)"BDLocation", (String)"permission is granted");
            } else {
                Log.d((String)"BDLocation", (String)"permission is denied");
                ay.a().d().b(System.currentTimeMillis());
            }
            return;
        }
    }

    public static boolean canRequestLocationPermission() {
        long l2;
        be be2 = ay.a().d();
        long l3 = System.currentTimeMillis();
        return l3 - (l2 = be2.d()) > 172800000L;
    }

    public static int checkPermissions(Context context, String string) {
        try {
            if (PermissionChecker.checkSelfPermission((Context)context, (String)string) == 0) {
                return LOCATION_PERMISSION_OK;
            }
            return LOCATION_PERMISSION_NO;
        }
        catch (Exception exception) {
            return LOCATION_PERMISSION_NO;
        }
    }

    private static int getGpsStatusLimitTime(final Context context) {
        isFinish = false;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n2 = 0;
                try {
                    List list;
                    LocationManager locationManager = (LocationManager)context.getSystemService("location");
                    if (locationManager != null && (list = locationManager.getProviders(true)) != null && !list.isEmpty() && locationManager.isProviderEnabled("gps")) {
                        n2 = 1;
                    }
                }
                catch (Exception exception) {
                    cj.e(Util.TAG, "getGpsStatusLimitTime: " + exception.getMessage(), exception);
                }
                currentGPSState = n2;
                isFinish = true;
            }
        };
        sWorker.submit(runnable);
        long l2 = System.currentTimeMillis();
        try {
            int n2 = 1;
            while (System.currentTimeMillis() - l2 < 300L && !isFinish) {
                Thread.sleep(n2);
                if (n2 >= 10) continue;
                ++n2;
            }
        }
        catch (Exception exception) {
            cj.e(TAG, "getGpsStatusLimitTime: " + exception.getMessage(), exception);
        }
        if (!isFinish) {
            return -1;
        }
        return currentGPSState;
    }

    public static void ready(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.location.PROVIDERS_CHANGED");
            context.registerReceiver((BroadcastReceiver)new GPSReceiver(), intentFilter);
        }
        catch (Exception exception) {
            cj.e(TAG, "ready: " + exception.getMessage(), exception);
        }
    }

    public static boolean needLocate() {
        return Util.checkLocationPermissions(BDLocationConfig.getContext()) == LOCATION_PERMISSION_OK;
    }

    public static boolean isLocationEnabled() {
        int n2 = 0;
        if (Build.VERSION.SDK_INT >= 28) {
            try {
                LocationManager locationManager = (LocationManager)BDLocationConfig.getContext().getSystemService("location");
                return locationManager.isLocationEnabled();
            }
            catch (Exception exception) {
                cj.e("location enable status error", exception.getMessage());
                return false;
            }
        }
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                n2 = Settings.Secure.getInt((ContentResolver)BDLocationConfig.getContext().getContentResolver(), (String)"location_mode");
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                settingNotFoundException.printStackTrace();
                return false;
            }
            return n2 != 0;
        }
        String string = Settings.Secure.getString((ContentResolver)BDLocationConfig.getContext().getContentResolver(), (String)"location_providers_allowed");
        return !TextUtils.isEmpty((CharSequence)string);
    }

    public static int getLocationMode(Context context) {
        try {
            List list;
            if (!Util.isLocationEnabled()) {
                return 1;
            }
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            if (locationManager != null && (list = locationManager.getProviders(true)) != null && !list.isEmpty()) {
                if (locationManager.isProviderEnabled("gps")) {
                    return 2;
                }
                if (locationManager.isProviderEnabled("network")) {
                    return 4;
                }
                if (locationManager.isProviderEnabled("passive")) {
                    return 8;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static String languageTag(Locale locale) {
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string + "-" + string2;
        }
        return string;
    }

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static <T> JsonObject ObjectToJsonObject(T t2) {
        return new Gson().toJsonTree(t2).getAsJsonObject();
    }

    public static boolean isUploadScheduleTask(LocationOption locationOption) {
        return locationOption != null && !TextUtils.isEmpty((CharSequence)locationOption.getTrace().g()) && locationOption.getTrace().g().equals("BDLocation_Upload");
    }

    public static boolean isByteLocation(BDLocation bDLocation) {
        return bDLocation != null && !TextUtils.isEmpty((CharSequence)bDLocation.getLocationSDKName()) && bDLocation.getLocationSDKName().equals("ByteLocation");
    }

    public static boolean isByteLocationGPS(BDLocation bDLocation) {
        return bDLocation != null && !TextUtils.isEmpty((CharSequence)bDLocation.getLocationSDKName()) && bDLocation.getLocationSDKName().equals("ByteLocation") && bDLocation.getLocationType() == 1;
    }

    public static long getCurrentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static boolean isTimeAfterHour(long l2, int n2) {
        long l3 = Util.getCurrentTimeSeconds();
        return l3 - l2 > (long)(n2 * 60 * 60);
    }

    public static String getDeviceName() {
        return Build.MANUFACTURER;
    }

    static class GPSReceiver
    extends BroadcastReceiver {
        private static final String TAG = "GPSReceiver";

        GPSReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if ("android.location.PROVIDERS_CHANGED".equals(string)) {
                int n2 = Util.getGpsStatusLimitTime(context);
                currentGPSState = n2;
                cj.b(TAG, "GPSReceiver onReceive: " + n2);
            }
        }
    }
}

