/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bdlocation;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bytedance.bdlocation.BDLocation;
import com.bytedance.bdlocation.Util;
import com.bytedance.bdlocation.client.BDLocationConfig;
import g.main.ny;
import g.optional.location.ag;
import g.optional.location.an;
import g.optional.location.ao;
import g.optional.location.ap;
import g.optional.location.ar;
import g.optional.location.z;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public final class LocationUtil {
    public static final int TWO_MINUTES = 120000;
    public static final int HALF_MINUTES = 30000;

    private LocationUtil() {
    }

    @Nullable
    public static String getCityCodeForChina(z z2) {
        ap ap2;
        an an2;
        if (z2 != null && (an2 = z2.a) != null && (ap2 = an2.d) != null) {
            return ap2.e;
        }
        return null;
    }

    @Nullable
    public static String getCityCodeForOverSea(z z2) {
        ap ap2;
        an an2;
        if (z2 != null && (an2 = z2.a) != null && (ap2 = an2.d) != null) {
            return String.valueOf(ap2.b);
        }
        return null;
    }

    @Nullable
    public static String getCountryCode(z z2) {
        ap ap2;
        an an2;
        if (z2 != null && (an2 = z2.a) != null && (ap2 = an2.b) != null) {
            return ap2.a;
        }
        return null;
    }

    public static int compareLocation(BDLocation bDLocation, BDLocation bDLocation2) {
        if (bDLocation == null || bDLocation2 == null || bDLocation.isEmpty() || bDLocation2.isEmpty()) {
            return -1;
        }
        if (!(ny.F((String)bDLocation.getCountry(), (String)bDLocation2.getCountry()) || TextUtils.isEmpty((CharSequence)bDLocation.getCountry()) || TextUtils.isEmpty((CharSequence)bDLocation2.getCountry()))) {
            return 1;
        }
        if (!(ny.F((String)bDLocation.getAdministrativeArea(), (String)bDLocation2.getAdministrativeArea()) || TextUtils.isEmpty((CharSequence)bDLocation.getAdministrativeArea()) || TextUtils.isEmpty((CharSequence)bDLocation2.getAdministrativeArea()))) {
            return 2;
        }
        if (!(ny.F((String)bDLocation.getSubAdministrativeArea(), (String)bDLocation2.getSubAdministrativeArea()) || TextUtils.isEmpty((CharSequence)bDLocation.getSubAdministrativeArea()) || TextUtils.isEmpty((CharSequence)bDLocation2.getSubAdministrativeArea()))) {
            return 3;
        }
        if (!(ny.F((String)bDLocation.getCity(), (String)bDLocation2.getCity()) || TextUtils.isEmpty((CharSequence)bDLocation.getCity()) || TextUtils.isEmpty((CharSequence)bDLocation2.getCity()))) {
            return 4;
        }
        if (!(ny.F((String)bDLocation.getDistrict(), (String)bDLocation2.getDistrict()) || TextUtils.isEmpty((CharSequence)bDLocation.getDistrict()) || TextUtils.isEmpty((CharSequence)bDLocation2.getDistrict()))) {
            return 5;
        }
        return -1;
    }

    public static boolean isBetterLocation(Location location, Location location2) {
        boolean bl2;
        if (location2 == null) {
            return true;
        }
        long l2 = location.getTime() - location2.getTime();
        boolean bl3 = l2 > 120000L;
        boolean bl4 = l2 < -120000L;
        boolean bl5 = bl2 = l2 > 0L;
        if (bl3) {
            return true;
        }
        if (bl4) {
            return false;
        }
        int n2 = (int)(location.getAccuracy() - location2.getAccuracy());
        boolean bl6 = n2 > 0;
        boolean bl7 = n2 < 0;
        boolean bl8 = n2 > 200;
        boolean bl9 = LocationUtil.isSameProvider(location.getProvider(), location2.getProvider());
        if (bl7) {
            return true;
        }
        if (bl2 && !bl6) {
            return true;
        }
        return bl2 && !bl8 && bl9;
    }

    public static boolean isGoodLocation(BDLocation bDLocation) {
        Calendar calendar = Calendar.getInstance();
        long l2 = calendar.getTimeInMillis();
        if (l2 - bDLocation.getTime() >= 30000L) {
            return false;
        }
        if (bDLocation.getAccuracy() > 500.0f) {
            return false;
        }
        return bDLocation.getLocationType() != 3;
    }

    public static BDLocation addressesToBDLocation(List<Address> list, BDLocation bDLocation, String string) {
        if (Util.isEmpty(list)) {
            return null;
        }
        BDLocation bDLocation2 = new BDLocation(bDLocation);
        bDLocation2.setGeocodeSDKName(string);
        for (Address address : list) {
            if (!address.hasLatitude() || !address.hasLongitude()) continue;
            bDLocation2.setCountry(address.getCountryName());
            bDLocation2.setAdministrativeArea(address.getAdminArea());
            bDLocation2.setSubAdministrativeArea(address.getSubAdminArea());
            bDLocation2.setCity(address.getLocality());
            bDLocation2.setDistrict(address.getSubLocality());
            bDLocation2.setStreet(address.getThoroughfare());
            bDLocation2.setStreetNum(address.getSubThoroughfare());
            bDLocation2.setAddress(address.getAddressLine(0));
            bDLocation2.setPoi(address.getFeatureName());
            break;
        }
        return bDLocation2;
    }

    public static BDLocation locationResultToBDLocation(BDLocation bDLocation, @Nullable an an2) {
        ag ag2;
        ar ar2;
        ar ar3;
        ap ap2;
        ap ap3;
        ap[] apArray;
        ao ao2;
        BDLocation bDLocation2;
        if (an2 == null) {
            return null;
        }
        if (bDLocation == null) {
            bDLocation2 = new BDLocation("bd_geocode", "Android");
            bDLocation2.setGeocodeSDKName("LBS");
        } else {
            bDLocation2 = new BDLocation(bDLocation);
        }
        ap ap4 = an2.b;
        if (ap4 != null) {
            bDLocation2.setCountry(ap4.d);
            bDLocation2.setCountryCode(ap4.a);
            bDLocation2.setCountryId(ap4.b);
            bDLocation2.setCountryAsciName(ap4.c);
        }
        if ((ao2 = an2.f) != null && !Util.isEmpty(ao2.a)) {
            bDLocation2.setAddress(ao2.a.get(0));
        }
        if ((apArray = an2.c) != null && apArray.length > 0) {
            bDLocation2.setAdministrativeArea(apArray[0].d);
            bDLocation2.setSubdivisionId(apArray[0].b);
            bDLocation2.setSubdivisionAsciName(apArray[0].c);
        }
        if (apArray != null && apArray.length > 1) {
            bDLocation2.setSubAdministrativeArea(apArray[1].d);
        }
        if ((ap3 = an2.d) != null) {
            bDLocation2.setCity(ap3.d);
            bDLocation2.setLocalID(ap3.e);
            bDLocation2.setGeoNameID(String.valueOf(ap3.b));
            bDLocation2.setCityId(ap3.b);
            bDLocation2.setCityAsciName(ap3.c);
        }
        if ((ap2 = an2.e) != null) {
            bDLocation2.setDistrict(ap2.d);
            bDLocation2.setDistrictId(ap2.b);
            bDLocation2.setDistrictAsciName(ap2.c);
        }
        if ((ar3 = an2.k) != null) {
            bDLocation2.setTown(ar3.d);
            bDLocation2.setTownId(ar3.b);
            bDLocation2.setTownAsciName(ar3.c);
        }
        if ((ar2 = an2.l) != null) {
            bDLocation2.setVillage(ar2.d);
            bDLocation2.setVillageId(ar2.b);
            bDLocation2.setVillageAsciName(ar2.c);
        }
        if ((ag2 = an2.g) != null && ag2.d != 0.0 && ag2.d != 0.0) {
            bDLocation2.setLatitude(ag2.d);
            bDLocation2.setLongitude(ag2.e);
        }
        if (an2.m && ap4 == null && apArray == null && ap3 == null && ap2 == null && ao2 == null) {
            bDLocation2 = new BDLocation("", "");
        }
        bDLocation2.setLocationType(LocationUtil.transformLocateMethod(an2.i));
        bDLocation2.setIsDisputed(an2.m);
        bDLocation2.setIsCompliance(true);
        bDLocation2.setLocationResult(an2);
        return bDLocation2;
    }

    public static BDLocation locationResultToBDLocation(@Nullable z z2) {
        return LocationUtil.locationResultToBDLocation(null, z2);
    }

    public static BDLocation locationResultToBDLocation(@Nullable BDLocation bDLocation, @Nullable z z2) {
        Object object;
        BDLocation bDLocation2;
        if (z2 == null) {
            return null;
        }
        an an2 = z2.a;
        if (an2 == null) {
            return null;
        }
        if (bDLocation == null) {
            bDLocation2 = new BDLocation("bd_lbs", "Android");
            bDLocation2.setGeocodeSDKName("LBS");
        } else {
            bDLocation2 = new BDLocation(bDLocation);
            object = bDLocation.getGeocodeSDKName();
            if (!TextUtils.isEmpty((CharSequence)object) && !"LBS".equals(object)) {
                bDLocation2.setGeocodeSDKName((String)object + "_" + "LBS");
            } else {
                bDLocation2.setGeocodeSDKName("LBS");
            }
        }
        bDLocation2.setBdLBSResult(z2);
        if (bDLocation == null || !bDLocation.hasAddress()) {
            ag ag2;
            ap ap2;
            ap ap3;
            ap[] apArray;
            ao ao2;
            object = an2.b;
            if (object != null) {
                bDLocation2.setCountry(((ap)object).d);
                bDLocation2.setCountryCode(((ap)object).a);
            }
            if ((ao2 = an2.f) != null && !Util.isEmpty(ao2.a)) {
                bDLocation2.setAddress(ao2.a.get(0));
            }
            if ((apArray = an2.c) != null && apArray.length > 0) {
                bDLocation2.setAdministrativeArea(apArray[0].d);
            }
            if (apArray != null && apArray.length > 1) {
                bDLocation2.setSubAdministrativeArea(apArray[1].d);
            }
            if ((ap3 = an2.d) != null) {
                bDLocation2.setCity(ap3.d);
                bDLocation2.setLocalID(ap3.e);
                bDLocation2.setGeoNameID(String.valueOf(ap3.b));
            }
            if ((ap2 = an2.e) != null) {
                bDLocation2.setDistrict(ap2.d);
            }
            if ((ag2 = an2.g) != null && ag2.d != 0.0 && ag2.d != 0.0) {
                bDLocation2.setLatitude(ag2.d);
                bDLocation2.setLongitude(ag2.e);
            }
            bDLocation2.setLocationType(LocationUtil.transformLocateMethod(an2.i));
        } else {
            ap ap4;
            object = an2.b;
            if (object != null) {
                bDLocation2.setCountry(((ap)object).d);
                bDLocation2.setCountryCode(((ap)object).a);
            }
            if ((ap4 = an2.d) != null) {
                bDLocation2.setLocalID(ap4.e);
                bDLocation2.setGeoNameID(String.valueOf(ap4.b));
            }
        }
        return bDLocation2;
    }

    public static int transformLocateMethod(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (string.equals("GPSLocation")) {
                return 1;
            }
            if (string.equals("WiFi")) {
                return 2;
            }
            if (string.equals("bss")) {
                return 3;
            }
            if (string.equals("IPLocation")) {
                return 6;
            }
            if (string.equals("MCC")) {
                return 7;
            }
        }
        return 0;
    }

    public static BDLocation geocode(Context context, BDLocation bDLocation) throws IOException {
        BDLocation bDLocation2 = null;
        if (Geocoder.isPresent()) {
            Locale locale = BDLocationConfig.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Geocoder geocoder = new Geocoder(context, locale);
            List list = geocoder.getFromLocation(bDLocation.getLatitude(), bDLocation.getLongitude(), 10);
            bDLocation2 = LocationUtil.addressesToBDLocation(list, bDLocation, "Android");
        }
        return bDLocation2;
    }

    public static boolean checkCacheTime(long l2, long l3) {
        if (l2 == 0L) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        long l4 = calendar.getTimeInMillis();
        return l4 - l2 < l3 + 5000L;
    }

    public static boolean isEmpty(Location location) {
        if (location == null) {
            return true;
        }
        return Double.compare(location.getLatitude(), 0.0) == 0 && Double.compare(location.getLongitude(), 0.0) == 0;
    }

    public static boolean checkGeocode(BDLocation bDLocation) {
        if (bDLocation == null) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)bDLocation.getCountry())) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)bDLocation.getAdministrativeArea()) || !TextUtils.isEmpty((CharSequence)bDLocation.getSubAdministrativeArea()) || !TextUtils.isEmpty((CharSequence)bDLocation.getCity());
    }

    @NonNull
    public static BDLocation composeGeocodeLocation(@NonNull BDLocation bDLocation, @NonNull BDLocation bDLocation2) {
        BDLocation bDLocation3 = new BDLocation(bDLocation);
        bDLocation3.setAddress(bDLocation2.getAddress());
        bDLocation3.setCity(bDLocation2.getCity());
        bDLocation3.setAdministrativeArea(bDLocation2.getAdministrativeArea());
        bDLocation3.setSubAdministrativeArea(bDLocation2.getSubAdministrativeArea());
        bDLocation3.setProvider(bDLocation2.getProvider());
        bDLocation3.setDistrict(bDLocation2.getDistrict());
        bDLocation3.setCountry(bDLocation2.getCountry());
        bDLocation3.setCityCode(bDLocation2.getCityCode());
        bDLocation3.setStreet(bDLocation2.getStreet());
        bDLocation3.setStreetNum(bDLocation2.getStreetNum());
        bDLocation3.setFloor(bDLocation2.getFloor());
        bDLocation3.setThirdPartLocation(bDLocation2.getThirdPartLocation());
        bDLocation3.setLocationSDKName(bDLocation2.getLocationSDKName());
        bDLocation3.setPoi(bDLocation2.getPoi());
        bDLocation3.setGCJ02(bDLocation2.getGCJ02());
        bDLocation3.setLocationType(bDLocation2.getLocationType());
        bDLocation3.setCountryCode(bDLocation2.getCountryCode());
        bDLocation3.setLocalID(bDLocation2.getLocalID());
        bDLocation3.setGeoNameID(bDLocation2.getGeoNameID());
        bDLocation3.setBdLBSResult(bDLocation2.getBdLBSResult());
        bDLocation3.setLocationResult(bDLocation2.getLocationResult());
        bDLocation3.setGeocodeSDKName(bDLocation2.getGeocodeSDKName());
        bDLocation3.setAoi(bDLocation2.getAoi());
        bDLocation3.setIsDisputed(bDLocation2.getIsDisputed());
        bDLocation3.setIsCompliance(bDLocation2.getIsCompliance());
        bDLocation3.setCountryId(bDLocation2.getCountryId());
        bDLocation3.setSubdivisionId(bDLocation2.getSubdivisionId());
        bDLocation3.setCityId(bDLocation2.getCityId());
        bDLocation3.setDistrictId(bDLocation2.getDistrictId());
        bDLocation3.setCountryAsciName(bDLocation2.getCountryAsciName());
        bDLocation3.setSubdivisionAsciName(bDLocation2.getSubdivisionAsciName());
        bDLocation3.setCityAsciName(bDLocation2.getCityAsciName());
        bDLocation3.setDistrictAsciName(bDLocation2.getDistrictAsciName());
        return bDLocation3;
    }

    private static boolean isSameProvider(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }
}

