/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bdlocation;

import android.location.Location;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.bytedance.bdlocation.client.BDLocationException;
import com.bytedance.bdlocation.client.BDPoint;
import g.optional.location.an;
import g.optional.location.z;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BDLocation
extends Location {
    private String mAddress;
    private String mCountry;
    private String mAdministrativeArea;
    private String mSubAdministrativeArea;
    private String mCity;
    private String mDistrict;
    private String mTown;
    private String mVillage;
    private long mCountryId;
    private long mSubdivisionId;
    private long mCityId;
    private long mDistrictId;
    private long mTownId;
    private long mVillageId;
    private String mCountryAsciName;
    private String mSubdivisionAsciName;
    private String mCityAsciName;
    private String mDistrictAsciName;
    private String mTownAsciName;
    private String mVillageAsciName;
    @Deprecated
    private String mCityCode;
    private double mLatitude;
    private double mLongitude;
    private String mStreet;
    private String mStreetNum;
    private String mFloor;
    private long mLocationMs;
    private transient Location mThirdPartLocation;
    private String mLocationSDKName;
    private String mPoi;
    private BDPoint mGCJ02;
    private int mLocationType;
    private transient boolean isCache;
    private String mCountryCode;
    private String mLocalID;
    private String mGeoNameID;
    private z mBdLBSResult;
    private an mLocationResult;
    private String mGeocodeSDKName;
    private String mAoi;
    private boolean mIsDisputed;
    private boolean mIsCompliance;
    private String mCoordinateSystem = "wgs84";
    private BDLocationException mLocationException;
    public static final int UNKNOWN = 0;
    public static final int GPS = 1;
    public static final int WIFI = 2;
    public static final int BASE_STATION = 3;
    public static final int NETWORK = 4;
    @Deprecated
    public static final int CACHE = 5;
    public static final int IP = 6;
    public static final int MCC = 7;
    public static final String AMAP = "AMap";
    public static final String GOOGLE = "Google";
    public static final String BYTE = "ByteLocation";
    public static final String SYSTEM = "Android";

    public BDLocation(@NonNull String string, @NonNull String string2) {
        super(string);
        this.mLocationSDKName = string2;
        this.mLocationType = this.transProvider(string);
    }

    public BDLocation(@NonNull Location location, @NonNull String string) {
        super(location.getProvider());
        this.superLocation(location);
        this.mLatitude = location.getLatitude();
        this.mLongitude = location.getLongitude();
        this.mLocationMs = location.getTime();
        this.mThirdPartLocation = location;
        this.mLocationSDKName = string;
        this.mLocationType = this.transProvider(location.getProvider());
    }

    public BDLocation(@NonNull BDLocation bDLocation) {
        super(bDLocation.getProvider());
        this.superLocation(bDLocation);
        this.mLocationMs = bDLocation.getTime();
        this.mThirdPartLocation = bDLocation.mThirdPartLocation;
        this.mAddress = bDLocation.mAddress;
        this.mCountry = bDLocation.mCountry;
        this.mCountryId = bDLocation.mCountryId;
        this.mAdministrativeArea = bDLocation.mAdministrativeArea;
        this.mSubdivisionId = bDLocation.mSubdivisionId;
        this.mSubAdministrativeArea = bDLocation.mSubAdministrativeArea;
        this.mCity = bDLocation.mCity;
        this.mCityId = bDLocation.mCityId;
        this.mDistrict = bDLocation.mDistrict;
        this.mDistrictId = bDLocation.mDistrictId;
        this.mTown = bDLocation.mTown;
        this.mTownId = bDLocation.mTownId;
        this.mVillage = bDLocation.mVillage;
        this.mVillageId = bDLocation.mVillageId;
        this.mCountryAsciName = bDLocation.mCountryAsciName;
        this.mSubdivisionAsciName = bDLocation.mSubdivisionAsciName;
        this.mCityAsciName = bDLocation.mCityAsciName;
        this.mDistrictAsciName = bDLocation.mDistrictAsciName;
        this.mTownAsciName = bDLocation.mTownAsciName;
        this.mVillageAsciName = bDLocation.mVillageAsciName;
        this.mCityCode = bDLocation.mCityCode;
        this.setLatitude(bDLocation.getLatitude());
        this.setLongitude(bDLocation.getLongitude());
        this.mLocationMs = bDLocation.getTime();
        this.mStreet = bDLocation.mStreet;
        this.mStreetNum = bDLocation.mStreetNum;
        this.mFloor = bDLocation.mFloor;
        this.mLocationSDKName = bDLocation.mLocationSDKName;
        this.mGCJ02 = bDLocation.mGCJ02;
        this.mPoi = bDLocation.mPoi;
        this.mLocationType = bDLocation.mLocationType;
        this.isCache = bDLocation.isCache;
        this.mCountryCode = bDLocation.mCountryCode;
        this.mLocalID = bDLocation.mLocalID;
        this.mGeoNameID = bDLocation.mGeoNameID;
        this.mBdLBSResult = bDLocation.mBdLBSResult;
        this.mGeocodeSDKName = bDLocation.mGeocodeSDKName;
        this.mAoi = bDLocation.mAoi;
        this.mIsDisputed = bDLocation.mIsDisputed;
        this.mIsCompliance = bDLocation.mIsCompliance;
        this.mCoordinateSystem = bDLocation.mCoordinateSystem;
        this.mLocationException = bDLocation.mLocationException;
    }

    private void superLocation(Location location) {
        this.setProvider(location.getProvider());
        this.setTime(location.getTime());
        if (Build.VERSION.SDK_INT >= 17) {
            this.setElapsedRealtimeNanos(location.getElapsedRealtimeNanos());
        }
        this.setLatitude(location.getLatitude());
        this.setLongitude(location.getLongitude());
        this.setAltitude(location.getAltitude());
        this.setSpeed(location.getSpeed());
        this.setBearing(location.getBearing());
        this.setAccuracy(location.getAccuracy());
        this.setAltitude(location.getAltitude());
        if (Build.VERSION.SDK_INT >= 26) {
            this.setVerticalAccuracyMeters(location.getVerticalAccuracyMeters());
        }
        if (Build.VERSION.SDK_INT >= 26) {
            this.setVerticalAccuracyMeters(location.getVerticalAccuracyMeters());
        }
        if (Build.VERSION.SDK_INT >= 26) {
            this.setSpeedAccuracyMetersPerSecond(location.getSpeedAccuracyMetersPerSecond());
        }
        if (Build.VERSION.SDK_INT >= 26) {
            this.setBearingAccuracyDegrees(location.getBearingAccuracyDegrees());
        }
    }

    public String getCountry() {
        return this.mCountry;
    }

    public void setCountry(String string) {
        this.mCountry = string;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public void setAddress(String string) {
        this.mAddress = string;
    }

    public String getAdministrativeArea() {
        return this.mAdministrativeArea;
    }

    public void setAdministrativeArea(String string) {
        this.mAdministrativeArea = string;
    }

    public long getCityId() {
        return this.mCityId;
    }

    public void setCityId(long l2) {
        this.mCityId = l2;
    }

    public long getCountryId() {
        return this.mCountryId;
    }

    public void setCountryId(long l2) {
        this.mCountryId = l2;
    }

    public long getSubdivisionId() {
        return this.mSubdivisionId;
    }

    public void setSubdivisionId(long l2) {
        this.mSubdivisionId = l2;
    }

    public long getDistrictId() {
        return this.mDistrictId;
    }

    public void setDistrictId(long l2) {
        this.mDistrictId = l2;
    }

    public String getSubAdministrativeArea() {
        return this.mSubAdministrativeArea;
    }

    public void setSubAdministrativeArea(String string) {
        this.mSubAdministrativeArea = string;
    }

    public String getCity() {
        return this.mCity;
    }

    public void setCity(String string) {
        this.mCity = string;
    }

    public String getDistrict() {
        return this.mDistrict;
    }

    public void setDistrict(String string) {
        this.mDistrict = string;
    }

    public String getTown() {
        return this.mTown;
    }

    public void setTown(String string) {
        this.mTown = string;
    }

    public String getVillage() {
        return this.mVillage;
    }

    public void setVillage(String string) {
        this.mVillage = string;
    }

    public long getTownId() {
        return this.mTownId;
    }

    public void setTownId(long l2) {
        this.mTownId = l2;
    }

    public long getVillageId() {
        return this.mVillageId;
    }

    public void setVillageId(long l2) {
        this.mVillageId = l2;
    }

    @Deprecated
    public String getCityCode() {
        return this.mCityCode;
    }

    public void setCityCode(String string) {
        this.mCityCode = string;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public void setLatitude(double d2) {
        super.setLatitude(d2);
        this.mLatitude = d2;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public void setLongitude(double d2) {
        super.setLongitude(d2);
        this.mLongitude = d2;
    }

    public String getStreet() {
        return this.mStreet;
    }

    public void setStreet(String string) {
        this.mStreet = string;
    }

    public String getStreetNum() {
        return this.mStreetNum;
    }

    public void setStreetNum(String string) {
        this.mStreetNum = string;
    }

    public String getFloor() {
        return this.mFloor;
    }

    public void setFloor(String string) {
        this.mFloor = string;
    }

    public long getLocationMs() {
        return this.mLocationMs;
    }

    public void setLocationMs(long l2) {
        this.mLocationMs = l2;
    }

    public void setThirdPartLocation(Location location) {
        this.mThirdPartLocation = location;
    }

    public Location getThirdPartLocation() {
        return this.mThirdPartLocation;
    }

    public String getLocationSDKName() {
        return this.mLocationSDKName;
    }

    public void setLocationSDKName(String string) {
        this.mLocationSDKName = string;
    }

    public void setGCJ02(BDPoint bDPoint) {
        this.mGCJ02 = bDPoint;
    }

    public BDPoint getGCJ02() {
        return this.mGCJ02;
    }

    public String getPoi() {
        return this.mPoi;
    }

    public void setPoi(String string) {
        this.mPoi = string;
    }

    public int getLocationType() {
        return this.mLocationType;
    }

    public void setLocationType(int n2) {
        this.mLocationType = n2;
    }

    public boolean isCache() {
        return this.isCache;
    }

    public void setCache(boolean bl2) {
        this.isCache = bl2;
    }

    public String getCountryCode() {
        return this.mCountryCode;
    }

    public void setCountryCode(String string) {
        this.mCountryCode = string;
    }

    public String getLocalID() {
        return this.mLocalID;
    }

    public void setLocalID(String string) {
        this.mLocalID = string;
    }

    public String getGeoNameID() {
        return this.mGeoNameID;
    }

    public void setGeoNameID(String string) {
        this.mGeoNameID = string;
    }

    public z getBdLBSResult() {
        return this.mBdLBSResult;
    }

    public void setBdLBSResult(z z2) {
        this.mBdLBSResult = z2;
    }

    public an getLocationResult() {
        return this.mLocationResult;
    }

    public void setLocationResult(an an2) {
        this.mLocationResult = an2;
    }

    public String getGeocodeSDKName() {
        return this.mGeocodeSDKName;
    }

    public void setGeocodeSDKName(String string) {
        this.mGeocodeSDKName = string;
    }

    public String getAoi() {
        return this.mAoi;
    }

    public void setAoi(String string) {
        this.mAoi = string;
    }

    public boolean getIsDisputed() {
        return this.mIsDisputed;
    }

    public void setIsDisputed(boolean bl2) {
        this.mIsDisputed = bl2;
    }

    public boolean getIsCompliance() {
        return this.mIsCompliance;
    }

    public void setIsCompliance(boolean bl2) {
        this.mIsCompliance = bl2;
    }

    public String getCoordinateSystem() {
        return this.mCoordinateSystem;
    }

    public void setCoordinateSystem(String string) {
        this.mCoordinateSystem = string;
    }

    public BDLocationException getLocationException() {
        return this.mLocationException;
    }

    public void setLocationException(BDLocationException bDLocationException) {
        this.mLocationException = bDLocationException;
    }

    public String getCountryAsciName() {
        return this.mCountryAsciName;
    }

    public void setCountryAsciName(String string) {
        this.mCountryAsciName = string;
    }

    public String getSubdivisionAsciName() {
        return this.mSubdivisionAsciName;
    }

    public void setSubdivisionAsciName(String string) {
        this.mSubdivisionAsciName = string;
    }

    public String getCityAsciName() {
        return this.mCityAsciName;
    }

    public void setCityAsciName(String string) {
        this.mCityAsciName = string;
    }

    public String getDistrictAsciName() {
        return this.mDistrictAsciName;
    }

    public void setDistrictAsciName(String string) {
        this.mDistrictAsciName = string;
    }

    public String getTownAsciName() {
        return this.mTownAsciName;
    }

    public void setTownAsciName(String string) {
        this.mTownAsciName = string;
    }

    public String getVillageAsciName() {
        return this.mVillageAsciName;
    }

    public void setVillageAsciName(String string) {
        this.mVillageAsciName = string;
    }

    public String toString() {
        String string;
        try {
            string = this.mThirdPartLocation.toString();
        }
        catch (Exception exception) {
            string = "error toString()";
        }
        return "BDLocation{mAddress='" + this.mAddress + '\'' + ", mCountry='" + this.mCountry + '\'' + ", mAdministrativeArea='" + this.mAdministrativeArea + '\'' + ", mSubAdministrativeArea='" + this.mSubAdministrativeArea + '\'' + ", mCity='" + this.mCity + '\'' + ", mDistrict='" + this.mDistrict + '\'' + ", mTown='" + this.mTown + '\'' + ", mVillage='" + this.mVillage + '\'' + ", mCityCode='" + this.mCityCode + '\'' + ", mLatitude=" + this.mLatitude + ", mLongitude=" + this.mLongitude + ", mStreet='" + this.mStreet + '\'' + ", mStreetNum='" + this.mStreetNum + '\'' + ", mFloor='" + this.mFloor + '\'' + ", mLocationMs=" + this.mLocationMs + ", mThirdPartLocation=" + string + ", mLocationSDKName='" + this.mLocationSDKName + '\'' + ", mPoi='" + this.mPoi + '\'' + ", mGCJ02=" + this.mGCJ02 + ", mLocationType=" + this.mLocationType + ", isCache=" + this.isCache + ", mCountryCode=" + this.mCountryCode + ", mLocalID='" + this.mLocalID + '\'' + ", mGeoNameID='" + this.mGeoNameID + '\'' + ", mSubdivisionId='" + this.mSubdivisionId + '\'' + ", mBdLBSResult=" + this.mBdLBSResult + ", mGeocodeSDKName='" + this.mGeocodeSDKName + '\'' + ", mAoi='" + this.mAoi + '\'' + ", mIsDisputed='" + this.mIsDisputed + '\'' + ", mIsCompliance='" + this.mIsCompliance + '\'' + ", mCoordinateSystem='" + this.mCoordinateSystem + '\'' + '}';
    }

    public boolean isEmpty() {
        return Double.compare(this.mLatitude, 0.0) == 0 && Double.compare(this.mLongitude, 0.0) == 0 && TextUtils.isEmpty((CharSequence)this.mAddress) && TextUtils.isEmpty((CharSequence)this.mCountry) && TextUtils.isEmpty((CharSequence)this.mAdministrativeArea) && TextUtils.isEmpty((CharSequence)this.mSubAdministrativeArea) && TextUtils.isEmpty((CharSequence)this.mCity) && TextUtils.isEmpty((CharSequence)this.mDistrict);
    }

    public boolean hasAddress() {
        return !TextUtils.isEmpty((CharSequence)this.mAddress) || !TextUtils.isEmpty((CharSequence)this.mCountry) || !TextUtils.isEmpty((CharSequence)this.mAdministrativeArea) || !TextUtils.isEmpty((CharSequence)this.mSubAdministrativeArea) || !TextUtils.isEmpty((CharSequence)this.mCity) || !TextUtils.isEmpty((CharSequence)this.mDistrict);
    }

    public boolean hasLBSResult() {
        return this.mBdLBSResult != null;
    }

    private int transProvider(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0;
        }
        if ("gps".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("network".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("bd_lbs".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("lbs".equalsIgnoreCase(string)) {
            return 4;
        }
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LocationSDK {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LocationType {
    }
}

