/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.module.location.impl.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.ResultReceiver;
import com.bytedance.ttgame.framework.module.util.PermissionUtil;
import com.bytedance.ttgame.module.location.impl.LocationService;
import com.bytedance.ttgame.module.location.impl.permission.ProxyPermissionActivity;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u001a\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/bytedance/ttgame/module/location/impl/permission/LocationPermissionUtil;", "", "()V", "checkAndRequest", "", "activity", "Landroid/app/Activity;", "permissions", "", "", "callback", "Lkotlin/Function2;", "", "(Landroid/app/Activity;[Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "LocationPermissionReceiver", "optional_location_impl_i18nRelease"})
public final class LocationPermissionUtil {
    public static final LocationPermissionUtil a;

    public final void a(@NotNull Activity activity, @NotNull String[] stringArray, @NotNull Function2<? super Boolean, ? super String, Unit> function2) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"permissions");
        Intrinsics.checkParameterIsNotNull(function2, (String)"callback");
        if (PermissionUtil.hasPermissions((Activity)activity, (String[])stringArray)) {
            function2.invoke((Object)true, null);
        } else {
            Timber.tag((String)LocationService.TAG).v("Location: prepare to request permission.", new Object[0]);
            Intent intent = new Intent((Context)activity, ProxyPermissionActivity.class);
            LocationPermissionReceiver locationPermissionReceiver = new LocationPermissionReceiver(stringArray, function2);
            intent.putExtra("permissions", stringArray);
            intent.putExtra("result_receiver", (Parcelable)locationPermissionReceiver);
            activity.startActivity(intent);
        }
    }

    private LocationPermissionUtil() {
    }

    static {
        LocationPermissionUtil locationPermissionUtil;
        a = locationPermissionUtil = new LocationPermissionUtil();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R%\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/bytedance/ttgame/module/location/impl/permission/LocationPermissionUtil$LocationPermissionReceiver;", "Landroid/os/ResultReceiver;", "mPermissions", "", "", "callback", "Lkotlin/Function2;", "", "", "([Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getCallback", "()Lkotlin/jvm/functions/Function2;", "getMPermissions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "onReceiveResult", "resultCode", "", "resultData", "Landroid/os/Bundle;", "optional_location_impl_i18nRelease"})
    static final class LocationPermissionReceiver
    extends ResultReceiver {
        @NotNull
        private final String[] mPermissions;
        @NotNull
        private final Function2<Boolean, String, Unit> callback;

        protected void onReceiveResult(int n2, @NotNull Bundle bundle) {
            Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"resultData");
            if (n2 == 10011) {
                for (String string : this.mPermissions) {
                    int n3 = bundle.getInt(string);
                    if (n3 == 0) continue;
                    Timber.tag((String)LocationService.TAG).v("Location: doesn't grant " + string + " permission", new Object[0]);
                    this.callback.invoke((Object)false, (Object)string);
                    return;
                }
                this.callback.invoke((Object)true, null);
            }
        }

        @NotNull
        public final String[] getMPermissions() {
            return this.mPermissions;
        }

        @NotNull
        public final Function2<Boolean, String, Unit> getCallback() {
            return this.callback;
        }

        public LocationPermissionReceiver(@NotNull String[] stringArray, @NotNull Function2<? super Boolean, ? super String, Unit> function2) {
            Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"mPermissions");
            Intrinsics.checkParameterIsNotNull(function2, (String)"callback");
            super(new Handler(Looper.getMainLooper()));
            this.mPermissions = stringArray;
            this.callback = function2;
        }
    }
}

