/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.rocketapi;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.bytedance.ttgame.main.internal.CoreDataModel;
import com.bytedance.ttgame.rocketapi.IRocketCnApi;
import com.bytedance.ttgame.rocketapi.R;
import com.bytedance.ttgame.rocketapi.RocketCn;

public abstract class SplashActivity
extends Activity {
    private static final int SPLASH_SCREEN_LENGTH = 2000;
    private Handler handler;
    private Runnable runnable;
    private CoreDataModel mCoreDataModel;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.mCoreDataModel = RocketCn.getInstance().getComponent(IRocketCnApi.class).getCoreData();
        if (this.mCoreDataModel.hasSplash) {
            this.setContentView(R.layout.activity_splash);
        }
        this.handler = new Handler();
        this.runnable = this::onSplashStop;
    }

    protected void onSplashStop() {
        Intent intent = new Intent();
        CoreDataModel coreDataModel = RocketCn.getInstance().getComponent(IRocketCnApi.class).getCoreData();
        String className = TextUtils.isEmpty((CharSequence)coreDataModel.launchActivityName) ? coreDataModel.mainActivityName : coreDataModel.launchActivityName;
        intent.setClassName((Context)this, className);
        intent.setData(this.getIntent().getData());
        if (this.getIntent().getExtras() != null) {
            intent.putExtras(this.getIntent().getExtras());
        }
        this.startActivity(intent);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    protected void onResume() {
        super.onResume();
        if (this.mCoreDataModel == null) {
            this.mCoreDataModel = RocketCn.getInstance().getComponent(IRocketCnApi.class).getCoreData();
        }
        if (this.mCoreDataModel.hasSplash) {
            this.handler.postDelayed(this.runnable, this.mCoreDataModel.splashLength == 0 ? 2000L : (long)this.mCoreDataModel.splashLength);
        } else {
            this.onSplashStop();
        }
    }

    protected void onPause() {
        super.onPause();
        this.handler.removeCallbacks(this.runnable);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.handler.removeCallbacks(this.runnable);
    }

    protected void onStop() {
        super.onStop();
        this.handler.removeCallbacks(this.runnable);
    }
}

