/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.module.database.api;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.bytedance.ttgame.module.database.api.ConnectInfoData;
import com.bytedance.ttgame.module.database.api.ConnectListConverter;
import com.bytedance.ttgame.module.database.api.EncryptionMark;
import com.bytedance.ttgame.module.database.api.NeedEncryption;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@NeedEncryption
@Entity(tableName="user_info")
@Keep
public class UserInfoData
implements Serializable,
Cloneable {
    @SerializedName(value="user_id")
    @PrimaryKey
    @ColumnInfo(name="user_id")
    @NonNull
    public long userId;
    @SerializedName(value="nickname")
    @NeedEncryption
    @ColumnInfo(name="nickname")
    public String nickname;
    @SerializedName(value="avatar_url")
    @NeedEncryption
    @ColumnInfo(name="avatar_url")
    public String avatarUrl;
    @SerializedName(value="token")
    @NeedEncryption
    @ColumnInfo(name="token")
    public String token;
    @SerializedName(value="is_verified")
    @ColumnInfo(name="is_verified")
    public boolean isVerified;
    @SerializedName(value="user_type")
    @ColumnInfo(name="user_type")
    public int userType;
    @SerializedName(value="is_pay")
    @ColumnInfo(name="is_pay")
    public boolean isPay;
    @SerializedName(value="is_bound")
    @ColumnInfo(name="is_bound")
    public boolean isBound;
    @SerializedName(value="login_time")
    @ColumnInfo(name="login_time")
    public long loginTime;
    @SerializedName(value="has_pwd")
    @ColumnInfo(name="has_pwd")
    public boolean hasPwd;
    @SerializedName(value="mobile")
    @ColumnInfo(name="mobile")
    public String mobile;
    @SerializedName(value="sdk_open_id")
    @ColumnInfo(name="sdk_open_id")
    public String sdkOpenId;
    @NeedEncryption
    @ColumnInfo(name="tt_user_id")
    public long ttUserId;
    @NeedEncryption
    @ColumnInfo(name="email")
    public String email;
    @NeedEncryption
    @ColumnInfo(name="aweme_name")
    public String awemeName;
    @ColumnInfo(name="aweme_is_new")
    public boolean isAwemeNew = true;
    @NeedEncryption
    @ColumnInfo(name="toutiao_name")
    public String toutiaoName;
    @ColumnInfo(name="toutiao_is_new")
    public boolean isToutiaoNew = true;
    @ColumnInfo(name="can_bind_visitor")
    public boolean canBindVisitor = true;
    @ColumnInfo(name="login_way")
    public int loginWay;
    @SerializedName(value="connect_infos")
    @NeedEncryption
    @TypeConverters(value={ConnectListConverter.class})
    @ColumnInfo(name="connect_infos")
    public List<ConnectInfoData> connect_infos;
    @NeedEncryption
    @ColumnInfo(name="aweme_sec_platform_uid")
    public String awemeSecPlatformUid;
    @SerializedName(value="client_uuid")
    @NeedEncryption
    @ColumnInfo(name="uuid")
    public String uuid;
    @SerializedName(value="multi_bind_status")
    @ColumnInfo(name="multi_bind_status")
    public boolean multiBindStatus;
    @SerializedName(value="conflict_user_id")
    @ColumnInfo(name="conflict_user_id")
    public long conflictUserId;
    @ColumnInfo(name="is_sc_login")
    public int isScLogin;
    @SerializedName(value="account_code")
    @ColumnInfo(name="account_code")
    public String accountCode;
    @SerializedName(value="encrypted")
    @EncryptionMark
    @ColumnInfo(name="encrypted")
    public boolean encrypted = false;
    @SerializedName(value="huoshan_name")
    @NeedEncryption
    @ColumnInfo(name="huoshan_name")
    public String huoshanName;

    public String toString() {
        return "UserInfoData{userId=" + this.userId + ", nickname='" + this.nickname + '\'' + ", avatarUrl='" + this.avatarUrl + '\'' + ", token='" + this.token + '\'' + ", isVerified=" + this.isVerified + ", userType=" + this.userType + ", isPay=" + this.isPay + ", isBound=" + this.isBound + ", loginTime=" + this.loginTime + ", userUniqueId='" + this.sdkOpenId + '\'' + ", ttUserId=" + this.ttUserId + ", loginTime=" + this.sdkOpenId + ", email=" + this.email + ", awemeName=" + this.awemeName + ", toutiaoName=" + this.toutiaoName + ", isAwemeNew=" + this.isAwemeNew + ", isToutiaoNew=" + this.isToutiaoNew + ", canBindVisitor=" + this.canBindVisitor + ", login_way=" + this.loginWay + ", connect_infos=" + this.connect_infos + ", awemeSecPlatformUid=" + this.awemeSecPlatformUid + ", uuid='" + this.uuid + '\'' + ", multiBindStatus =" + this.multiBindStatus + ", conflictUserId =" + this.conflictUserId + ", isScLogin =" + this.isScLogin + ", encrypted =" + this.encrypted + ", huoshanName =" + this.huoshanName + '}';
    }

    @NonNull
    public UserInfoData clone() throws CloneNotSupportedException {
        UserInfoData newObject = (UserInfoData)super.clone();
        ArrayList<ConnectInfoData> connectInfoData = new ArrayList<ConnectInfoData>();
        if (this.connect_infos != null) {
            for (ConnectInfoData connectInfo : this.connect_infos) {
                connectInfoData.add(connectInfo.clone());
            }
        } else {
            connectInfoData = null;
        }
        newObject.connect_infos = connectInfoData;
        return newObject;
    }
}

