/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.module.database.api;

import android.text.TextUtils;
import androidx.room.TypeConverter;
import com.bytedance.ttgame.sdk.module.utils.NumberUtils;
import java.util.ArrayList;
import java.util.List;
import timber.log.Timber;

public class ListConverter {
    @TypeConverter
    public static List<Integer> stringToIntegerList(String data) {
        if (TextUtils.isEmpty((CharSequence)data)) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] strings = data.split(",");
        for (int i = 0; i < strings.length; ++i) {
            try {
                list.add(NumberUtils.getInteger((String)strings[i], (int)-1));
                continue;
            }
            catch (Exception e) {
                Timber.tag((String)"gsdk_converter").d((Throwable)e);
            }
        }
        return list;
    }

    @TypeConverter
    public static String integerListToString(List<Integer> integerList) {
        if (integerList == null || integerList.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < integerList.size(); ++i) {
            if (i == integerList.size() - 1) {
                sb.append(integerList.get(i));
                continue;
            }
            sb.append(integerList.get(i)).append(",");
        }
        return sb.toString();
    }

    @TypeConverter
    public static List<String> stringToStringList(String data) {
        if (TextUtils.isEmpty((CharSequence)data)) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] strings = data.split(",");
        for (int i = 0; i < strings.length; ++i) {
            try {
                list.add(strings[i]);
                continue;
            }
            catch (Exception e) {
                Timber.tag((String)"gsdk_converter").d((Throwable)e);
            }
        }
        return list;
    }

    @TypeConverter
    public static String stringListToString(List<String> data) {
        if (data == null || data.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            if (i == data.size() - 1) {
                sb.append(data.get(i));
                continue;
            }
            sb.append(data.get(i)).append(",");
        }
        return sb.toString();
    }
}

