/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.module.database.api;

import android.text.TextUtils;
import androidx.room.TypeConverter;
import com.bytedance.ttgame.module.database.api.ConnectInfoData;
import com.bytedance.ttgame.sdk.module.utils.AesCbcUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import timber.log.Timber;

public class ConnectListConverter {
    @TypeConverter
    public static List<ConnectInfoData> stringToconnectInfoDataList(String data) {
        if (TextUtils.isEmpty((CharSequence)data)) {
            return new ArrayList<ConnectInfoData>();
        }
        ArrayList<ConnectInfoData> list = new ArrayList<ConnectInfoData>();
        String[] strings = data.split(";");
        boolean needDecrypt = false;
        if (strings.length > 0 && strings[0].equals("encrypted")) {
            needDecrypt = true;
        }
        for (int i = 0; i < strings.length; ++i) {
            try {
                if (needDecrypt && i == 0) continue;
                String str = needDecrypt ? AesCbcUtils.decrypt((String)strings[i]) : strings[i];
                list.add((ConnectInfoData)new Gson().fromJson(str, ConnectInfoData.class));
                continue;
            }
            catch (Exception e) {
                Timber.tag((String)"gsdk_converter").d((Throwable)e);
            }
        }
        return list;
    }

    @TypeConverter
    public static String connectInfoDataListToString(List<ConnectInfoData> connectInfoDataList) {
        if (connectInfoDataList == null || connectInfoDataList.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("encrypted;");
        try {
            for (int i = 0; i < connectInfoDataList.size(); ++i) {
                if (i == connectInfoDataList.size() - 1) {
                    sb.append(AesCbcUtils.encrypt((String)new Gson().toJson((Object)connectInfoDataList.get(i))));
                    continue;
                }
                sb.append(AesCbcUtils.encrypt((String)new Gson().toJson((Object)connectInfoDataList.get(i)))).append(";");
            }
        }
        catch (Exception e) {
            Timber.tag((String)"gsdk_converter").d((Throwable)e);
        }
        return sb.toString();
    }
}

