/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.module.database.api;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.bytedance.ttgame.module.database.api.ConnectListConverter;
import com.bytedance.ttgame.module.database.api.UserInfoDao;
import com.bytedance.ttgame.module.database.api.UserInfoData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class UserInfoDao_Impl
implements UserInfoDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserInfoData> __insertionAdapterOfUserInfoData;
    private final EntityDeletionOrUpdateAdapter<UserInfoData> __deletionAdapterOfUserInfoData;

    public UserInfoDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserInfoData = new EntityInsertionAdapter<UserInfoData>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user_info` (`user_id`,`nickname`,`avatar_url`,`token`,`is_verified`,`user_type`,`is_pay`,`is_bound`,`login_time`,`has_pwd`,`mobile`,`sdk_open_id`,`tt_user_id`,`email`,`aweme_name`,`aweme_is_new`,`toutiao_name`,`toutiao_is_new`,`can_bind_visitor`,`login_way`,`connect_infos`,`aweme_sec_platform_uid`,`uuid`,`multi_bind_status`,`conflict_user_id`,`is_sc_login`,`account_code`,`encrypted`,`huoshan_name`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserInfoData value) {
                stmt.bindLong(1, value.userId);
                if (value.nickname == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.nickname);
                }
                if (value.avatarUrl == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.avatarUrl);
                }
                if (value.token == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.token);
                }
                int _tmp = value.isVerified ? 1 : 0;
                stmt.bindLong(5, (long)_tmp);
                stmt.bindLong(6, (long)value.userType);
                int _tmp_1 = value.isPay ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_1);
                int _tmp_2 = value.isBound ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_2);
                stmt.bindLong(9, value.loginTime);
                int _tmp_3 = value.hasPwd ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_3);
                if (value.mobile == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.mobile);
                }
                if (value.sdkOpenId == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.sdkOpenId);
                }
                stmt.bindLong(13, value.ttUserId);
                if (value.email == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.email);
                }
                if (value.awemeName == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.awemeName);
                }
                int _tmp_4 = value.isAwemeNew ? 1 : 0;
                stmt.bindLong(16, (long)_tmp_4);
                if (value.toutiaoName == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.toutiaoName);
                }
                int _tmp_5 = value.isToutiaoNew ? 1 : 0;
                stmt.bindLong(18, (long)_tmp_5);
                int _tmp_6 = value.canBindVisitor ? 1 : 0;
                stmt.bindLong(19, (long)_tmp_6);
                stmt.bindLong(20, (long)value.loginWay);
                String _tmp_7 = ConnectListConverter.connectInfoDataListToString(value.connect_infos);
                if (_tmp_7 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_7);
                }
                if (value.awemeSecPlatformUid == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.awemeSecPlatformUid);
                }
                if (value.uuid == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, value.uuid);
                }
                int _tmp_8 = value.multiBindStatus ? 1 : 0;
                stmt.bindLong(24, (long)_tmp_8);
                stmt.bindLong(25, value.conflictUserId);
                stmt.bindLong(26, (long)value.isScLogin);
                if (value.accountCode == null) {
                    stmt.bindNull(27);
                } else {
                    stmt.bindString(27, value.accountCode);
                }
                int _tmp_9 = value.encrypted ? 1 : 0;
                stmt.bindLong(28, (long)_tmp_9);
                if (value.huoshanName == null) {
                    stmt.bindNull(29);
                } else {
                    stmt.bindString(29, value.huoshanName);
                }
            }
        };
        this.__deletionAdapterOfUserInfoData = new EntityDeletionOrUpdateAdapter<UserInfoData>(__db){

            public String createQuery() {
                return "DELETE FROM `user_info` WHERE `user_id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserInfoData value) {
                stmt.bindLong(1, value.userId);
            }
        };
    }

    @Override
    public void insertUserInfo(UserInfoData userInfo) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUserInfoData.insert((Object)userInfo);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAccount(UserInfoData userInfoData) {
        this.__db.assertNotSuspendingTransaction();
        int _total = 0;
        this.__db.beginTransaction();
        try {
            this.__db.setTransactionSuccessful();
            int n = _total += this.__deletionAdapterOfUserInfoData.handle((Object)userInfoData);
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public LiveData<List<UserInfoData>> getHistoryAccount() {
        String _sql = "select * from user_info order by login_time desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from user_info order by login_time desc", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"user_info"}, false, (Callable)new Callable<List<UserInfoData>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<UserInfoData> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserInfoDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_id");
                    int _cursorIndexOfNickname = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nickname");
                    int _cursorIndexOfAvatarUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatar_url");
                    int _cursorIndexOfToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"token");
                    int _cursorIndexOfIsVerified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_verified");
                    int _cursorIndexOfUserType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_type");
                    int _cursorIndexOfIsPay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_pay");
                    int _cursorIndexOfIsBound = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_bound");
                    int _cursorIndexOfLoginTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"login_time");
                    int _cursorIndexOfHasPwd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"has_pwd");
                    int _cursorIndexOfMobile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mobile");
                    int _cursorIndexOfSdkOpenId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sdk_open_id");
                    int _cursorIndexOfTtUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tt_user_id");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfAwemeName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aweme_name");
                    int _cursorIndexOfIsAwemeNew = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aweme_is_new");
                    int _cursorIndexOfToutiaoName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toutiao_name");
                    int _cursorIndexOfIsToutiaoNew = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toutiao_is_new");
                    int _cursorIndexOfCanBindVisitor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"can_bind_visitor");
                    int _cursorIndexOfLoginWay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"login_way");
                    int _cursorIndexOfConnectInfos = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connect_infos");
                    int _cursorIndexOfAwemeSecPlatformUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aweme_sec_platform_uid");
                    int _cursorIndexOfUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uuid");
                    int _cursorIndexOfMultiBindStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multi_bind_status");
                    int _cursorIndexOfConflictUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conflict_user_id");
                    int _cursorIndexOfIsScLogin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_sc_login");
                    int _cursorIndexOfAccountCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_code");
                    int _cursorIndexOfEncrypted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encrypted");
                    int _cursorIndexOfHuoshanName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"huoshan_name");
                    ArrayList<UserInfoData> _result = new ArrayList<UserInfoData>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        UserInfoData _item = new UserInfoData();
                        _item.userId = _cursor.getLong(_cursorIndexOfUserId);
                        _item.nickname = _cursor.getString(_cursorIndexOfNickname);
                        _item.avatarUrl = _cursor.getString(_cursorIndexOfAvatarUrl);
                        _item.token = _cursor.getString(_cursorIndexOfToken);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                        _item.isVerified = _tmp != 0;
                        _item.userType = _cursor.getInt(_cursorIndexOfUserType);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPay);
                        _item.isPay = _tmp_1 != 0;
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsBound);
                        _item.isBound = _tmp_2 != 0;
                        _item.loginTime = _cursor.getLong(_cursorIndexOfLoginTime);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfHasPwd);
                        _item.hasPwd = _tmp_3 != 0;
                        _item.mobile = _cursor.getString(_cursorIndexOfMobile);
                        _item.sdkOpenId = _cursor.getString(_cursorIndexOfSdkOpenId);
                        _item.ttUserId = _cursor.getLong(_cursorIndexOfTtUserId);
                        _item.email = _cursor.getString(_cursorIndexOfEmail);
                        _item.awemeName = _cursor.getString(_cursorIndexOfAwemeName);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfIsAwemeNew);
                        _item.isAwemeNew = _tmp_4 != 0;
                        _item.toutiaoName = _cursor.getString(_cursorIndexOfToutiaoName);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfIsToutiaoNew);
                        _item.isToutiaoNew = _tmp_5 != 0;
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfCanBindVisitor);
                        _item.canBindVisitor = _tmp_6 != 0;
                        _item.loginWay = _cursor.getInt(_cursorIndexOfLoginWay);
                        String _tmp_7 = _cursor.getString(_cursorIndexOfConnectInfos);
                        _item.connect_infos = ConnectListConverter.stringToconnectInfoDataList(_tmp_7);
                        _item.awemeSecPlatformUid = _cursor.getString(_cursorIndexOfAwemeSecPlatformUid);
                        _item.uuid = _cursor.getString(_cursorIndexOfUuid);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfMultiBindStatus);
                        _item.multiBindStatus = _tmp_8 != 0;
                        _item.conflictUserId = _cursor.getLong(_cursorIndexOfConflictUserId);
                        _item.isScLogin = _cursor.getInt(_cursorIndexOfIsScLogin);
                        _item.accountCode = _cursor.getString(_cursorIndexOfAccountCode);
                        int _tmp_9 = _cursor.getInt(_cursorIndexOfEncrypted);
                        _item.encrypted = _tmp_9 != 0;
                        _item.huoshanName = _cursor.getString(_cursorIndexOfHuoshanName);
                        _result.add(_item);
                    }
                    ArrayList<UserInfoData> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserInfoData> getHistoryAccountByThread() {
        String _sql = "select * from user_info order by login_time desc";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from user_info order by login_time desc", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_id");
            int _cursorIndexOfNickname = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nickname");
            int _cursorIndexOfAvatarUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatar_url");
            int _cursorIndexOfToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"token");
            int _cursorIndexOfIsVerified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_verified");
            int _cursorIndexOfUserType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_type");
            int _cursorIndexOfIsPay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_pay");
            int _cursorIndexOfIsBound = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_bound");
            int _cursorIndexOfLoginTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"login_time");
            int _cursorIndexOfHasPwd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"has_pwd");
            int _cursorIndexOfMobile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mobile");
            int _cursorIndexOfSdkOpenId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sdk_open_id");
            int _cursorIndexOfTtUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tt_user_id");
            int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
            int _cursorIndexOfAwemeName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aweme_name");
            int _cursorIndexOfIsAwemeNew = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aweme_is_new");
            int _cursorIndexOfToutiaoName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toutiao_name");
            int _cursorIndexOfIsToutiaoNew = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toutiao_is_new");
            int _cursorIndexOfCanBindVisitor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"can_bind_visitor");
            int _cursorIndexOfLoginWay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"login_way");
            int _cursorIndexOfConnectInfos = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connect_infos");
            int _cursorIndexOfAwemeSecPlatformUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aweme_sec_platform_uid");
            int _cursorIndexOfUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uuid");
            int _cursorIndexOfMultiBindStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multi_bind_status");
            int _cursorIndexOfConflictUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conflict_user_id");
            int _cursorIndexOfIsScLogin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_sc_login");
            int _cursorIndexOfAccountCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_code");
            int _cursorIndexOfEncrypted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encrypted");
            int _cursorIndexOfHuoshanName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"huoshan_name");
            ArrayList<UserInfoData> _result = new ArrayList<UserInfoData>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                UserInfoData _item = new UserInfoData();
                _item.userId = _cursor.getLong(_cursorIndexOfUserId);
                _item.nickname = _cursor.getString(_cursorIndexOfNickname);
                _item.avatarUrl = _cursor.getString(_cursorIndexOfAvatarUrl);
                _item.token = _cursor.getString(_cursorIndexOfToken);
                int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                _item.isVerified = _tmp != 0;
                _item.userType = _cursor.getInt(_cursorIndexOfUserType);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPay);
                _item.isPay = _tmp_1 != 0;
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsBound);
                _item.isBound = _tmp_2 != 0;
                _item.loginTime = _cursor.getLong(_cursorIndexOfLoginTime);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfHasPwd);
                _item.hasPwd = _tmp_3 != 0;
                _item.mobile = _cursor.getString(_cursorIndexOfMobile);
                _item.sdkOpenId = _cursor.getString(_cursorIndexOfSdkOpenId);
                _item.ttUserId = _cursor.getLong(_cursorIndexOfTtUserId);
                _item.email = _cursor.getString(_cursorIndexOfEmail);
                _item.awemeName = _cursor.getString(_cursorIndexOfAwemeName);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfIsAwemeNew);
                _item.isAwemeNew = _tmp_4 != 0;
                _item.toutiaoName = _cursor.getString(_cursorIndexOfToutiaoName);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfIsToutiaoNew);
                _item.isToutiaoNew = _tmp_5 != 0;
                int _tmp_6 = _cursor.getInt(_cursorIndexOfCanBindVisitor);
                _item.canBindVisitor = _tmp_6 != 0;
                _item.loginWay = _cursor.getInt(_cursorIndexOfLoginWay);
                String _tmp_7 = _cursor.getString(_cursorIndexOfConnectInfos);
                _item.connect_infos = ConnectListConverter.stringToconnectInfoDataList(_tmp_7);
                _item.awemeSecPlatformUid = _cursor.getString(_cursorIndexOfAwemeSecPlatformUid);
                _item.uuid = _cursor.getString(_cursorIndexOfUuid);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfMultiBindStatus);
                _item.multiBindStatus = _tmp_8 != 0;
                _item.conflictUserId = _cursor.getLong(_cursorIndexOfConflictUserId);
                _item.isScLogin = _cursor.getInt(_cursorIndexOfIsScLogin);
                _item.accountCode = _cursor.getString(_cursorIndexOfAccountCode);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfEncrypted);
                _item.encrypted = _tmp_9 != 0;
                _item.huoshanName = _cursor.getString(_cursorIndexOfHuoshanName);
                _result.add(_item);
            }
            ArrayList<UserInfoData> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

