/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.main.internal.net;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bytedance.ttgame.framework.module.util.Objects;

public class Resource<T> {
    @NonNull
    public final Status status;
    @Nullable
    public final T data;
    @Nullable
    public final String message;
    @Nullable
    public final String logId;

    public String toString() {
        return "Resource{status=" + (Object)((Object)this.status) + ", data=" + this.data + ", message='" + this.message + '\'' + ", logId=" + this.logId + '}';
    }

    private Resource(@NonNull Status status, @Nullable T data, @Nullable String message, @Nullable String logId) {
        this.status = status;
        this.data = data;
        this.message = message;
        this.logId = logId;
    }

    public static <T> Resource<T> success(@NonNull T data) {
        return new Resource<T>(Status.SUCCESS, data, null, null);
    }

    public static <T> Resource<T> success(@NonNull T data, @Nullable String logId) {
        return new Resource<T>(Status.SUCCESS, data, null, logId);
    }

    public static <T> Resource<T> error(String msg, @Nullable T data) {
        return new Resource<T>(Status.ERROR, data, msg, null);
    }

    public static <T> Resource<T> error(String msg, @Nullable T data, @Nullable String logId) {
        return new Resource<T>(Status.ERROR, data, msg, logId);
    }

    public static <T> Resource<T> loading(@Nullable T data) {
        return new Resource<T>(Status.LOADING, data, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return this.status == resource.status && Objects.equals(this.data, resource.data) && Objects.equals((Object)this.message, (Object)resource.message) && Objects.equals((Object)this.logId, (Object)resource.logId);
    }

    public int hashCode() {
        return Objects.hash((Object[])new Object[]{this.status, this.data, this.message, this.logId});
    }

    public static enum Status {
        SUCCESS,
        ERROR,
        LOADING;

    }
}

