/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.main.internal.net;

import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import com.bytedance.ttgame.framework.module.util.Objects;
import com.bytedance.ttgame.main.internal.net.ApiResponse;
import com.bytedance.ttgame.main.internal.net.Resource;

public abstract class NetworkOnlyBoundResource<ResultType> {
    private final MediatorLiveData<Resource<ResultType>> result = new MediatorLiveData();

    public NetworkOnlyBoundResource() {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            this.result.setValue(Resource.loading(null));
        } else {
            this.result.postValue(Resource.loading(null));
        }
        this.fetchFromNetwork();
    }

    @MainThread
    private void setValue(Resource<ResultType> newValue) {
        if (!Objects.equals((Object)this.result.getValue(), newValue)) {
            this.result.setValue(newValue);
        }
    }

    private void fetchFromNetwork() {
        LiveData<ApiResponse<ResultType>> apiResponse = this.createCall();
        this.result.addSource(apiResponse, response -> {
            this.result.removeSource(apiResponse);
            if (response != null && response.isSuccessful()) {
                this.setValue(Resource.success(this.processResponse((ApiResponse<ResultType>)response), response.logId));
            } else {
                this.onFetchFailed();
                this.setValue(Resource.error(response.errorMessage, null, response.logId));
            }
        });
    }

    protected void onFetchFailed() {
    }

    public LiveData<Resource<ResultType>> asLiveData() {
        return this.result;
    }

    @WorkerThread
    private ResultType processResponse(ApiResponse<ResultType> response) {
        return (ResultType)response.body;
    }

    @NonNull
    @MainThread
    protected abstract LiveData<ApiResponse<ResultType>> createCall();
}

