/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.main.internal.net;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import com.bytedance.ttgame.framework.module.util.Objects;
import com.bytedance.ttgame.main.internal.net.ApiResponse;
import com.bytedance.ttgame.main.internal.net.Resource;
import java.util.concurrent.ExecutorService;

public abstract class NetworkBoundResource<ResultType, RequestType> {
    private final ExecutorService executor;
    private final ExecutorService main;
    private final MediatorLiveData<Resource<ResultType>> result = new MediatorLiveData();

    @MainThread
    public NetworkBoundResource(ExecutorService executor, ExecutorService main) {
        this.executor = executor;
        this.main = main;
        LiveData<ResultType> dbSource = this.loadFromDb();
        this.result.addSource(dbSource, data -> {
            this.result.removeSource(dbSource);
            if (this.shouldFetch(data)) {
                this.fetchFromNetwork(dbSource);
            } else {
                this.result.addSource(dbSource, newData -> this.setValue(Resource.success(newData)));
            }
        });
    }

    @MainThread
    private void setValue(Resource<ResultType> newValue) {
        if (!Objects.equals((Object)this.result.getValue(), newValue)) {
            this.result.setValue(newValue);
        }
    }

    private void fetchFromNetwork(LiveData<ResultType> dbSource) {
        LiveData<ApiResponse<RequestType>> apiResponse = this.createCall();
        this.result.addSource(dbSource, newData -> this.setValue(Resource.loading(newData)));
        this.result.addSource(apiResponse, response -> {
            this.result.removeSource(apiResponse);
            this.result.removeSource(dbSource);
            if (response.isSuccessful()) {
                this.executor.execute(() -> {
                    this.saveCallResult(this.processResponse((ApiResponse<RequestType>)response));
                    this.main.execute(() -> this.result.addSource(this.loadFromDb(), newData -> this.setValue(Resource.success(newData, response.logId))));
                });
            } else {
                this.onFetchFailed(this.processResponse((ApiResponse<RequestType>)response));
                this.result.addSource(dbSource, newData -> this.setValue(Resource.error(response.errorMessage, newData, response.logId)));
            }
        });
    }

    protected void onFetchFailed(RequestType item) {
    }

    public LiveData<Resource<ResultType>> asLiveData() {
        return this.result;
    }

    @WorkerThread
    protected RequestType processResponse(ApiResponse<RequestType> response) {
        return (RequestType)response.body;
    }

    @WorkerThread
    protected abstract void saveCallResult(@NonNull RequestType var1);

    @MainThread
    protected abstract boolean shouldFetch(@Nullable ResultType var1);

    @NonNull
    @MainThread
    protected abstract LiveData<ResultType> loadFromDb();

    @NonNull
    @MainThread
    protected abstract LiveData<ApiResponse<RequestType>> createCall();
}

