package com.bytedance.ttgame.rocketapi.privacy;

import androidx.annotation.NonNull;

public interface IPermissionReqListener {

    /**
     * 多条权限申请回调
     */
    void onPermissionRequest(boolean isAllGranted, @NonNull String[] permissions, int[] grantResults);

    /**
     * 隐私政策回调
     * @param isNeedVerify 是否需要做隐私政策校验
     * @param verifyResult 如果要，隐私政策校验的结果
     */
    @Deprecated
    default void onPrivacyResult(boolean isNeedVerify, boolean verifyResult){};
}
