package com.bytedance.ttgame.rocketapi.language;

import androidx.annotation.IntDef;
import androidx.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class LanguageType {
    //跟随系统
    public static final String LANGUAGE_SYSTEM = "";
    //英语
    public static final String LANGUAGE_EN = "en";
    //简体中文
    public static final String LANGUAGE_ZH_CN = "zh-Hans";
    //泰语
    public static final String LANGUAGE_TH = "th";
    //繁体中文
    public static final String LANGUAGE_ZH_TW = "zh-Hant";
    //日语
    public static final String LANGUAGE_JA = "ja";
    //韩语
    public static final String LANGUAGE_KO = "ko";
    //阿拉伯语
    public static final String LANGUAGE_AR = "ar";
    //印尼语
    public static final String LANGUAGE_IN = "id";
    //西班牙语
    public static final String LANGUAGE_ES = "es";
    //葡萄牙语
    public static final String LANGUAGE_PT = "pt";
    //越南语
    public static final String LANGUAGE_VI = "vi";
    //俄语
    public static final String LANGUAGE_RU = "ru";
    //土耳其语
    public static final String LANGUAGE_TR = "tr";
    //德语
    public static final String LANGUAGE_DE = "de";
    //法语
    public static final String LANGUAGE_FR = "fr";
    //意大利语
    public static final String LANGUAGE_IT = "it";

    @Retention(RetentionPolicy.SOURCE)
    @StringDef({LANGUAGE_SYSTEM, LANGUAGE_EN, LANGUAGE_ZH_CN, LANGUAGE_TH, LANGUAGE_ZH_TW, LANGUAGE_JA, LANGUAGE_KO,
            LANGUAGE_AR,LANGUAGE_IN,LANGUAGE_ES,LANGUAGE_PT,LANGUAGE_VI,LANGUAGE_RU,LANGUAGE_TR,LANGUAGE_DE,
            LANGUAGE_FR,LANGUAGE_IT})
    public @interface Languages {
    }
}
