package com.bytedance.ttgame.rocketapi.callback;

import androidx.annotation.Keep;
import androidx.annotation.MainThread;

/**
 * 模拟器回调
 * @param <Boolean>
 */
@Keep
public interface IEmulatorCallback<Boolean> {
    /**
     * @Deprecated 该回调函数已经废弃，不推荐使用，推荐使用第二个onSuccess回调，可以返回模拟器品牌
     * @param result
     */
    @Deprecated
    @MainThread
    default void onSuccess(Boolean result){

    }

    @MainThread
    default void onSuccess(Boolean result, String emulatorType){
        onSuccess(result);
    }

    @MainThread
    void onFailed(int errorCode, String errorMsg);
}
