package com.bytedance.ttgame.module.webview.api

import android.content.Context
import android.os.Bundle
import com.bytedance.ttgame.framework.module.spi.IModuleApi

interface IWebViewService : IModuleApi {
    /**
     * 展示webview 会跳转到一个activity展示
     * @param context
     * @param url    webview要展示的链接
     */
    @Deprecated("Deprecated")
    fun showWebView(context: Context?, title: String?, url: String?)

    /**
     * 展示webview 会跳转到一个activity展示
     * @param context
     * @param url    webview要展示的链接
     * @param errorCodeCallback  url格式错误回调
     */
    fun showWebView(context: Context?, title: String?, url: String?, errorCodeCallback: IWebViewErrorCodeCallback)

    /**
     * 展示webview 会跳转到一个activity展示
     * @param context
     * @param url    webview要展示的链接
     * @param bundle 公共参数
     */
    @Deprecated("Deprecated")
    fun showWebView(context: Context?,title: String?, url: String?, bundle: Bundle?)

    /**
     * 展示webview 会跳转到一个activity展示
     * @param context
     * @param url    webview要展示的链接
     * @param bundle 公共参数
     * @param errorCodeCallback url格式错误回调
     */
    fun showWebView(context: Context?,title: String?,url: String?,bundle: Bundle?,errorCodeCallback: IWebViewErrorCodeCallback)

    /**
     * 展示webview 会跳转到一个activity展示 ,退出时调用回调
     * @param context
     * @param url    webview要展示的链接
     * @param bundle 公共参数
     * @param callback 退出 webview 回调
     */
    @Deprecated("Deprecated")
    fun showWebViewWithCallback(context: Context?,title: String?,url: String?,bundle: Bundle?,callback: IExitWebViewCallback?)

    /**
     * 展示webview 会跳转到一个activity展示 ,退出时调用回调
     * @param context
     * @param url    webview要展示的链接
     * @param bundle 公共参数
     * @param callback 退出 webview 回调
     * @param errorCodeCallback url格式错误回调
     */
    fun showWebViewWithCallback(context: Context?, title: String?, url: String?, bundle: Bundle?, callback: IExitWebViewCallback?, errorCodeCallback: IWebViewErrorCodeCallback)
}