package com.bytedance.ttgame.module.secure.api;

import androidx.annotation.Keep;

@Keep
public interface PopCheckCodeCallback {

    final int CLOSE_BY_CLICK_BUTTON = 0;
    final int CLOSE_BY_CLICK_SCREEN = 1;
    final int CLOSE_BY_ESCAPE = 2;

    /**
     * 0 点击"验证码框的关闭按钮"来关闭验证码
     * 1 点击"屏幕"关闭验证码
     * 2 点击"返回键"关闭验证码
     */
    default void dialogOnClose(int type) {
    }


    //验证过程错误, 返回的错误码为判断错误类型的依据
    default void dialogOnError(String error) {
    }

    //验证码加载准备完成, 此时弹出验证码
    default void dialogOnReady() {
    }

    /*
     * bSuccess:是否验证通过
     * result:验证通过后的其他信息
     * */
    default void dialogOnResult(boolean bSuccess, String json) {
    }
}
