package com.bytedance.ttgame.module.secure.api;

import android.app.Activity;
import com.bytedance.ttgame.framework.module.spi.IModuleApi;

/**
 * 安全SDK服务
 *
 * @author wangzhongshan
 * @sine 2019/4/9.
 */
public interface ISecureService extends IModuleApi {

    /**
     * 设置 did 和 iid
     */
    void setParams(String did, String iid);

    /**
     * 设置用户登陆sdkopenid
     *
     */
    void setUserInfo(int userType,String roleId,String serverId);

    /**
     * 设置 sessionId，每次用户登录发生了变化都需要重新传递
     */
    void setSession(String sessionId);

    /**
     * 主动上报用户设备信息
     *
     * @param scene 使用场景
     */
    void reportNow(String scene);

    /**
     * 显示滑块校验
     *
     * @param activity
     * @param lang
     * @param session       用户sessionId 没有可以传空
     * @param challengeCode 服务端返回的错误码
     * @param listener      回调接收
     */
    default void popCheckCode(Activity activity, String lang, String session, int challengeCode, PopCheckCodeCallback listener) {
        //cn使用的功能
    }

    /**
     * 获取GP客户端数据
     *
     * @return
     */
    byte[] getGPPacketData();

    /**
     * 获取GP客户端数据
     * Base64已处理
     *
     * @return
     */
    byte[] getGPPacketText();

    /**
     * 上传数据到GP客户端
     *
     * @param data
     * @return true = 成功
     */
    int uploadPacketData(byte[] data);
    /**
     * 上传数据到GP客户端
     * Base64已处理
     *
     * @param data
     * @return true = 成功
     */
    int uploadPacketText(byte[] data);

    /**
     * 设置性能消耗等级
     * @param priority 1~5 最低~最高性能消耗
     */
    void setPriority(int priority);

    /**
     * 判断是否模拟器(无兜底策略)
     * @param callback
     */
    void isEmulator(ISecureEmulatorCallback callback);

    /**
     * 判断是否模拟器(服务端判断兜底)
     * @param callback
     */
    void isEmulatorBackUp(ISecureEmulatorCallback callback);

    /**
     * 获得判断模拟器的结果
     */
    int getIsEmulatorResult();

    /**
     * 获得模拟器品牌
     */
    String getEmulatorType();

    /**
     * 获取判断模拟器超时剩余时间
     * @return
     */
     long emulatorJudgmentWaitTime();

    /**
     * 判断是否显示游客登录
     * @return
     */
     boolean canShowVisitor();
}
