package com.bytedance.ttgame.module.secure.api;

import androidx.annotation.Keep;

@Keep
public interface ISecureEmulatorCallback {
    /**
     * 获取模拟器信息成功
     * @param isEmulator    true = 模拟器
     * @param msg           当 isEmulator=true 时有效，返回模拟器品牌
     */
    void OnSuccess(boolean isEmulator,String msg);

    /**
     * 获取模拟器信息失败
     * @param errorCode  失败错误码
     * @param errorMsg   失败原因
     */
    void OnFailed(int errorCode, String errorMsg);
}
