package com.bytedance.ttgame.module.notice.api;

import com.google.gson.annotations.SerializedName;

/**
 *  announcementId String  公告id
 *  scene Int              场景id
 *  language String        语言
 *  title String           标题
 *  targetUrl String       跳转链接
 *  image String           背景图片
 *  inscribe String        落款
 *  content String         内容
 *  stick Int              是否置顶 1 置顶 0 非置顶  （旧版本遗留兼容字段）
 *  startTime Long         活动开始时间
 *  expireTime Long        活动结束时间
 *  frequency Int          速率
 *  encoding String        内容编码格式
 *  buttonText String      按钮文案
 *  priority int           优先级 置顶:0, 置底:-1,自定义:大于0的自然数
 *  times int              公告展示频率，0:每次，-1:仅展示一次, >0:前n次展示
 *  tab String             Tab文案
 *  imageInfoJson String   背景图片额外信息
 *  extra String           额外信息
 */
public class Notice {

    @SerializedName("announcement_id")
    public String announcementId;
    public int scene;
    public String language;
    public String title;
    @SerializedName("target_url")
    public String targetUrl;
    public String image;
    public String inscribe;
    public String content;
    public int stick;
    @SerializedName("start_time")
    public long startTime;
    @SerializedName("expire_time")
    public long expireTime;
    @SerializedName("frequency")
    public int frequency;
    public String encoding;
    @SerializedName("button_text")
    public String buttonText;
    public int priority;
    public int times;
    public String tab;
    @SerializedName("image_info_json")
    public String imageInfoJson;
    public String extra;

    public String getAnnouncementId() {
        return announcementId;
    }

    public int getScene() {
        return scene;
    }

    public String getLanguage() {
        return language;
    }

    public String getTitle() {
        return title;
    }

    public String getTargetUrl() {
        return targetUrl;
    }

    public String getImage() {
        return image;
    }

    public String getInscribe() {
        return inscribe;
    }

    public String getContent() {
        return content;
    }

    public int getStick() {
        return stick;
    }

    public long getStartTime() {
        return startTime;
    }

    public long getExpireTime() {
        return expireTime;
    }

    public int getFrequency() {
        return frequency;
    }

    public String getEncoding() {
        return encoding;
    }

    public String getButtonText() {
        return buttonText;
    }

    public int getPriority() {
        return priority;
    }

    public int getTimes() {
        return times;
    }

    public String getTab() {
        return tab;
    }

    public String getExtra() {
        return extra;
    }

    public String getImageInfoJson() {
        return imageInfoJson;
    }

    @Override
    public String toString() {
        return new StringBuilder()
                .append("announcement_id: " + announcementId).append("\n")
                .append("scene: " + scene).append("\n")
                .append("language: " + language).append("\n")
                .append("title: " + title).append("\n")
                .append("targetUrl: " + targetUrl).append("\n")
                .append("image: " + image).append("\n")
                .append("inscribe: " + inscribe).append("\n")
                .append("content: " + content).append("\n")
                .append("stick: " + stick).append("\n")
                .append("startTime: " + startTime).append("\n")
                .append("expire_time: " + expireTime).append("\n")
                .append("frequncy: " + frequency).append("\n")
                .append("encoding: " + encoding).append("\n")
                .append("button_text: " + buttonText).append("\n")
                .append("priority: " + priority).append("\n")
                .append("times: " + times).append("\n")
                .append("tab: " + tab).append("\n")
                .append("imageInfoJson: " + imageInfoJson).append("\n")
                .append("extra: " + extra).append("\n")
                .toString();
    }
}
