package com.bytedance.ttgame.module.notice.api;

import android.content.Context;
import com.bytedance.ttgame.framework.module.spi.IModuleApi;

import java.util.Map;

public interface INoticeService extends IModuleApi {

    /**
     * 获取公告
     *
     * @param context  Context
     * @param map      访问公告服务器需要的所有参数, 包含以下参数：
     *                 game_language String //游戏当前语言，必传
     *                 game_region String //用户所在地区，必传
     *                 scene Int转为String //公告场景，必传
     *                 server_id String //游戏的服务器区服标记，非必传, 默认传空字符串
     *                 sdk_open_id String //用户的渠道唯一id, 非必传, 默认传空字符串
     *                 zone_id String // 大区唯一标识, 非必传, 默认传空字符串
     *                 role_id String // 角色id，非必传
     * @param callback 回调
     */
    void fetchNotices(Context context, Map<String, String> map, FetchNoticesCallback callback);


    /**
     * 获取公告回调
     */
    interface FetchNoticesCallback {
        /**
         * 成功回调。
         * @param data 获取到的公告数据，后面有说明。
         */
        void onSuccess(ResponseData data);

        /**
         * 失败回调。
         * @param error 错误信息，后面有说明。
         */
        void onFail(NoticeFetchError error);
    }
}
